/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.IDebugMarker;
import com.ca.intertest.debug.debugMarker;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.ITException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.osgi.framework.Bundle;

public class debugMarkerGroup
extends debugMarker
implements IDebugMarker {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    ArrayList<IDebugMarker> children = new ArrayList();

    private debugMarkerGroup(IMemento item, IResource resource) {
        super(item);
        this.setResource(resource);
        IMemento[] markers = item.getChildren("marker");
        this.children = new ArrayList(markers.length);
        IMemento[] iMementoArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento marker = iMementoArray[n2];
            IMemento[] markers2 = marker.getChildren("marker");
            debugMarker debugmarker = null;
            debugmarker = markers2.length > 0 ? new debugMarkerGroup(marker, resource) : new debugMarker(marker);
            debugmarker.setParent(this);
            this.children.add(debugmarker);
            ++n2;
        }
    }

    private debugMarkerGroup(String groupname) {
        super(groupname);
    }

    public debugMarker addChild(debugMarker child) {
        if (this.children.add(child)) {
            child.setParent(this);
            return child;
        }
        return null;
    }

    public void checkChanged() {
        this.checkChanged(this);
        for (IDebugMarker element : this.children) {
            if (element instanceof debugMarkerGroup) {
                ((debugMarkerGroup)element).checkChanged();
                continue;
            }
            this.checkChanged(element);
        }
    }

    public void cleanEnable() {
        this.cleanEnable(false);
    }

    public void disable() {
        this.enabled = false;
        for (IDebugMarker marker : this.children) {
            marker.setEnabled(false);
            if (!(marker instanceof debugMarkerGroup)) continue;
            ((debugMarkerGroup)marker).disable();
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.equals(this.getClass())) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public IDebugMarker[] getChildren() {
        return this.children.toArray(new IDebugMarker[this.children.size()]);
    }

    @Override
    public ArrayList<IDebugMarker> getEnabled() {
        ArrayList<IDebugMarker> list = new ArrayList<IDebugMarker>();
        if (this.enabled) {
            list.add(this);
        }
        for (IDebugMarker child : this.children) {
            list.addAll(child.getEnabled());
        }
        return list;
    }

    @Override
    public IDebugMarker getMarker(IMarker key) {
        if (this.marker != null && this.marker.equals((Object)key)) {
            return this;
        }
        for (IDebugMarker element : this.children) {
            IDebugMarker got_it = element.getMarker(key);
            if (got_it == null) continue;
            return got_it;
        }
        return null;
    }

    @Override
    public IDebugMarker getMarker(short commandID) {
        if (super.getMarker(commandID) != null) {
            return this;
        }
        for (IDebugMarker element : this.children) {
            IDebugMarker got_it = element.getMarker(commandID);
            if (got_it == null) continue;
            return got_it;
        }
        return null;
    }

    @Override
    public int getType() {
        return 2;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void refresh(CheckboxTreeViewer viewer) {
        boolean grayed = viewer.getGrayed((Object)this);
        boolean checked = viewer.getChecked((Object)this);
        if (grayed) {
            checked = false;
        }
        this.setEnabled(checked);
        for (IDebugMarker marker : this.children) {
            if (marker instanceof debugMarkerGroup) {
                ((debugMarkerGroup)marker).refresh(viewer);
                continue;
            }
            marker.setEnabled(viewer.getChecked((Object)marker));
        }
    }

    public void removeChild(debugMarker child) {
        child.setParent(null);
        this.children.remove(child);
    }

    @Override
    public void save() {
        super.save();
        for (IDebugMarker marker : this.children) {
            marker.save();
        }
    }

    public void setAttribute(String key, String value) {
        IDebugMarker[] iDebugMarkerArray = this.getChildren();
        int n = iDebugMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugMarker item = iDebugMarkerArray[n2];
            item.setAttribute(key, value);
            ++n2;
        }
        super.setAttribute(key, value);
    }

    @Override
    public boolean setMarker(IMarker marker) {
        return this.setMarker(marker, false);
    }

    @Override
    public boolean setMarker(IMarker marker, boolean force) {
        boolean done = super.setMarker(marker, force);
        if (!done) {
            for (IDebugMarker child : this.children) {
                done = child.setMarker(marker, force);
                if (done) break;
            }
        }
        return done;
    }

    @Override
    public void setRBP_Type(int flag) {
        IDebugMarker[] iDebugMarkerArray = this.getChildren();
        int n = iDebugMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDebugMarker item = iDebugMarkerArray[n2];
            item.setRBP_Type(flag);
            ++n2;
        }
        super.setRBP_Type(flag);
    }

    @Override
    public void setResource(IResource resource) {
        super.setResource(resource);
        for (IDebugMarker element : this.children) {
            element.setResource(resource);
        }
    }

    private void checkChanged(IDebugMarker marker) {
        IMarker imarker = marker.getMarker();
        if (imarker != null) {
            boolean oldenable = imarker.getAttribute("BREAKPOINT_ENABLED", false);
            this.changed = oldenable != this.enabled;
        }
    }

    private void cleanEnable(boolean clean) {
        if (clean) {
            this.setEnabled(false);
        } else {
            boolean all = true;
            for (IDebugMarker element : this.children) {
                if (element.isEnabled()) continue;
                all = false;
                break;
            }
            if (all) {
                this.setEnabled(true);
            }
        }
        if (this.enabled) {
            if (this.isDummy()) {
                this.setEnabled(false);
                for (IDebugMarker element : this.children) {
                    element.setEnabled(true);
                    if (!(element instanceof debugMarkerGroup)) continue;
                    ((debugMarkerGroup)element).cleanEnable(false);
                }
            } else {
                for (IDebugMarker element : this.children) {
                    element.setEnabled(false);
                    if (!(element instanceof debugMarkerGroup)) continue;
                    ((debugMarkerGroup)element).cleanEnable(true);
                }
            }
        } else {
            for (IDebugMarker element : this.children) {
                if (element instanceof debugMarkerGroup) {
                    ((debugMarkerGroup)element).cleanEnable(clean);
                    continue;
                }
                if (!clean) continue;
                element.setEnabled(false);
            }
        }
    }

    public static debugMarkerGroup LoadMarkers(IDebug debugit) throws ITException {
        URL markerURL = null;
        debugSession session = debugit.getSession();
        debugMarkerGroup group = null;
        try {
            IMemento marker;
            int n;
            int n2;
            IMemento[] iMementoArray;
            InputStream urlStream = null;
            InputStreamReader urlReader = null;
            String projtype = session.getProjectType();
            Bundle bundle = IntertestPlugin.getDefault().getBundle();
            if (bundle == null) {
                throw new ITException(Messages.debugMarkerGroup_3);
            }
            markerURL = bundle.getEntry("debugmarkers.xml");
            if (markerURL == null) {
                throw new ITException(Messages.debugMarkerGroup_5);
            }
            urlStream = markerURL.openStream();
            if (urlStream == null) {
                throw new ITException(Messages.debugMarkerGroup_6);
            }
            urlReader = new InputStreamReader(urlStream);
            if (urlReader == null) {
                throw new ITException(Messages.debugMarkerGroup_7);
            }
            XMLMemento memento = XMLMemento.createReadRoot((Reader)urlReader);
            IMemento root = memento.getChild(projtype);
            if (root == null) {
                throw new ITException(String.valueOf(Messages.debugMarkerGroup_8) + projtype);
            }
            if (session.isCICS()) {
                IMemento[] markers;
                iMementoArray = markers = root.getChildren("marker");
                n2 = markers.length;
                n = 0;
                while (n < n2) {
                    marker = iMementoArray[n];
                    if ("-2".equals(marker.getString("cmd"))) {
                        String[] uexis = session.getUEXIT(false);
                        int ix = 0;
                        while (ix < uexis.length) {
                            if (uexis[ix] != null) {
                                IMemento child1 = marker.createChild("marker");
                                child1.putTextData(uexis[ix]);
                                String cmd = String.format("0x00%02X", ix);
                                child1.putString("cmd", cmd);
                            }
                            ++ix;
                        }
                    }
                    ++n;
                }
            }
            group = new debugMarkerGroup(root, debugit.getResource());
            group.setRBP_Type(0);
            IDebugMarker uexit = group.getMarker((short)-2);
            if (uexit != null && session.isCICS()) {
                uexit.setRBP_Type(uexit.getRBP_Type() | 0x80);
            }
            iMementoArray = debugMarkerGroup.getRBPMarkers(debugit.getResource());
            n2 = iMementoArray.length;
            n = 0;
            while (n < n2) {
                marker = iMementoArray[n];
                if (!group.setMarker((IMarker)marker)) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException e) {
                        Logger.loggit(e);
                    }
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new ITException(Messages.debugMarkerGroup_14);
        }
        catch (WorkbenchException workbenchException) {
            throw new ITException(Messages.debugMarkerGroup_14);
        }
        group.setResource(debugit.getResource());
        return group;
    }

    private static IMarker[] getRBPMarkers(IResource resource) {
        IMarker[] markers = null;
        try {
            markers = resource.findMarkers("com.ca.intertest.breakpoint.rbp", false, 0);
            ArrayList<IMarker> results = new ArrayList<IMarker>(markers.length);
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                results.add(marker);
                ++n2;
            }
            return results.toArray(new IMarker[results.size()]);
        }
        catch (CoreException coreException) {
            return null;
        }
    }
}

