/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.SynchSymbolicMessage;
import com.ca.intertest.tools.SynchronizeMessage;
import com.ca.intertest.wizards.SelectSymbolicWizard;
import com.ca.intertest.wizards.SymbolicWizardDialog;

final class SynchSymbolic
implements Runnable {
    private final SynchSymbolicMessage synchsymbol;
    private final SynchronizeMessage synchmsg;
    private final debugSession session;
    private debugFile file = null;
    private boolean monitor = true;

    SynchSymbolic(debugSession session, SynchSymbolicMessage synchsymbol, SynchronizeMessage synchmsg) {
        this.session = session;
        this.synchsymbol = synchsymbol;
        this.synchmsg = synchmsg;
    }

    @Override
    public void run() {
        SelectSymbolicWizard wizard = new SelectSymbolicWizard(this.session, this.synchmsg);
        SymbolicWizardDialog dialog = new SymbolicWizardDialog(null, wizard);
        dialog.create();
        int result = dialog.open();
        try {
            SynchronizeMessage.SynchProtsym prot = wizard.getProtsym();
            switch (result) {
                case 0: {
                    int ix = this.synchmsg.getProtsyms().indexOf(prot) + 1;
                    this.synchsymbol.setSelection(ix);
                    this.synchsymbol.setSubmessageID((short)1);
                    this.synchsymbol.setDDName(prot.getDDName());
                    this.synchsymbol.setDSN(prot.getDSN());
                    this.synchsymbol.setDate(prot.getDate());
                    this.synchsymbol.setTime(prot.getTime());
                    break;
                }
                case 1: {
                    this.synchsymbol.setSubmessageID((short)3);
                    this.file = this.session.getFile(this.synchmsg.getProgram());
                    this.monitor = false;
                    break;
                }
                case 1024: {
                    this.monitor = false;
                    this.synchsymbol.setSubmessageID((short)2);
                }
            }
        }
        catch (ITException e) {
            Logger.loggit(e);
        }
    }

    public debugFile getFile() {
        if (!this.monitor) {
            if (this.file != null && this.synchsymbol.getSubmessageID() != 2) {
                this.file.setMonitor(false, false);
                this.file = null;
            }
        } else {
            this.file = this.session.refreshFile(this.synchsymbol.getProgram(), this.synchsymbol.getDSN(), true, false, true, this.synchsymbol.getDate(), this.synchsymbol.getTime(), "SynchSymbolic");
        }
        return this.file;
    }
}

