/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.DebugSessionSetup;
import com.ca.intertest.debug.InitMessage;
import com.ca.intertest.debug.debugBatchSession;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.BatchConnection;
import com.ca.intertest.server.Connection;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.GDSNMessage;
import com.ca.intertest.tools.ITException;

public class DebugBatchSessionSetup
extends DebugSessionSetup {
    static String cacopyright = "Copyright \u00a9 2016 CA";

    public DebugBatchSessionSetup(debugSession session) throws ITException, Exception {
        super(session);
    }

    @Override
    protected boolean connect() {
        boolean result = false;
        try {
            this.connection = new BatchConnection(this.server);
            result = this.connection.connect(true);
        }
        catch (Exception e) {
            Logger.loggit(e);
        }
        return result;
    }

    @Override
    public int launch() throws Exception {
        int rc = -1;
        this.cvmi = new CVMI();
        this.session.setDebug();
        this.cvmi.addMessage((DebugMessage)new InitMessage(this.session));
        for (String item : ((debugBatchSession)this.session).getProtsymlist()) {
            GDSNMessage msg = new GDSNMessage();
            msg.setDSName(item);
            this.cvmi.addMessage((DebugMessage)msg);
        }
        int count = this.cvmi.size();
        this.session.buildBreakpointQueue();
        this.session.getQueue().buildMonitoredList(this.cvmi);
        if (this.cvmi.size() == count) {
            throw new ITException(Messages.DebugBatchSessionSetup_0);
        }
        CVMO cvmo = this.connection.process(this.cvmi);
        Connection.displayError(cvmo, Messages.DebugBatchSessionSetup_1);
        rc = this.connection.getErrorLevel();
        this.connection.disconnect();
        if (rc == 0) {
            debugEvent event = new debugEvent((Object)this.cvmi, null);
            this.session.fireDebugMessageListeners(event);
        } else {
            this.session.resetDebug();
        }
        return rc;
    }
}

