/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.attributes.Attribute;
import com.ca.intertest.common.DummyListing;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Member;
import com.ca.intertest.common.Messages;
import com.ca.intertest.common.ResourceProperty;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.FileConnection;
import com.ca.intertest.tools.BuildListing;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileName;
import com.ca.intertest.tools.FileNameExtended;
import com.ca.intertest.tools.FileReceiveMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IStatusMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.MemberInfoExtended;
import com.ca.intertest.tools.RMBRMessage;
import com.ca.intertest.tools.XMLFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class LoadListing {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String REASON_TEXT = String.valueOf(Messages.LoadListing_0) + IConstants.LINEFEED + Messages.LoadListing_1 + IConstants.LINEFEED + Messages.LoadListing_20;
    private final Member member;
    private final FileConnection connection;
    private final debugFile debugfile;
    private InterruptedException interrupt = null;
    private File zipfile;
    private int result = -1;
    public static final int FILEEQUAL = 0;
    public static final int FILELOADED = 1;
    public static final int FILEDUMMY = 2;
    public static final int FILEERROR = -1;
    final IFile filelisting;
    ResourceProperty store = null;
    private debugSession session;
    private String reasonText;
    private BuildListing buildListing;

    public LoadListing(FileConnection connection, Member member, debugSession session, String reasonText) {
        this.member = member;
        boolean monitor = member.isMonitor();
        this.connection = connection;
        this.session = session;
        this.reasonText = reasonText;
        this.debugfile = session.getFile(member.getName());
        if (this.debugfile == null) {
            this.store = null;
            this.filelisting = ((IProject)session.getResource()).getFile(String.valueOf(member.getName()) + ".intertest");
        } else {
            Map.Entry[] items;
            this.store = this.debugfile.getStore();
            this.filelisting = (IFile)this.debugfile.getResource();
            String storeName = this.store.getAttributes().get("name");
            String storeLang = this.store.getAttributes().get("gt_m_lang");
            String storeDate = this.store.getAttributes().get("gt_m_jul");
            String storeTime = this.store.getAttributes().get("gt_m_tim");
            if (reasonText != null && reasonText.equals("IMPORT")) {
                reasonText = null;
                if (storeName != null && storeLang != null && storeDate != null && storeTime != null && !member.isOverwrite() && member.getName().equalsIgnoreCase(storeName) && member.getAttribute("gt_m_lang").equals(storeLang) && member.getSelectedDate() == Integer.parseInt(storeDate) && member.getSelectedTime() == Integer.parseInt(storeTime)) {
                    this.result = 0;
                    member.setMonitor(monitor);
                    return;
                }
            }
            Set<Map.Entry<String, String>> set = this.store.getAttributes().entrySet();
            Map.Entry[] entryArray = items = set.toArray(new Map.Entry[set.size()]);
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Map.Entry entry = entryArray[n2];
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key != null) {
                    member.setAttribute(key.toString(), value == null ? null : value.toString());
                }
                ++n2;
            }
            member.setDate(0);
            member.setTime(0);
            member.setTimestamp((Calendar)Attribute.getValue("time", this.store));
            member.setMonitor(monitor);
        }
    }

    public void run() throws Exception {
        if (this.result == 0) {
            this.store = ResourceProperty.getStore((IResource)this.filelisting);
            this.store.setValue("monitor_pgm", this.member.isMonitor());
            this.store.save();
            this.filelisting.refreshLocal(0, null);
            return;
        }
        if (this.member.getDsn().length() == 0) {
            this.buildDummy((Exception)((Object)new ITException(Messages.LoadListing_3)), this.member);
            this.result = 2;
            return;
        }
        if (this.member.isOverwrite() || !this.filelisting.exists()) {
            this.member.setDate(-1);
            this.member.setTime(-1);
        }
        try {
            if (!this.connection.connect(true)) {
                throw new ITException(this.connection.getErrorText());
            }
        }
        catch (Exception e) {
            this.connection.disconnect(true);
            this.throwError(e);
            return;
        }
        CVMO cvmo = this.connection.getfile(this.member);
        if (this.connection.getErrorLevel() != 0) {
            this.throwError((Exception)((Object)new ITException(this.connection.getErrorText())));
            return;
        }
        DebugMessage msg = cvmo.getMessage(1);
        if (msg == null) {
            this.throwError((Exception)((Object)new ITException(Messages.LoadListing_4)));
            return;
        }
        if (msg.getMessageID() == 18) {
            this.result = 0;
            return;
        }
        RMBRMessage message = (RMBRMessage)msg;
        MemberInfoExtended info = message.getMember();
        if (info != null) {
            info.setAttribute("time", HexUtil.TimeStampString((int)info.getDate(), (int)info.getTime()));
            XMLFile source = new XMLFile();
            Element cmd = source.setCommand("getfile");
            cmd.setAttribute("dsn", this.member.getDsn());
            cmd.setAttribute("name", this.member.getName());
            for (Map.Entry item : info.getAttributes().entrySet()) {
                this.member.setAttribute((String)item.getKey(), (String)item.getValue());
            }
            Element xmlmember = this.member.xmlMember(source);
            InputStream listingStream = this.getListingFile(source, this.connection, message.getListing().getDSN(), source.getRecordCount(xmlmember), this.filelisting);
            InputStream varialblesStream = this.getVariables(source, this.connection, message.getVariables().getDSN());
            InputStream labelsStream = this.getLabels(source, this.connection, message.getLabels().getDSN());
            FileName verbs = message.getVerbs();
            InputStream verbsStream = verbs == null ? null : this.getVerbs(source, this.connection, verbs.getDSN());
            xmlmember.setAttribute("com.ca.intertest", "true");
            xmlmember.setAttribute("server", this.connection.getServer().getName());
            int date = (Integer)Attribute.getValue((String)"gt_m_jul", (Element)xmlmember);
            int time = (Integer)Attribute.getValue((String)"gt_m_tim", (Element)xmlmember);
            xmlmember.setAttribute("time", HexUtil.TimeStampString((int)date, (int)time));
            this.buildListing = new BuildListing(source, listingStream, verbsStream, labelsStream, varialblesStream);
            if (this.buildListing.build() != 0) {
                throw new ITException("file build failed");
            }
            NamedNodeMap xmlattrs = xmlmember.getAttributes();
            int i = 0;
            while (i < xmlattrs.getLength()) {
                Attr attr = (Attr)xmlattrs.item(i);
                String value = attr.getValue().trim();
                if (value.length() != 0) {
                    info.setAttribute(attr.getName(), value);
                }
                ++i;
            }
            this.zipfile = this.buildListing.getZipfile();
            FileInputStream zip = new FileInputStream(this.zipfile);
            if (this.filelisting.exists()) {
                ResourceAttributes attrs = this.filelisting.getResourceAttributes();
                if (attrs != null && attrs.isReadOnly()) {
                    attrs.setReadOnly(false);
                    this.filelisting.setResourceAttributes(attrs);
                }
                this.filelisting.setContents((InputStream)zip, true, true, null);
            } else {
                this.filelisting.create((InputStream)zip, true, null);
            }
            this.result = 1;
            this.store = ResourceProperty.getStore((IResource)this.filelisting);
            for (Map.Entry item : info.getAttributes().entrySet()) {
                this.store.setValue((String)item.getKey(), (String)item.getValue());
            }
            if (this.member.isMonitor() && this.session.isCICS()) {
                boolean post = true;
                if (this.reasonText != null && (this.reasonText.equalsIgnoreCase("SynchSymbolic2") || this.reasonText.equalsIgnoreCase("SynchSymbolic"))) {
                    post = false;
                }
                this.session.getFile(this.member.getName()).setMonitor(true, post);
            } else {
                this.store.setValue("monitor_pgm", this.member.isMonitor());
                this.store.save();
            }
            this.filelisting.refreshLocal(0, null);
        }
        try {
            Debug.getInstance().addDebugSession((IResource)this.filelisting);
        }
        catch (ITException e) {
            Logger.loggit(e);
        }
    }

    public void buildDummy(Exception e, Member member) {
        String msg = e == null ? "" : HexUtil.getErrorText((Throwable)e);
        String filetext = member.getName();
        StringBuilder text = new StringBuilder(String.format(REASON_TEXT, filetext, msg));
        if (this.reasonText != null && this.reasonText.length() != 0) {
            text.append(IConstants.LINEFEED);
            text.append(this.reasonText);
        }
        DummyListing dummy = new DummyListing(member, this.session);
        dummy.setListingtext(text.toString());
        dummy.build();
    }

    private InputStream getVerbs(XMLFile xml, FileConnection connection, String tempfile) throws ITException {
        try {
            connection.connect(true);
            FileNameExtended verbsfile = new FileNameExtended(new FileName(4, tempfile));
            verbsfile.setCR(false);
            verbsfile.setStream(true);
            verbsfile.setDelete(true);
            CVMO cvmo = connection.getFile(verbsfile);
            DebugMessage message = cvmo.getMessage(1);
            if (message instanceof FileReceiveMessage) {
                FileReceiveMessage receive = (FileReceiveMessage)message;
                return receive.getInputstream();
            }
            if (message instanceof IStatusMessage) {
                IStatusMessage status = (IStatusMessage)message;
                throw new ITException(status.getMessage());
            }
            throw new ITException(Messages.LoadListing_10);
        }
        catch (Exception e) {
            Logger.loggit(e);
            throw new ITException(HexUtil.getErrorText((Throwable)e));
        }
    }

    private InputStream getVariables(XMLFile xml, FileConnection connection, String tempfile) throws ITException {
        try {
            connection.connect(true);
            FileNameExtended variablesfile = new FileNameExtended(new FileName(4, tempfile));
            variablesfile.setCR(true);
            variablesfile.setDelete(true);
            CVMO cvmo = connection.getFile(variablesfile);
            DebugMessage message = cvmo.getMessage(1);
            if (message instanceof FileReceiveMessage) {
                FileReceiveMessage receive = (FileReceiveMessage)message;
                return receive.getInputstream();
            }
            if (message instanceof IStatusMessage) {
                IStatusMessage status = (IStatusMessage)message;
                throw new ITException(status.getMessage());
            }
            throw new ITException(Messages.LoadListing_11);
        }
        catch (Exception e) {
            Logger.loggit(e);
            throw new ITException((Throwable)e);
        }
    }

    private InputStream getLabels(XMLFile xml, FileConnection connection, String tempfile) throws ITException {
        try {
            connection.connect(true);
            FileNameExtended labelsfile = new FileNameExtended(new FileName(4, tempfile));
            labelsfile.setCR(true);
            labelsfile.setDelete(true);
            CVMO cvmo = connection.getFile(labelsfile);
            DebugMessage message = cvmo.getMessage(1);
            if (message instanceof FileReceiveMessage) {
                FileReceiveMessage receive = (FileReceiveMessage)message;
                return receive.getInputstream();
            }
            if (message instanceof IStatusMessage) {
                IStatusMessage status = (IStatusMessage)message;
                throw new InterruptedException(status.getMessage());
            }
            throw new InterruptedException(Messages.LoadListing_12);
        }
        catch (Exception e) {
            Logger.loggit(e);
            throw new ITException((Throwable)e);
        }
    }

    private InputStream getListingFile(XMLFile source, FileConnection connection, String tempfile, int records, IFile filelisting) throws ITException {
        block6: {
            try {
                FileNameExtended listingfile = new FileNameExtended(new FileName(4, tempfile));
                listingfile.setASA(true);
                listingfile.setRecLength(133);
                listingfile.setDelete(true);
                CVMO cvmo = connection.getFile(listingfile);
                DebugMessage message = cvmo.getMessage(1);
                if (message.getMessageID() == 20) {
                    try {
                        return ((FileReceiveMessage)message).getFile().getInputstream();
                    }
                    catch (Exception e) {
                        Logger.loggit(e);
                        break block6;
                    }
                }
                if (message.getMessageID() == 18) {
                    IStatusMessage status = (IStatusMessage)message;
                    throw new ITException(status.getMessage());
                }
                throw new ITException(Messages.LoadListing_18);
            }
            catch (Exception e) {
                Logger.loggit(e);
                throw new ITException((Throwable)e);
            }
        }
        return null;
    }

    public InterruptedException getInterrupt() {
        return this.interrupt;
    }

    public int getResult() {
        return this.result;
    }

    public void throwError(Exception e) throws Exception {
        this.showError(e);
        throw e;
    }

    public void showError(Exception e) {
        final String msg = HexUtil.getErrorText((Throwable)e);
        this.interrupt = new InterruptedException(msg);
        Logger.loggit(e);
        final String filetext = this.member.getName();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning(null, (String)Messages.LoadListing_19, (String)String.format(REASON_TEXT, filetext, msg));
            }
        });
        this.result = -1;
    }
}

