/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.common.IT_TreeItem;
import com.ca.intertest.common.Logger;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.part.ResourceTransfer;

public class DropDebugFile
extends ViewerDropAdapter {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected static final Debug debug = Debug.getInstance();

    public DropDebugFile(Viewer viewer) {
        super(viewer);
    }

    public boolean performDrop(Object data) {
        if (!(data instanceof IResource[])) {
            return false;
        }
        IResource[] source = (IResource[])data;
        if (source.length < 1) {
            return false;
        }
        Object target = this.getCurrentTarget();
        debugSession sourcesession = debug.getSession((IResource)source[0].getProject());
        debugSession targetsession = null;
        IT_TreeItem treeitem = null;
        boolean forcemonitor = false;
        boolean monitor = false;
        if (target instanceof IT_TreeItem) {
            treeitem = (IT_TreeItem)target;
            switch (treeitem.getType()) {
                case SESSION: {
                    target = treeitem.getObj();
                    break;
                }
                case TAG: {
                    forcemonitor = true;
                    monitor = "MONITORED".equals(treeitem.getObj());
                    targetsession = (debugSession)treeitem.getParent().getObj();
                    if (targetsession.equals(sourcesession)) {
                        IResource[] iResourceArray = source;
                        int n = source.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource res = iResourceArray[n2];
                            debugFile file = sourcesession.getFile(res);
                            if (file != null) {
                                file.setMonitor(monitor);
                            }
                            ++n2;
                        }
                        return true;
                    }
                    target = targetsession;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (target instanceof debugSession) {
            targetsession = (debugSession)target;
            if (target.equals(sourcesession)) {
                return false;
            }
            IProject newsession = (IProject)targetsession.getResource();
            IPath path = newsession.getFullPath();
            try {
                newsession.getWorkspace().copy(source, path, 1, null);
                if (forcemonitor) {
                    IResource[] iResourceArray = source;
                    int n = source.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IResource res = iResourceArray[n3];
                        debugFile file = targetsession.getFile(res);
                        if (file != null) {
                            file.setMonitor(monitor);
                        }
                        ++n3;
                    }
                }
                this.getViewer().refresh();
                return true;
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (ResourceTransfer.getInstance().isSupportedType(transferType) && target instanceof IT_TreeItem) {
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            Object source = selection.getFirstElement();
            switch (((IT_TreeItem)target).getType()) {
                case SESSION: {
                    debugSession targetsession = (debugSession)((IT_TreeItem)target).getObj();
                    debugFile sourcefile = (debugFile)((IT_TreeItem)source).getObj();
                    debugSession sourcesession = sourcefile.getSession();
                    if (targetsession.equals(sourcesession)) {
                        return false;
                    }
                    if (this.getCurrentLocation() != 3) break;
                    return true;
                }
                case TAG: {
                    switch (this.getCurrentLocation()) {
                        case 2: 
                        case 3: {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }
}

