/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.IParseSource;
import com.ca.intertest.tools.XMLFile;
import com.ca.intertest.tools.XMLRequest;
import com.ca.intertest.tools.parseSource;
import com.ca.intertest.tools.scanPLI;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Element;

public class parsePLI
extends parseSource
implements IParseSource {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final String[] unusedAttrs = new String[]{"gt_picl", "gt_pvsln", "gt_name", "gt_pvdcl", "gt_pvoff", "pl1estmt", "lablstmt", "pl1ename", "lablname"};

    public parsePLI(XMLFile xml, Element member) {
        super(xml, member);
        this.scansource = new scanPLI(member.getAttribute("gt_m_plc"));
        this.lang = 128;
    }

    @Override
    void parseVariableElement(Element variable) {
        String level = variable.getAttribute("gt_pvsln");
        if (level.equals("0")) {
            level = "1";
        }
        String name = variable.getAttribute("gt_name");
        String stmt = variable.getAttribute("gt_pvdcl");
        String offset = variable.getAttribute("gt_pvoff");
        String structureoffset = variable.getAttribute("gt_pvsof");
        variable.setAttribute("name", name);
        variable.setAttribute("level", level);
        variable.setAttribute("offset", offset);
        variable.setAttribute("structureoffset", structureoffset);
        variable.setAttribute("statementnumber", stmt);
        this.removeUnusedAttrs(variable, unusedAttrs);
    }

    @Override
    void parseLabelElement(Element label) {
        String name;
        String level = "0";
        String stmt = label.getAttribute("lablstmt");
        if (stmt == null || stmt.length() == 0) {
            name = label.getAttribute("pl1ename");
            stmt = label.getAttribute("pl1estmt");
            String btyp = label.getAttribute("pl1ebtyp");
            if (btyp.equals("4")) {
                level = "1";
            }
        } else {
            name = label.getAttribute("lablname");
        }
        label.setAttribute("statementnumber", stmt);
        label.setAttribute("level", level);
        label.setAttribute("offset", "0");
        label.setAttribute("name", name);
        this.removeUnusedAttrs(label, unusedAttrs);
    }

    @Override
    Comparator<Element> getComparator() {
        return null;
    }

    @Override
    void parseLine(String line, int statementnumber, int linenumber) {
    }

    @Override
    protected Element getParent(Element oldParent, Element item) {
        if (oldParent.getTagName().equals("symbols")) {
            return oldParent;
        }
        int parentLevel = XMLRequest.getInt("level", oldParent);
        int itemLevel = XMLRequest.getInt("level", item);
        if (itemLevel <= parentLevel) {
            return this.getParent((Element)oldParent.getParentNode(), item);
        }
        return oldParent;
    }

    @Override
    protected boolean checkExcludeVariable(Element variable) {
        return true;
    }

    @Override
    protected int checkLevel1() {
        String name = "";
        Set elementSet = this.elements.keySet();
        Iterator it = elementSet.iterator();
        int totlth = 0;
        String saveName = "";
        int saveFsiz = 0;
        int structCnt = 0;
        boolean ok = false;
        while (it.hasNext()) {
            Element item0 = (Element)it.next();
            name = item0.getAttribute("name");
            int lev = Integer.valueOf(item0.getAttribute("level"));
            if (!ok && lev == 1) {
                ok = true;
            }
            if (!ok) continue;
            if (lev == 1) {
                if (totlth > 0 && saveFsiz == 0) {
                    this.structs.add(saveName);
                    this.structSizes.add(totlth);
                    ++structCnt;
                }
                totlth = 0;
                saveName = name;
                String strFsiz = item0.getAttribute("gt_fsiz");
                saveFsiz = strFsiz.length() > 0 ? Integer.valueOf(strFsiz) : 0;
                continue;
            }
            if (lev <= 1) continue;
            totlth += Integer.valueOf(item0.getAttribute("length")).intValue();
        }
        if (totlth > 0 && saveFsiz == 0) {
            this.structs.add(saveName);
            this.structSizes.add(totlth);
            ++structCnt;
        }
        return structCnt;
    }

    @Override
    protected void loadLevel1(Element item, int structCnt) {
        if (structCnt == 0) {
            return;
        }
        String eName = item.getAttribute("name");
        int i = 0;
        for (String name : this.structs) {
            if (name.equals(eName)) {
                String sLth = Integer.toString((Integer)this.structSizes.get(i));
                item.setAttribute("length", sLth);
                return;
            }
            ++i;
        }
    }
}

