/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.CobolSpecialRegisters;
import com.ca.intertest.tools.IParseSource;
import com.ca.intertest.tools.StatementType;
import com.ca.intertest.tools.Token;
import com.ca.intertest.tools.XMLFile;
import com.ca.intertest.tools.XMLRequest;
import com.ca.intertest.tools.parseSource;
import com.ca.intertest.tools.scanCOBOL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class parseCOBOL
extends parseSource
implements IParseSource {
    static String cacopyright = "Copyright (c) 2016 CA";
    private static final String DATA = "DATA";
    private static final String PROCEDURE = "PROCEDURE";
    private static final String SECTION = "SECTION";
    private static final String DIVISION = "DIVISION";
    private int prevEvel = 0;
    private int prevDatst = 0;
    private int subStatement = 0;
    private String division = "";
    private static final String[] unusedAttrs = new String[]{"gt_picl", "gt_evel", "gt_name", "gt_datst", "lablstmt", "lablname"};
    private static final Pattern pattern = Pattern.compile("[a-zA-Z0-9\\-]+");
    private Matcher matcher;
    private ArrayList<Token> tokens = new ArrayList(10);
    private int curBaseOffset = 0;
    private int curCell = 0;

    public parseCOBOL(XMLFile xml, Element member) {
        super(xml, member);
        this.scansource = new scanCOBOL(member.getAttribute("gt_m_cty"));
        this.lang = 32;
    }

    @Override
    void parseVariableElement(Element variable) {
        String name = variable.getAttribute("gt_name");
        int level = XMLRequest.getInt("gt_evel", variable);
        int stmt = XMLRequest.getInt("gt_datst", variable);
        int disp = XMLRequest.getInt("gt_disp", variable);
        int cell = XMLRequest.getInt("gt_cell", variable);
        if (stmt == 0) {
            stmt = this.prevDatst;
            ++this.subStatement;
        } else {
            this.prevDatst = stmt;
            this.subStatement = 0;
        }
        switch (level) {
            case 66: 
            case 88: {
                level = this.prevEvel + 1;
                break;
            }
            case 77: {
                level = 1;
            }
            default: {
                this.prevEvel = level;
            }
        }
        int offset = 0;
        if (level == 1) {
            this.curBaseOffset = disp;
            this.curCell = cell;
        } else if (level != 99) {
            offset = (cell - this.curCell) * 4096 + disp - this.curBaseOffset;
        }
        variable.setAttribute("name", name);
        variable.setAttribute("level", Integer.toString(level));
        variable.setAttribute("offset", "0");
        variable.setAttribute("structureoffset", Integer.toString(offset));
        variable.setAttribute("statementnumber", Integer.toString(stmt));
        if (this.subStatement > 0) {
            variable.setAttribute("statement_sub_number", Integer.toString(this.subStatement));
        }
        this.removeUnusedAttrs(variable, unusedAttrs);
    }

    @Override
    void parseLabelElement(Element label) {
        String stmt = label.getAttribute("lablstmt");
        label.setAttribute("statementnumber", stmt);
        label.setAttribute("level", "1");
        label.setAttribute("offset", "0");
        label.setAttribute("name", label.getAttribute("lablname"));
        this.removeUnusedAttrs(label, unusedAttrs);
    }

    @Override
    Comparator<Element> getComparator() {
        return null;
    }

    @Override
    void parseLine(String line, int statementnumber, int linenumber) {
        String tknvalue;
        this.tokens.clear();
        String source = this.scansource.getSourceSegment(line);
        this.matcher = pattern.matcher(source);
        this.matcher.region(1, this.matcher.regionEnd());
        while (this.matcher.find()) {
            this.tokens.add(new Token(this.matcher.start(), this.matcher.end(), this.matcher.group()));
        }
        if (this.tokens.isEmpty() || this.tokens.get(0).getStart() > 10) {
            return;
        }
        if (this.tokens.size() > 1 && ((tknvalue = this.tokens.get(1).getToken().toUpperCase()).equals(DIVISION) || tknvalue.equals(SECTION))) {
            String level;
            if (tknvalue.equals(DIVISION)) {
                this.division = this.tokens.get(0).getToken().toUpperCase();
                level = "-2";
            } else {
                if (this.division.equals(PROCEDURE)) {
                    return;
                }
                level = "-1";
            }
            Element label = this.xml.createElement("pgmstructure");
            label.setAttribute("statementnumber", Integer.toString(statementnumber));
            label.setAttribute("level", level);
            label.setAttribute("offset", "0");
            label.setAttribute("name", String.valueOf(this.tokens.get(0).getToken()) + " " + this.tokens.get(1).getToken());
            label.setAttribute("linenumber", Integer.toString(linenumber));
            this.elements.put(label, null);
            if (this.tokens.get(0).getToken().toUpperCase().equals(DATA) && this.tokens.get(1).getToken().toUpperCase().equals(DIVISION)) {
                this.loadSpecialRegisters(statementnumber, linenumber);
            }
            this.addVerb(StatementType.NOOP.name(), null, statementnumber, 0, linenumber, 0);
            return;
        }
    }

    protected void loadSpecialRegisters(int statementnumber, int linenumber) {
        this.prevDatst = statementnumber;
        this.subStatement = 1;
        Element label = this.xml.createElement("variable");
        label.setAttribute("statementnumber", Integer.toString(statementnumber));
        label.setAttribute("level", "-1");
        label.setAttribute("offset", "1");
        label.setAttribute("name", "SPECIAL-REGISTERS");
        label.setAttribute("linenumber", Integer.toString(linenumber));
        label.setAttribute("statement_sub_number", Integer.toString(this.subStatement++));
        this.elements.put(label, null);
        Element[] elementArray = CobolSpecialRegisters.getSpecVars(this.xml, statementnumber, linenumber);
        int n = elementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Element specvar = elementArray[n2];
            specvar.setAttribute("statement_sub_number", Integer.toString(this.subStatement++));
            this.elements.put(specvar, null);
            ++n2;
        }
    }

    @Override
    protected Element getParent(Element oldParent, Element item) {
        if (oldParent.getTagName().equals("symbols")) {
            return oldParent;
        }
        int parentLevel = XMLRequest.getInt("level", oldParent);
        int itemLevel = XMLRequest.getInt("level", item);
        if (itemLevel <= parentLevel) {
            return this.getParent((Element)oldParent.getParentNode(), item);
        }
        return oldParent;
    }

    @Override
    protected boolean checkExcludeVariable(Element variable) {
        int level = XMLRequest.getInt("gt_evel", variable);
        return level != 88;
    }

    @Override
    protected int checkLevel1() {
        return 0;
    }

    @Override
    protected void loadLevel1(Element item, int structCnt) {
    }
}

