/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.IXMLRequest;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Messages;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class XMLRequest
implements Serializable,
IXMLRequest {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String version = Messages.getString("XMLRequest.version");
    private Document document = null;
    private Element root = null;
    private Transformer xformer = null;

    protected XMLRequest(String service) {
        this.newDocument(service);
    }

    protected XMLRequest(IXMLRequest xml) throws ITException {
        this("unknown");
        this.fromString(xml.toString());
    }

    public XMLRequest(File file) throws ITException {
        this("unknown");
        try {
            FileReader inReader = new FileReader(file);
            InputSource input = new InputSource(inReader);
            this.buildXML(input, file.getName());
        }
        catch (FileNotFoundException e) {
            throw new ITException(e);
        }
    }

    @Override
    public void toFile(String filename) throws ITException {
        try {
            this.toFile(new FileWriter(filename, false));
        }
        catch (IOException e) {
            Logger.loggit(e);
        }
    }

    @Override
    public void toFile(Writer writer) {
        this.document.normalizeDocument();
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(writer);
        try {
            this.xformer.transform(source, result);
        }
        catch (TransformerException e) {
            Logger.loggit(e);
        }
    }

    @Override
    public void fromString(String xmlsource) throws ITException {
        StringReader xmlin = new StringReader(xmlsource);
        InputSource input = new InputSource(xmlin);
        this.buildXML(input, "String");
    }

    protected void buildXML(InputSource input, String source) throws ITException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(input);
        }
        catch (SAXParseException spe) {
            Logger.loggit(String.valueOf(Messages.getString("XMLRequest.parsingerror")) + spe.getLineNumber() + ", source:" + source);
            Logger.loggit(" " + spe.getMessage());
            if (spe.getException() != null) {
                Logger.loggit(spe.getException());
            }
            throw new ITException(spe);
        }
        catch (SAXException sxe) {
            if (sxe.getException() != null) {
                Logger.loggit(sxe.getException());
            }
            throw new ITException(sxe);
        }
        catch (ParserConfigurationException pce) {
            Logger.loggit(pce);
            throw new ITException(pce);
        }
        catch (IOException ioe) {
            Logger.loggit(ioe);
            throw new ITException(ioe);
        }
        if (this.document == null) {
            throw new ITException("Missing document");
        }
        this.setRoot();
    }

    private void newDocument(String service) {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
            this.document = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            Logger.loggit(e);
        }
        ProcessingInstruction inst = this.document.createProcessingInstruction("InterTest", "Version=" + version);
        this.document.appendChild(inst);
        this.setRoot();
        if (service != null) {
            this.setService(service);
        }
        this.setStatus(0, "");
        this.document.getDocumentElement().normalize();
        if (this.xformer == null) {
            try {
                this.xformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException e) {
                Logger.loggit(String.valueOf(Messages.getString("XMLRequest.tranformationconfigurationerror")) + e);
            }
        }
    }

    @Override
    public void setStatus(int errorlevel, String msg) {
        this.root.setAttribute("errorlevel", Integer.toString(errorlevel));
        this.root.setAttribute("msg", msg);
        Calendar ts = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        ts.getTime();
        this.root.setAttribute("time", this.time2String(ts));
    }

    @Override
    public int getErrorLevel() {
        return Integer.parseInt(this.root.getAttribute("errorlevel"));
    }

    @Override
    public String getErrorMessage() {
        return this.root.getAttribute("msg");
    }

    @Override
    public Calendar getTimeStamp() {
        return HexUtil.TimeStamp(this.root.getAttribute("time"));
    }

    @Override
    public String getSession() {
        return this.root.getAttribute("session");
    }

    @Override
    public void SetSession(String session) {
        this.root.setAttribute("session", session);
    }

    protected Document getDocument() {
        return this.document;
    }

    @Override
    public Element createElement(String name) {
        try {
            return this.document.createElement(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CDATASection createCDATASection(String text) {
        try {
            return this.document.createCDATASection(text);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Node getTag(Node node, String tag) {
        Node worknode = node.getFirstChild();
        while (worknode != null) {
            if (worknode.getNodeName().equalsIgnoreCase(tag)) {
                return worknode;
            }
            worknode = node.getNextSibling();
        }
        return null;
    }

    @Override
    public String getCommandName() {
        Element command = this.getCommand();
        if (command == null) {
            return null;
        }
        return command.getNodeName();
    }

    @Override
    public Element getCommand() {
        Element service = this.getService();
        if (service != null) {
            return (Element)service.getFirstChild();
        }
        return null;
    }

    @Override
    public String toString() {
        StringWriter xmlout = new StringWriter();
        this.toFile(xmlout);
        return xmlout.toString();
    }

    protected Element setService(String service) {
        Element servicenode = (Element)this.root.getFirstChild();
        if (servicenode == null) {
            servicenode = (Element)this.root.appendChild(this.document.createElement(service));
        } else {
            String oldservice = servicenode.getNodeName();
            if (!oldservice.equals(service)) {
                return null;
            }
        }
        return servicenode;
    }

    @Override
    public String getServiceName() {
        Element service = this.getService();
        if (service == null) {
            return null;
        }
        return service.getNodeName();
    }

    @Override
    public Element getService() {
        return (Element)this.root.getFirstChild();
    }

    @Override
    public Element getRoot() {
        if (this.document == null) {
            this.newDocument("unknown");
        }
        if (this.root == null) {
            this.setRoot();
        }
        return this.root;
    }

    private void setRoot() {
        NodeList list = this.document.getElementsByTagName("request");
        this.root = list.getLength() < 1 ? (Element)this.document.appendChild(this.document.createElement("request")) : (Element)list.item(0);
    }

    @Override
    public Element setCommand(String cmd) {
        Element service = this.getService();
        Element command = this.getCommand();
        if (command != null) {
            service.removeChild(this.getCommand());
        }
        service.setAttribute("cmd", cmd);
        command = this.document.createElement(cmd);
        return (Element)service.appendChild(command);
    }

    public String time2String(Calendar time) {
        String timestr = null;
        if (time != null) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                Date dte = time.getTime();
                timestr = df.format(dte);
            }
            catch (Exception exception) {}
        }
        return timestr;
    }

    public Calendar strings2TimeStamp(String date, String tod) {
        Calendar time = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        try {
            int year = Integer.parseInt(date.substring(0, 2));
            int year1 = time.get(1) - 2000;
            year += year > year1 ? 1900 : 2000;
            int day = Integer.parseInt(date.substring(2, 5));
            int hour = Integer.parseInt(tod.substring(0, 2));
            int minute = Integer.parseInt(tod.substring(2, 4));
            int sec = Integer.parseInt(tod.substring(4, 6));
            time.clear();
            time.set(1, year);
            time.set(6, day);
            time.set(11, hour);
            time.set(12, minute);
            time.set(13, sec);
            time.set(14, 0);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return time;
    }

    public static Integer getInt(String name, Element element) {
        return XMLRequest.getInt(name, element, 0);
    }

    public static Integer getInt(String name, Element element, Integer value) {
        String result = element.getAttribute(name);
        if (result == null) {
            return value;
        }
        try {
            return Integer.decode(result);
        }
        catch (NumberFormatException numberFormatException) {
            return value;
        }
    }
}

