/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.XMLRequest;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLFile
extends XMLRequest {
    private static final long serialVersionUID = -4150893290700971194L;
    static String cacopyright = "Copyright (c) 2016 CA";

    public XMLFile() {
        super("File");
    }

    public XMLFile(InputStream reader) throws ITException {
        super("File");
        InputSource input = new InputSource(reader);
        this.buildXML(input, "Input Stream");
    }

    public Element newMember(String name) {
        Element member = this.createElement("member");
        this.setName(member, name);
        return (Element)this.getCommand().appendChild(member);
    }

    public Element getMember(String name) {
        NodeList members = this.getMembers();
        int i = 0;
        while (i < members.getLength()) {
            Element member = (Element)members.item(i);
            String membername = this.getName(member);
            if (membername != null && membername.equalsIgnoreCase(name)) {
                return member;
            }
            ++i;
        }
        return null;
    }

    public Element getFirstMember() {
        NodeList members = this.getMembers();
        if (members != null && members.getLength() > 0) {
            return (Element)members.item(0);
        }
        return null;
    }

    public NodeList getMembers() {
        return this.getCommand().getElementsByTagName("member");
    }

    public int getRecordCount(Element element) {
        String count = element.getAttribute("records");
        int icount = 0;
        try {
            icount = Integer.parseInt(count);
        }
        catch (Exception exception) {}
        return icount;
    }

    public String getDsn(Element element) {
        return element.getAttribute("dsn");
    }

    public String getName(Element element) {
        return element.getAttribute("name");
    }

    public String getSourceFileName(Element element) {
        return element.getAttribute("listing_file_name");
    }

    public String getVarialbeFileName(Element element) {
        return element.getAttribute("variable_file_name");
    }

    public String getLabelFileName(Element element) {
        return element.getAttribute("label_file_name");
    }

    public Calendar getTimeStamp(Element element) {
        return HexUtil.TimeStamp(element.getAttribute("time"));
    }

    public String getTimeString(Element element) {
        return element.getAttribute("time");
    }

    public int getTime(Element element) {
        String tod = element.getAttribute("gt_m_tim");
        int itod = 0;
        if (tod != null && tod.length() > 0) {
            try {
                itod = Integer.parseInt(tod);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return itod;
    }

    public int getDay(Element element) {
        String day = element.getAttribute("gt_m_jul");
        int iday = 0;
        if (day != null && day.length() > 0) {
            try {
                iday = Integer.parseInt(day);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return iday;
    }

    public void setRecordCount(Element element, int count) {
        element.setAttribute("records", Integer.toString(count));
    }

    public void setDsn(Element element, String dsn) {
        element.setAttribute("dsn", dsn.trim());
    }

    public void setSourceFileName(Element element, String name) {
        if (name == null || name.length() < 1) {
            element.removeAttribute("listing_file_name");
        } else {
            element.setAttribute("listing_file_name", name);
        }
    }

    public void setVariableFileName(Element element, String name) {
        if (name == null || name.length() < 1) {
            element.removeAttribute("variable_file_name");
        } else {
            element.setAttribute("variable_file_name", name);
        }
    }

    public void setLabelFileName(Element element, String name) {
        if (name == null || name.length() < 1) {
            element.removeAttribute("label_file_name");
        } else {
            element.setAttribute("label_file_name", name);
        }
    }

    public void setName(Element element, String name) {
        element.setAttribute("name", name);
    }

    public void setTimeStamp(Element element, Calendar time) {
        if (time != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date tme = time.getTime();
            String date = df.format(tme);
            element.setAttribute("time", date);
        }
    }

    public void setDay(Element element, int day) {
        element.setAttribute("gt_m_jul", Integer.toString(day));
    }

    public void settime(Element element, int time) {
        element.setAttribute("gt_m_tim", Integer.toString(time));
    }
}

