/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IStatusMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Numbers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class StatusMessage
extends DebugMessage
implements IStatusMessage {
    static String cacopyright = "Copyright (c) 2016 CA";
    public static final int CVMO_STA_OK = 0;
    public static final int CVMO_STA_WARN = 4;
    public static final int CVMO_STA_ERROR = 8;
    public static final int CVMO_STA_DEAD = 16;
    public static final int CVMO_STA_MAYBE = 4;
    public static final int CVMO_STA_NEVER = 12;
    public static final int CVMO_STA_NO = 8;
    public static final int CVMO_STA_YES = 0;
    public static final String DELIMIT_STACK_TRACE = "<<-- STACK_TRACE -->>";
    protected static String linefeed = System.getProperty("line.separator");
    private static final String STATUS_FORMAT = "RequestorID:%1$d %2$s";
    private static final String STATUS_FORMAT_NOREQESTOR = "%2$s";
    public static final short BASE_REASON_CODE = 1000;
    public static final short SECURITY_FAIL = 1000;
    private static final String[] reasons = new String[]{"SECURITY_FAIL"};
    static final String format1 = "Message #:%d %s";
    static final String format2 = "Message #:%d(%d) %s";
    static java.util.logging.Logger staticLog = java.util.logging.Logger.getLogger(StatusMessage.class.getName());
    protected String extraText = "";
    protected ArrayList<String> messages = new ArrayList();
    protected int requestseqno = 0;
    private short reasonCode = 0;

    public StatusMessage() {
    }

    public StatusMessage(ByteBuffer buffer) throws Exception {
        this();
        this.extractMessage(buffer);
    }

    public StatusMessage(short status, String message) {
        this();
        this.setStatus(status);
        this.setMessage(message);
    }

    public StatusMessage(Throwable e) {
        this();
        this.setStatus((short)32);
        this.setMessages(e);
    }

    @Override
    public void addMessage(String message) {
        this.addMessages(new String[]{message});
    }

    @Override
    public void addMessages(String[] messages) {
        if (messages != null) {
            String[] stringArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item != null) {
                    String[] lines;
                    item = item.replace('\u0000', ' ');
                    String[] stringArray2 = lines = item.split(linefeed);
                    int n3 = lines.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String line = stringArray2[n4];
                        this.messages.add(HexUtil.rightTrim(line));
                        ++n4;
                    }
                }
                ++n2;
            }
            boolean found = false;
            int i = this.messages.size() - 1;
            while (i > 0) {
                String item = this.messages.get(i);
                if (item != null && item.length() != 0) break;
                this.messages.set(1, null);
                found = true;
                --i;
            }
            if (found) {
                Iterator<String> it = this.messages.iterator();
                while (it.hasNext()) {
                    if (it.next() != null) continue;
                    it.remove();
                }
            }
        }
    }

    public String getExtraText() {
        return this.extraText;
    }

    @Override
    public String getMessage() {
        return this.getMessage(true);
    }

    @Override
    public String getMessage(boolean trim) {
        StringBuilder text = new StringBuilder("");
        int deleteix = 0;
        for (String line : this.messages) {
            if (trim && line.length() == 0) continue;
            text.append(line);
            deleteix = text.length();
            text.append(linefeed);
        }
        text.setLength(deleteix);
        return text.toString();
    }

    @Override
    public String getMessage(int messagenumber) {
        try {
            return this.messages.get(messagenumber);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    @Override
    public String[] getMessages() {
        return this.messages.toArray(new String[this.messages.size()]);
    }

    public short getReasonCode() {
        return this.reasonCode;
    }

    @Override
    public int getRequestseqno() {
        return this.requestseqno;
    }

    @Override
    public short getStatus() {
        return this.getSubmessageID();
    }

    @Override
    public void logStatus() {
        this.logStatus(null, null);
    }

    @Override
    public void logStatus(Exception e) {
        this.logStatus(null, e);
    }

    @Override
    public void logStatus(String string, Exception exception) {
        Formatter fmt = new Formatter();
        if (string != null) {
            fmt.format("%s%s", string, Logger.LINEFEED);
        }
        fmt.format("Status:%d", this.getStatus());
        fmt.format(" Message #:%d %s", this.sequencenumber, this.getMessage());
        if (exception == null || this.getStatus() < 9) {
            Logger.loggit((int)this.getStatus(), fmt.toString());
        } else {
            Logger.loggit(this.getStatus(), fmt.toString(), exception);
        }
    }

    public void setExtraText(String extraText) {
        this.extraText = extraText;
    }

    @Override
    public void setMessage(String message) {
        this.setMessages(new String[]{message});
    }

    @Override
    public void setMessages(String[] messages) {
        this.messages.clear();
        this.addMessages(messages);
    }

    @Override
    public void setMessages(Throwable e) {
        this.setMessages(new String[]{HexUtil.getErrorText(e), DELIMIT_STACK_TRACE});
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String stack = writer.toString();
        ArrayList<String> messages = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(stack));
        try {
            String line = reader.readLine();
            while (line != null) {
                messages.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {}
        this.addMessages(messages.toArray(new String[messages.size()]));
    }

    public void setReasonCode(short reasonCode) {
        this.reasonCode = reasonCode < 1000 ? (short)0 : reasonCode;
    }

    @Override
    public void setRequestseqno(int requestseqno) {
        this.requestseqno = requestseqno;
    }

    @Override
    public void setStatus(short status) {
        try {
            this.setSubmessageID(status);
        }
        catch (ITException iTException) {}
    }

    @Override
    protected short _defaultID() {
        return 18;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.requestseqno = Numbers.getUShort(this.buffer.getShort());
        this.setReasonCode(this.buffer.getShort());
        int textlen = this.buffer.getInt();
        if (textlen > this.buffer.remaining()) {
            textlen = this.buffer.remaining();
        }
        byte[] text = new byte[textlen];
        this.buffer.get(text);
        try {
            String msgtext = new String(text, "IBM1047");
            this.setMessages(msgtext.split("\u0000"));
            textlen = this.buffer.remaining();
            if (textlen > 0) {
                text = new byte[textlen];
                this.buffer.get(text);
                this.extraText = new String(text, "IBM1047").replace('\u0000', ' ');
                this.extraText = HexUtil.rightTrim(this.extraText);
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
        }
    }

    @Override
    protected int _getMessageSize() {
        int length = 8 + this.extraText.length();
        if (this.messages != null) {
            for (String string : this.messages) {
                length += string.length() + 1;
            }
        }
        return length;
    }

    @Override
    protected String _toString() {
        return String.format(this.requestseqno == 0 ? STATUS_FORMAT_NOREQESTOR : STATUS_FORMAT, this.requestseqno, this.messages.size() > 0 ? this.messages.get(0) : "No message");
    }

    @Override
    protected void buildMessage() throws Exception {
        int length = 0;
        for (String string : this.messages) {
            length += string.length() + 1;
        }
        this.buffer.putShort(Numbers.putUShort(this.requestseqno));
        this.buffer.putShort(this.reasonCode);
        this.buffer.putInt(length);
        for (String string : this.messages) {
            this.buffer.put(string.getBytes("IBM1047"));
            this.buffer.put((byte)0);
        }
        if (this.extraText.length() != 0) {
            this.buffer.put(this.extraText.getBytes("IBM1047"));
        }
    }

    public String getReasonText() {
        int index = this.reasonCode - 1000;
        return index < reasons.length ? reasons[index] : "";
    }

    public static void logStatus(IStatusMessage message, String string, Exception exception) {
        int requestno = message.getRequestseqno();
        String[] stringArray = message.getMessages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            if ((text = text.trim()).length() > 0) {
                if (text.equals(DELIMIT_STACK_TRACE)) {
                    return;
                }
                Formatter fmt = new Formatter();
                if (string != null) {
                    fmt.format("%s%s", string, HexUtil.LF);
                }
                fmt.format("Status:%d ", message.getStatus());
                if (requestno == 0) {
                    fmt.format(format1, message.getSequencenumber(), text);
                } else {
                    fmt.format(format2, message.getSequencenumber(), requestno, text);
                }
                if (exception == null || message.getStatus() < 9) {
                    staticLog.log(Level.INFO, "{0} {1}", new Object[]{message.getStatus(), fmt.toString()});
                } else {
                    LogRecord logrecord = new LogRecord(Level.WARNING, "Exception {0} {1} detected");
                    logrecord.setParameters(new Object[]{message.getStatus(), fmt.toString()});
                    logrecord.setThrown(exception);
                    staticLog.log(logrecord);
                }
            }
            ++n2;
        }
    }
}

