/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.MemberInfo;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ProtsymMessage
extends DebugMessage {
    static String cacopyright = "Copyright (c) 2016 CA";
    private String DSName = null;
    private ArrayList<MemberInfo> members = new ArrayList();

    @Override
    protected void buildMessage() throws Exception {
        if (this.DSName != null && this.DSName.length() > 0) {
            this.buffer.put(HexUtil.spaceFill(this.DSName, 44).getBytes("IBM1047"));
            this.buffer.putShort((short)this.members.size());
            for (MemberInfo info : this.members) {
                this.buffer.put(info.getBuffer().array());
            }
        }
    }

    public void addMember(ByteBuffer buffer) {
        MemberInfo info = new MemberInfo(buffer);
        this.members.add(info);
    }

    public String getDSName() {
        return HexUtil.rightTrim(this.DSName);
    }

    public void setDSName(String name) {
        this.DSName = HexUtil.spaceFill(name, 44);
    }

    public ArrayList<MemberInfo> getMembers() {
        return this.members;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        if (this.vardata < this.buffer.limit()) {
            byte[] dsn = new byte[44];
            this.buffer.get(dsn);
            this.DSName = HexUtil.rightTrim(new String(dsn, "IBM1047"));
            int count = Numbers.getUShort(this.buffer.getShort());
            this.members = new ArrayList(count);
            int i = 0;
            while (i < count) {
                this.addMember(this.buffer);
                ++i;
            }
        }
    }

    public void resetMessages() {
        if (this.members != null) {
            this.members.clear();
        } else {
            this.members = new ArrayList();
        }
    }

    @Override
    protected short _defaultID() {
        return 28;
    }

    @Override
    protected int _getMessageSize() {
        int size = 50;
        for (MemberInfo member : this.members) {
            size += member.getSize();
        }
        return size;
    }

    @Override
    protected String _toString() {
        return null;
    }
}

