/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.MemberInfo;
import com.ca.intertest.tools.Numbers;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class MemberInfoExtended
extends MemberInfo {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private HashMap<String, String> attributes = new HashMap();

    public MemberInfoExtended() {
    }

    public MemberInfoExtended(MemberInfo newmember) {
        this.setDate(newmember.getDate());
        this.setLangFlag(newmember.getLangFlag());
        this.setMember(newmember.getMember());
        this.setTime(newmember.getTime());
        this.setVersion(newmember.getVersion());
    }

    public MemberInfoExtended(ByteBuffer buffer) {
        super(buffer);
        if (buffer.remaining() == 0) {
            return;
        }
        int attrsize = Numbers.getUShort(buffer.getShort());
        byte[] buff = new byte[attrsize];
        buffer.get(buff);
        try {
            String[] attrlist;
            String attrstring = new String(buff, "IBM1047");
            String[] stringArray = attrlist = attrstring.split("[;]+");
            int n = attrlist.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                String[] attr = item.split("=");
                if (attr.length == 2) {
                    this.setAttribute(attr[0], attr[1]);
                }
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e) {
            Logger.loggit(e);
        }
    }

    public MemberInfoExtended(HashMap<String, String> attributes) {
        super(attributes);
        this.setAttributes(attributes);
    }

    public HashMap<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key.trim(), value.trim());
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttributes(HashMap<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (Map.Entry<String, String> item : this.attributes.entrySet()) {
            size += item.getKey().length() + 1;
            size += item.getValue().length() + 1;
        }
        if (size > 0) {
            --size;
        }
        return size += super.getSize() + 2;
    }

    @Override
    public ByteBuffer getBuffer() {
        ByteBuffer buffer = super.getBuffer();
        StringBuilder str = new StringBuilder(this.attributes.size() * 15);
        if (this.attributes.size() > 0) {
            for (Map.Entry<String, String> item : this.attributes.entrySet()) {
                str.append(item.getKey());
                str.append('=');
                str.append(item.getValue());
                str.append(';');
            }
            str.setLength(str.length() - 1);
        }
        ByteBuffer newbuffer = ByteBuffer.allocate(buffer.capacity() + 2 + str.length());
        newbuffer.put(buffer);
        newbuffer.putShort((short)str.length());
        if (this.attributes.size() > 0) {
            try {
                newbuffer.put(str.toString().getBytes("IBM1047"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.loggit(e);
            }
        }
        return (ByteBuffer)newbuffer.position(0);
    }

    @Override
    public String toString() {
        if (this.member == null) {
            return super.toString();
        }
        if (this.attributes.size() > 0) {
            return String.format("%s:%s", this.member, this.attributes.toString());
        }
        return this.member;
    }
}

