/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileName;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IDebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;

public class InitMessage
extends DebugMessage
implements IDebugMessage {
    static String cacopyright = "Copyright (c) 2016 CA";
    public static final short INIT_CICS = 1;
    public static final short INIT_BATCH = 2;
    protected int sessionID;
    protected int port;
    protected byte[] IPAddress = new byte[16];
    protected byte iptype = (byte)2;
    protected String userid;
    protected String termid;
    protected boolean pli = false;
    protected FileName JCLFile = null;
    protected boolean forceASM = false;
    protected String EndevorFile = null;

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.setProjecttype(this.submessageID);
        this.iptype = this.buffer.get();
        this.buffer.get(this.IPAddress);
        this.port = Numbers.getUShort(this.buffer.getShort());
        this.sessionID = this.buffer.getInt();
        byte[] buf = new byte[8];
        this.buffer.get(buf);
        this.buffer.get(buf);
        if (this.submessageID == 1) {
            this.buffer.get(buf);
            this.userid = HexUtil.rightTrim(new String(buf, "IBM1047"));
            buf = new byte[4];
            this.buffer.get(buf);
            this.termid = HexUtil.rightTrim(new String(buf, "IBM1047"));
        } else {
            this.JCLFile = new FileName(this.buffer);
            if (this.buffer.remaining() > 0) {
                boolean bl = this.pli = this.buffer.get() != 0;
                if (this.buffer.remaining() > 0) {
                    this.forceASM = this.buffer.get() != 0;
                    int size = Numbers.getUShort(this.buffer.getShort());
                    buf = new byte[size];
                    this.buffer.get(buf);
                    this.EndevorFile = HexUtil.rightTrim(new String(buf, "IBM1047"));
                }
            }
        }
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized short getProjecttype() {
        return this.submessageID;
    }

    public synchronized Integer getSessionID() {
        return this.sessionID;
    }

    public synchronized String getUserid() {
        return this.userid;
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(this.iptype);
        int i = 0;
        while (i < this.IPAddress.length) {
            this.IPAddress[i] = 0;
            ++i;
        }
        this.buffer.put(this.IPAddress);
        this.buffer.putShort((short)this.port);
        this.buffer.putInt(this.sessionID);
        this.buffer.put(HexUtil.spaceFill("", 8).getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill("", 8).getBytes("IBM1047"));
        if (this.submessageID == 1) {
            this.buffer.put(HexUtil.spaceFill(this.userid, 8).getBytes("IBM1047"));
            this.buffer.put(HexUtil.spaceFill(this.termid, 4).getBytes("IBM1047"));
            this.buffer.put(HexUtil.spaceFill("", 4).getBytes("IBM1047"));
        } else {
            if (this.JCLFile == null) {
                this.buffer.put((byte)0);
                this.buffer.putShort((short)0);
            } else {
                this.buffer.put(this.JCLFile.getBuffer());
            }
            this.buffer.put((byte)(this.pli ? 1 : 0));
            if (this.EndevorFile != null && this.EndevorFile.length() > 0) {
                this.buffer.put((byte)(this.forceASM ? 1 : 0));
                this.buffer.putShort((short)this.EndevorFile.length());
                this.buffer.put(this.EndevorFile.getBytes("IBM1047"));
            }
        }
    }

    @Override
    protected short _defaultID() {
        return 26;
    }

    public synchronized void setProjecttype(short projecttype) throws ITException {
        this.setSubmessageID(projecttype);
        if (this.submessageID == 1) {
            this.JCLFile = null;
        } else {
            this.userid = "";
        }
    }

    public byte[] getIPAddress() {
        if (this.iptype == 19) {
            return this.IPAddress;
        }
        byte[] addr = new byte[4];
        System.arraycopy(this.IPAddress, 0, addr, 0, 4);
        return addr;
    }

    public void setIPAddress(byte[] address) {
        if (address.length == this.IPAddress.length) {
            this.iptype = (byte)19;
        } else if (address.length == 4) {
            int i = address.length;
            while (i < this.IPAddress.length) {
                this.IPAddress[i] = 0;
                ++i;
            }
            this.iptype = (byte)2;
        } else {
            return;
        }
        System.arraycopy(address, 0, this.IPAddress, 0, address.length);
    }

    public byte getIptype() {
        return this.iptype;
    }

    public FileName getJCLFile() {
        return this.JCLFile;
    }

    public void setJCLFile(FileName file) {
        this.JCLFile = file;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    public void setUserid(String userid) {
        this.userid = userid == null || userid.trim().length() == 0 ? ".ANY" : userid;
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        if (submessageID != 1 && submessageID != 2) {
            throw new ITException("Invalid session type");
        }
        super.setSubmessageID(submessageID);
    }

    @Override
    protected int _getMessageSize() {
        return 500;
    }

    @Override
    protected String _toString() {
        return null;
    }

    public String getEndevorFile() {
        return this.EndevorFile;
    }

    public void setEndevorFile(String endevorFile) {
        this.EndevorFile = endevorFile.trim();
    }

    public boolean isPLI() {
        return this.pli;
    }

    public void setPLI(boolean pli) {
        this.pli = pli;
    }

    public boolean isForceASM() {
        return this.forceASM;
    }

    public void setForceASM(boolean forceASM) {
        this.forceASM = forceASM;
    }

    public String getTermid() {
        return this.termid;
    }

    public void setTermid(String termid) {
        this.termid = termid == null || termid.trim().length() == 0 ? ".ANY" : termid;
    }
}

