/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.dialogs;

import com.ca.testingtools.common.HexUtil;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

public class TT_ErrorDialog {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected static final String baseclass = TT_ErrorDialog.class.getName();
    protected static TT_ErrorDialog instance = new TT_ErrorDialog("com.ca.testingtools");
    protected final ArrayList<Status> standardStatus = new ArrayList(4);
    protected final String provider;
    protected final String name;
    protected final String version;
    protected final String plugin;

    protected TT_ErrorDialog(String plugin) {
        this.plugin = plugin;
        Bundle bundle = Platform.getBundle((String)plugin);
        if (bundle != null) {
            Dictionary headers = bundle.getHeaders();
            this.provider = (String)headers.get("Bundle-Vendor");
            this.name = (String)headers.get("Bundle-Name");
            this.version = (String)headers.get("Bundle-Version");
        } else {
            this.provider = "Unknown vendor";
            this.name = plugin;
            this.version = "Unknown version";
        }
        String[] stringArray = new String[]{"Plugin Vendor: %1$s", "Plugin Name: %2$s", "Plug-in ID: %3$s", "Version: %4$s"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.standardStatus.add(new Status(4, plugin, String.format(item, this.provider, this.name, plugin, this.version), null));
            ++n2;
        }
    }

    protected void doError(final Shell parent, int statuscode, final String dialogTitle, final String message, Throwable e, List<String> extraText) {
        Logger log;
        StackTraceElement[] stack = e == null ? new Throwable().getStackTrace() : e.getStackTrace();
        int stackIx = 0;
        String classname = this.getClass().getName();
        String eventclass = null;
        String method = null;
        int lineno = 0;
        while (stackIx < stack.length) {
            StackTraceElement stackItem = stack[stackIx];
            if (!classname.equals(stackItem.getClassName()) && !baseclass.equals(stackItem.getClassName())) {
                eventclass = stackItem.getClassName();
                method = stackItem.getMethodName();
                lineno = stackItem.getLineNumber();
                break;
            }
            ++stackIx;
        }
        if (eventclass == null) {
            eventclass = "Unknown Class";
            log = Logger.getLogger(this.getClass().getName());
        } else {
            log = Logger.getLogger(eventclass);
        }
        LogRecord record = new LogRecord(Level.SEVERE, message);
        record.setLoggerName(eventclass);
        record.setSourceClassName(eventclass);
        record.setSourceMethodName(method);
        record.setThrown(e);
        log.log(record);
        String statusText = String.format("The error was detected in %5$s (%6$d)", this.provider, this.name, this.plugin, this.version, eventclass, lineno);
        ArrayList<Status> statusList = new ArrayList<Status>(10);
        statusList.addAll(this.standardStatus);
        statusList.add(new Status(4, "com.ca.testingtools", statusText, null));
        if (extraText != null) {
            for (String item : extraText) {
                statusList.add(new Status(4, "com.ca.testingtools", item, null));
            }
        }
        IStatus[] statusItem = statusList.toArray(new IStatus[statusList.size()]);
        final MultiStatus status = new MultiStatus("com.ca.testingtools", statuscode, statusItem, e == null ? null : HexUtil.getErrorText((Throwable)e), e);
        UIJob job = new UIJob(classname){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                ErrorDialog.openError((Shell)parent, (String)dialogTitle, (String)message.replace("&", "&&"), (IStatus)status);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static void openError(Shell parent, String title, String message, List<String> extraText) {
        TT_ErrorDialog.openError(parent, 4, title, message, null, extraText);
    }

    public static void openError(Shell parent, String title, String message) {
        TT_ErrorDialog.openError(parent, 4, title, message, null, null);
    }

    public static void openError(Shell parent, String title, String message, Throwable e) {
        TT_ErrorDialog.openError(parent, 4, title, message, e, null);
    }

    public static void openError(Shell parent, String title, String message, Throwable e, List<String> extraText) {
        TT_ErrorDialog.openError(parent, 4, title, message, e, extraText);
    }

    public static void openError(Shell parent, int statuscode, String title, String message, Throwable e) {
        TT_ErrorDialog.openError(parent, statuscode, title, message, null, null);
    }

    public static void openError(Shell parent, int statuscode, String dialogTitle, String message, Throwable e, List<String> extraText) {
        instance.doError(parent, statuscode, dialogTitle, message, e, extraText);
    }
}

