/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.views.list;

import com.ca.testingtools.core.IProfileSetContent;
import com.ca.testingtools.core.NodeChild;
import com.ca.testingtools.protsym.Member;
import com.ca.testingtools.protsym.ProtsymDataset;
import com.ca.testingtools.protsym.views.list.ProtsymNameSorter;
import com.ca.testingtools.protsym.views.list.ProtsymViewContentProvider;
import com.ca.testingtools.protsym.views.list.ProtsymViewDoubleClick;
import com.ca.testingtools.protsym.views.list.ProtsymViewLabelProvider;
import java.util.ArrayList;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProtsymView
extends ViewPart
implements IProfileSetContent {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    public static final String ID = "com.ca.testingtools.protsym.views.protsymview";
    public static final String CONTEXT_HELP_ID = "com.ca.testingtools.help.protsymview";
    private TableViewer viewer;
    public static final String Member_Column = "Member";
    public static final String Language_Column = "Language";
    public static final String Date_Column = "Date";
    public static final String Time_Column = "Time";
    public static final String DSN_Column = "PROTSYM";
    public static final int Member_NAME = 0;
    public static final int Language = 1;
    public static final int Date = 2;
    public static final int Time = 3;
    public static final int DSN = 4;
    private ProtsymViewDoubleClick doubleClick = new ProtsymViewDoubleClick();
    String[] columnNames = new String[]{"Member", "Language", "Date", "Time", "PROTSYM"};
    int[] columnAlignments = new int[]{16384, 16384, 16384, 16384, 16384, 16384, 16384};
    int[] columnWidths = new int[]{100, 100, 100, 100, 500};
    int[] columnOrder;
    private ArrayList<Member> members;
    private ArrayList<ProtsymDataset> datasets;

    public ProtsymView() {
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        this.columnOrder = nArray;
        this.members = new ArrayList();
        this.datasets = new ArrayList();
    }

    public void dispose() {
        super.dispose();
        if (this.viewer != null && this.doubleClick != null) {
            this.viewer.removeDoubleClickListener((IDoubleClickListener)this.doubleClick);
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.viewer.setContentProvider((IContentProvider)new ProtsymViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProtsymViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new ProtsymNameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        Table table = this.viewer.getTable();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.hookContextMenu();
        this.hookDoubleClickAction();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        Listener sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = ProtsymView.this.viewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                ProtsymView.this.viewer.refresh();
            }
        };
        int i = 0;
        while (i < this.columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, this.columnAlignments[i]);
            tableColumn.setText(this.columnNames[i]);
            tableColumn.setWidth(this.columnWidths[i]);
            tableColumn.setData((Object)this.columnOrder[i]);
            tableColumn.setMoveable(true);
            tableColumn.setResizable(true);
            tableColumn.setData((Object)new Integer(i));
            tableColumn.addListener(13, sortListener);
            ++i;
        }
        table.setSortColumn(table.getColumn(0));
        table.setSortDirection(128);
        table.setColumnOrder(this.columnOrder);
        this.viewer.setInput((Object)new Member[0]);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.doubleClick = new ProtsymViewDoubleClick();
        this.viewer.addDoubleClickListener((IDoubleClickListener)this.doubleClick);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setContent(NodeChild[] nodes, boolean clearView) {
        this.members.clear();
        this.datasets.clear();
        this.viewer.setInput((Object)new Member[0]);
        NodeChild[] nodeChildArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeChild dataset = nodeChildArray[n2];
            if (dataset instanceof ProtsymDataset) {
                ((ProtsymDataset)dataset).requestContents(this);
                this.datasets.add((ProtsymDataset)dataset);
            }
            ++n2;
        }
    }

    public void addContent(Object[] elements, boolean clearList) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Member member = (Member)element;
            if (member.getName().contains("%23")) {
                String newName = member.getName().replace("%23", "#");
                member.setAttribute("name", newName);
            }
            this.members.add(member);
            ProtsymDataset dsn = member.getDataset();
            if (!this.datasets.contains((Object)dsn)) {
                this.datasets.add(dsn);
            }
            ++n2;
        }
        this.viewer.setInput((Object)this.members.toArray(new Member[this.members.size()]));
    }

    public void removeContent(NodeChild[] elements) {
        NodeChild[] nodeChildArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            NodeChild item = nodeChildArray[n2];
            if (item instanceof ProtsymDataset) {
                this.datasets.remove(item);
                ArrayList<Member> list = this.getSiblings((ProtsymDataset)item);
                for (Member abend : list) {
                    this.members.remove(abend);
                }
            }
            ++n2;
        }
        this.viewer.setInput((Object)this.members.toArray(new Member[this.members.size()]));
    }

    private ArrayList<Member> getSiblings(ProtsymDataset dataset) {
        ArrayList<Member> list = new ArrayList<Member>(this.members.size());
        for (Member item : this.members) {
            if (item.getDataset() != dataset) continue;
            list.add(item);
        }
        return list;
    }

    public ProtsymDataset[] getDatasets() {
        return this.datasets.toArray(new ProtsymDataset[this.datasets.size()]);
    }
}

