/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.ui.lister.util;

import com.ca.testingtools.common.IScanSource;
import com.ca.testingtools.protsym.ui.lister.util.ColorProvider;
import com.ca.testingtools.protsym.ui.lister.util.IListerTokenScanner;
import com.ca.testingtools.protsym.ui.lister.util.ReservedWordProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public abstract class AbstractScanner
implements IListerTokenScanner {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private Logger log = Logger.getLogger(this.getClass().getName());
    private IDocument doc;
    private int rangeOffset;
    private int rangeLength;
    private String contentType;
    private String buffer;
    private ColorProvider colorProvider = new ColorProvider();
    private int tokenOffset;
    private int tokenLength;
    private IToken keywordToken = new Token((Object)new TextAttribute(this.colorProvider.getColor(ColorProvider.KEYWORD_COLOR)));
    private IToken stringToken;
    private IToken commentsToken = new Token((Object)new TextAttribute(this.colorProvider.getColor(ColorProvider.COMMENT_COLOR)));
    private IToken defaultToken;
    private List<TypedPosition> bufferPositions;
    private int bufferIndex;
    protected IScanSource scanner = null;
    protected String parseRegex = null;
    protected int wordGroup = 0;

    public AbstractScanner() {
        this.stringToken = new Token((Object)new TextAttribute(this.colorProvider.getColor(ColorProvider.STRING_COLOR)));
        this.defaultToken = new Token((Object)new TextAttribute(this.colorProvider.getColor(ColorProvider.DEFAULT_COLOR)));
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.doc = document;
        this.rangeOffset = offset;
        this.rangeLength = length;
        this.contentType = contentType;
        try {
            if (contentType.equals("__source_code_category")) {
                this.doc.getNumberOfLines(offset, length);
                this.doc.getLineOfOffset(offset);
            } else if (contentType.equals("__code") || contentType.equals("__comment")) {
                this.buffer = this.doc.get(this.rangeOffset, this.rangeLength);
                this.tokenOffset = 0;
                this.tokenLength = 0;
                this.parseBuffer();
                this.bufferIndex = 0;
            } else {
                this.buffer = this.doc.get(this.rangeOffset, this.rangeLength);
                this.tokenOffset = this.rangeOffset;
                this.tokenLength = 0;
            }
        }
        catch (BadLocationException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public int getTokenOffset() {
        return this.tokenOffset;
    }

    public IToken nextToken() {
        TypedPosition tp = null;
        if (this.bufferIndex >= this.bufferPositions.size()) {
            return Token.EOF;
        }
        tp = this.getBufferWord(this.bufferIndex);
        if (tp != null) {
            this.tokenOffset = tp.getOffset() + this.rangeOffset;
            this.tokenLength = tp.getLength();
            ++this.bufferIndex;
            return this.getBufferToken(tp);
        }
        return Token.EOF;
    }

    @Override
    public IToken nextStatement() {
        return null;
    }

    public void setRange(IDocument document, int offset, int length) {
        try {
            this.setPartialRange(document, offset, length, document.getContentType(offset), -1);
        }
        catch (BadLocationException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
    }

    public void parseBuffer() {
        if (this.scanner.isCommentLine(this.buffer)) {
            this.contentType = "__comment";
        } else if (!this.scanner.isExecuteCode(this.buffer)) {
            this.contentType = "__other";
        }
        this.bufferPositions = this.getTypedTokens(this.buffer);
        if (this.bufferPositions == null) {
            this.bufferPositions = new ArrayList<TypedPosition>();
            this.bufferIndex = this.bufferPositions.size() + 1;
        }
    }

    public TypedPosition getBufferWord(int index) {
        return this.bufferPositions.get(index);
    }

    public IToken getBufferToken(TypedPosition position) {
        String word = position.getType().toUpperCase();
        if (this.contentType.equals("__comment")) {
            this.bufferIndex = this.bufferPositions.size() + 1;
            this.tokenOffset = this.rangeOffset;
            this.tokenLength = this.rangeLength;
            return this.commentsToken;
        }
        if (this.contentType.equals("__other")) {
            this.bufferIndex = this.bufferPositions.size() + 1;
            this.tokenOffset = this.rangeOffset;
            this.tokenLength = this.rangeLength;
            return this.defaultToken;
        }
        if (ReservedWordProvider.containsWord(word, this.wordGroup)) {
            return this.keywordToken;
        }
        if (this.isLiteral(position)) {
            return this.stringToken;
        }
        return this.defaultToken;
    }

    public boolean isLiteral(TypedPosition typedPosition) {
        return typedPosition.getType().charAt(0) == '\'';
    }

    private List<TypedPosition> getTypedTokens(String input) {
        return this.getTypedTokens(input, this.scanner.getLineRegex());
    }

    private List<TypedPosition> getTypedTokens(String input, String regex) {
        if (input.length() <= 0 || regex.length() <= 0) {
            return null;
        }
        ArrayList<TypedPosition> tokens = new ArrayList<TypedPosition>();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            if (matcher.group().length() <= 0) continue;
            tokens.add(new TypedPosition(matcher.start(), matcher.end() - matcher.start(), matcher.group()));
        }
        if (tokens.isEmpty()) {
            return null;
        }
        return tokens;
    }

    protected abstract void setScanSource(IScanSource var1);

    protected abstract void setParseRegex(String var1);

    protected abstract void setWordGroup(int var1);
}

