/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym.handlers;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.LogConsole;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.protsym.Activator;
import com.ca.testingtools.protsym.ProtsymDataset;
import com.ca.testingtools.protsym.wizards.LoadProtsymWizard;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.handlers.HandlerUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LoadListingIntoProtsymHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(selection instanceof TreeSelection)) {
            return null;
        }
        TreeSelection sel = (TreeSelection)selection;
        Object object = sel.getFirstElement();
        if (object instanceof TT_TreeItem && (object = ((TT_TreeItem)object).getValue()) instanceof ProtsymDataset) {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
            LoadProtsymWizard wizard = new LoadProtsymWizard();
            wizard.init((ProtsymDataset)((Object)object));
            wizard.setNewItem(true);
            Shell shell = window.getShell();
            TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, (IWizard)wizard);
            dialog.create();
            int result = dialog.open();
            if (result == 0) {
                String errorMessage;
                int errorLevel;
                block23: {
                    XMLRequest xml = wizard.getXML();
                    errorLevel = xml.getErrorLevel();
                    errorMessage = xml.getErrorMessage();
                    if (errorLevel != 0 || !wizard.isNoReport()) {
                        IConsoleManager conMan = ConsolePlugin.getDefault().getConsoleManager();
                        ImageDescriptor image = Activator.getDefault().getImageRegistry().getDescriptor("GENERIC_ICON");
                        MessageConsole console = LogConsole.findConsole((String)"Load PROTSYM Results", (ImageDescriptor)image, (boolean)false);
                        conMan.showConsoleView((IConsole)console);
                        IDocument document = console.getDocument();
                        if (document != null) {
                            document.set("");
                        }
                        conMan.warnOfContentChange((IConsole)console);
                        String time = HexUtil.addTime(null);
                        MessageConsoleStream out = null;
                        try {
                            try {
                                out = console.newMessageStream();
                                out.setActivateOnWrite(true);
                                out.println(String.format("%s -> %s", time, "Beginning of Report"));
                                if (errorLevel != 0) {
                                    out.println(String.format("Error Level Returned:%d %s", errorLevel, errorMessage));
                                }
                                NodeList nodes = xml.getCommand().getElementsByTagName("Line");
                                int index = 0;
                                while (index < nodes.getLength()) {
                                    Element item = (Element)nodes.item(index);
                                    String line = XMLFile.getStr((Element)item);
                                    out.println(line);
                                    ++index;
                                }
                                out.println(String.format("%s -> %s", time, "End of Report"));
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, "Error Logging Message in Console", e);
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block23;
                            }
                        }
                        catch (Throwable throwable) {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
                if (errorLevel != 0) {
                    String message = String.format("Request returned RC=%d %s\nThe load may not have completed successfully\nPlease check the output on the console view", errorLevel, errorMessage);
                    MessageDialog.openWarning((Shell)shell, (String)"Add Symbolic (Load PROTSYM)", (String)message);
                } else {
                    MessageDialog.openInformation((Shell)shell, (String)"Add Symbolic (Load PROTSYM)", (String)"Listing(s) Loaded successfully");
                }
            }
        }
        return null;
    }
}

