/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym;

import com.ca.testingtools.common.IScanSource;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.scanASM;
import com.ca.testingtools.common.scanCOBOL;
import com.ca.testingtools.common.scanPLI;
import com.ca.testingtools.core.IConstants;
import com.ca.testingtools.core.ResourceProperty;
import com.ca.testingtools.protsym.Decorator;
import com.ca.testingtools.protsym.Outline;
import com.ca.testingtools.protsym.ProtsymUtil;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.views.properties.IPropertySource;

public class ProtsymFile
implements IAdaptable,
IPropertyChangeListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final Hashtable<IResource, ProtsymFile> protsyms = new Hashtable();
    protected final IFile file;
    protected final ResourceProperty store;
    protected IScanSource scansource;
    protected IResourceChangeListener listener;
    protected Outline outline;
    protected int language;
    protected Decorator decorator;
    protected IPropertyChangeListener propertylistener = null;
    private static final String sourceClass = ProtsymFile.class.getName();
    private Logger log = Logger.getLogger(sourceClass);
    protected ListenerList propertyChangeListeners = new ListenerList();

    public ResourceProperty getStore() {
        return this.store;
    }

    protected ProtsymFile(IFile file) throws TTException {
        if (!file.exists()) {
            throw new TTException(String.format("File %s does not exist", file.getFullPath()));
        }
        if (!file.isAccessible()) {
            throw new TTException(String.format("File %s is not accessible", file.getFullPath()));
        }
        if (!ProtsymUtil.isProtsym((IResource)file)) {
            throw new TTException(String.format("%s is not a PROTSYM File", file.getFullPath()));
        }
        this.file = file;
        this.store = ResourceProperty.getInstance((IResource)file);
        this.listener = new ResourceChangeListener();
        this.decorator = new Decorator();
        this.setScanner();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener, 1);
        this.addPropertyChangeListener(this);
    }

    public synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListeners.add((Object)listener);
    }

    public void dispose() {
        this.store.removePropertyChangeListener(this.propertylistener);
        this.propertyChangeListeners.clear();
        if (this.listener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
            this.listener = null;
        }
        this.store.save();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtsymFile)) {
            return false;
        }
        ProtsymFile proj = (ProtsymFile)obj;
        return proj.getFile().equals((Object)this.file);
    }

    public void firePropertyChangeListeners(PropertyChangeEvent event) {
        Object[] objectArray = this.propertyChangeListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                ((IPropertyChangeListener)listener).propertyChange(event);
            }
            catch (Exception e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
            ++n2;
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter != IPropertySource.class && this.file != null) {
            return this.file.getAdapter(adapter);
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getName() {
        String name = this.file.getName();
        String ext = this.file.getFileExtension();
        int index = name.length() - ext.length() - 1;
        return name.substring(0, index);
    }

    public IFile getFile() {
        return this.file;
    }

    public IScanSource getScansource() {
        return this.scansource;
    }

    private void setScanner() {
        this.language = this.store.getHex("gt_m_lang");
        switch (this.language) {
            case 32: {
                if (this.scansource instanceof scanCOBOL) break;
                this.scansource = new scanCOBOL(this.store.getString("gt_m_cty"));
                break;
            }
            case 16: {
                if (this.scansource instanceof scanASM) break;
                this.scansource = new scanASM(this.store.getString("gt_m_aty"));
                break;
            }
            case 128: {
                if (!(this.scansource instanceof scanPLI)) {
                    this.scansource = new scanPLI(this.store.getString("gt_m_plc"));
                }
                ((scanPLI)this.scansource).setScantype(this.store.getInt("scantype"));
            }
        }
    }

    public void refresh() {
        if (this.outline != null) {
            try {
                this.outline.reLoad();
            }
            catch (TTException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                this.outline = null;
            }
        }
        this.store.reLoad();
        this.setScanner();
    }

    public synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeListeners.remove((Object)listener);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getTitle() {
        return this.decorator.decorateText("", this.file);
    }

    public int getLanguage() {
        return this.language;
    }

    public Outline getOutline() {
        return this.outline;
    }

    public void setOutline(Outline outline) {
        this.outline = outline;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public static synchronized ProtsymFile getInstance(IResource resource) throws TTException {
        ProtsymFile file = protsyms.get(resource);
        if (file == null && (file = new ProtsymFile((IFile)resource)) != null) {
            protsyms.put(resource, file);
        }
        return file;
    }

    public static synchronized ProtsymFile getInstance(String dsn, String member) throws TTException {
        IFolder folder = ProtsymUtil.getFolder(dsn);
        String format = String.valueOf(member) + ".%s";
        if (folder == null || !folder.isAccessible()) {
            return null;
        }
        String[] stringArray = IConstants.FILE_EXTENSION_LIST;
        int n = IConstants.FILE_EXTENSION_LIST.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            IFile file = folder.getFile(String.format(format, ext));
            if (file.exists()) {
                return ProtsymFile.getInstance((IResource)file);
            }
            ++n2;
        }
        return null;
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public synchronized void resourceChanged(IResourceChangeEvent event) {
        }
    }
}

