/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.protsym;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ResourceProperty;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.protsym.Member;
import com.ca.testingtools.protsym.ProtsymDataset;
import com.ca.testingtools.protsym.ProtsymFile;
import com.ca.testingtools.protsym.ProtsymOpen;
import com.ca.testingtools.protsym.ProtsymUtil;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Element;

public class ProtsymImportJob
extends Job {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final boolean noCache = !Boolean.getBoolean("com.ca.testingtools.protsym.cache");
    private static final String REFRESHING = "Getting member %1$s from %2$s @ %3$s";
    private static final String TESTINGTOOLS_SERVER = "testingtools/protsym";
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected final TTServer server;
    private final ProtsymDataset protsym;
    private final Member member;

    public ProtsymImportJob(Member member) {
        super("");
        this.member = member;
        this.protsym = member.getDataset();
        this.server = this.protsym.getParent().getServer();
        this.setName(String.format(REFRESHING, member.getName(), member.getDsn(), this.server.getHostname()));
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.toString().equals("com.ca.testingtools.protsym")) {
            return true;
        }
        return super.belongsTo(family);
    }

    protected IStatus run(IProgressMonitor monitor) {
        int errorLevel = 0;
        String errorMessage = "";
        ServerConnect connect = new ServerConnect(this.server, TESTINGTOOLS_SERVER);
        Properties properties = this.member.getProperties();
        HashMap<String, Object> map = new HashMap<String, Object>(properties.size() + 4);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue());
        }
        try {
            XMLRequest xml;
            IFile ifile;
            IFile iFile = ifile = noCache ? null : ProtsymUtil.getProtsym(this.member);
            if (ifile != null && ifile.exists()) {
                ProtsymFile info = ProtsymFile.getInstance((IResource)ifile);
                ResourceProperty store = info.getStore();
                String time = store.getString("time");
                if (time.equals(this.member.getAttribute("time"))) {
                    xml = connect.connect("info", map, true);
                    errorLevel = xml.getErrorLevel();
                    errorMessage = xml.getErrorMessage();
                    if (errorLevel == 0) {
                        Element member = xml.getFirstMember();
                        time = member.getAttribute("time");
                        if (!time.equals(member.getAttribute("time"))) {
                            ifile = null;
                        }
                    } else {
                        ifile = null;
                    }
                } else {
                    ifile = null;
                }
            }
            if (!(ifile != null && ifile.exists() || errorLevel != 0)) {
                Element command;
                xml = connect.connect("file", map, true);
                errorLevel = xml.getErrorLevel();
                errorMessage = xml.getErrorMessage();
                if (errorLevel == 0 && (command = xml.getCommand()) != null) {
                    String filename = command.getAttribute("localfilename");
                    String fullname = command.getAttribute("filename");
                    File zipfile = new File(filename);
                    FileInputStream zipIn = new FileInputStream(zipfile);
                    IFolder folder = ProtsymUtil.getFolder(this.protsym.getName());
                    IPath file = folder.getFullPath().append(fullname);
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IWorkspaceRoot root = workspace.getRoot();
                    ifile = root.getFile(file);
                    if (ifile.exists()) {
                        ifile.setContents((InputStream)zipIn, true, true, null);
                    } else {
                        ifile.create((InputStream)zipIn, true, null);
                    }
                }
            }
            if (ifile == null && (ifile = ProtsymUtil.getProtsym(this.member)) != null) {
                AskQuestion question = new AskQuestion("Ask", this.member);
                question.schedule();
                question.join();
                if (!question.isOK()) {
                    ifile = null;
                }
            }
            if (ifile != null) {
                ProtsymOpen job = new ProtsymOpen(ifile, this.member);
                job.schedule();
            }
        }
        catch (Exception e) {
            errorLevel = 16;
            errorMessage = "Error attempting to open imported Listing " + HexUtil.getErrorText((Throwable)e);
        }
        if (errorLevel != 0) {
            TT_ErrorDialog.openError(null, (String)"Import Listing", (String)errorMessage);
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private class AskQuestion
    extends UIJob {
        private Member member;
        private boolean result;

        public AskQuestion(String name, Member member) {
            super(name);
            this.member = member;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            String message = String.format("A request to open %s(%s)\ndid not open the correct member but a local copy exists (with a different date)\nDo you want to open this?", this.member.getDsn(), this.member.getName());
            this.result = MessageDialog.openQuestion(null, (String)"Open PROTSYM File", (String)message);
            return new Status(0, "com.ca.testingtools.protsym", 0, "done", null);
        }

        public boolean isOK() {
            return this.result;
        }
    }
}

