/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.TTException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Numbers {
    static final String cacopyright = "Copyright (c) 2017 CA";
    private static final String sourceClass = Numbers.class.getName();
    static Logger log = Logger.getLogger(sourceClass);
    static final char NEGATIVE = '-';
    static final char POSITIVE = '+';
    static final String EMPTY = "";
    public static final Integer ByteSize = new BigDecimal(new BigInteger("FF", 16)).precision();
    public static final Integer ShortSize = new BigDecimal(new BigInteger("FFFF", 16)).precision();
    public static final Integer IntSize = new BigDecimal(new BigInteger("FFFFFFFF", 16)).precision();
    public static final Integer LongSize = new BigDecimal(new BigInteger("FFFFFFFFFFFFFFFF", 16)).precision();
    public static final String UNSIGNED = "[0-9]+";
    public static final String SIGNED = "[0-9-+]+";
    public static final String UNSIGNED_REAL = "[0-9\\.]+";
    public static final String SIGNED_REAL = "[0-9\\.+-]+";
    private static final char PLUS = 'N';
    private static final char MINUS = '`';
    private static final int fullbits = 65536;

    private Numbers() {
    }

    public static boolean validateNumber(String value, int decimals, int digits, boolean signed) throws Exception {
        return Numbers.validateNumber(Numbers.formatNumber(value), decimals, digits, signed);
    }

    public static boolean validateNumber(BigDecimal value, int decimals, boolean signed, Number target) throws Exception {
        if (!signed && value.signum() < 0) {
            throw new TTException("Signed Number");
        }
        if (decimals != 0) {
            value = value.setScale(decimals);
            value = value.movePointRight(decimals);
        }
        if (target instanceof Long) {
            value.longValue();
        } else if (target instanceof Short) {
            value.shortValueExact();
        } else if (target instanceof Byte) {
            value.byteValueExact();
        } else {
            value.intValueExact();
        }
        return true;
    }

    public static boolean validateNumber(BigDecimal value, int decimals, int digits, boolean signed) throws Exception {
        if (!signed && value.signum() < 0) {
            throw new TTException("Signed Number");
        }
        if ((value = value.setScale(decimals)).precision() > digits) {
            throw new TTException("Number Range");
        }
        return true;
    }

    public static byte[] buildDisplayNumber(BigInteger number, int size, boolean right) {
        byte[] bytes = null;
        String format = String.format("%%0%dd", size);
        String result = String.format(format, number.abs());
        try {
            bytes = result.getBytes("IBM1047");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.INFO, EMPTY, e);
        }
        if (number.signum() < 0) {
            int ix = right ? bytes.length - 1 : 0;
            byte item = (byte)(bytes[ix] & 0xF);
            bytes[ix] = item = (byte)(item | 0xD0);
        }
        return bytes;
    }

    public static byte[] buildDisplayNumberSeparate(BigInteger number, int size, boolean right) {
        byte[] bytes = null;
        String sign = number.signum() < 0 ? "-" : "+";
        String format = String.format("%%0%dd", size);
        String result = String.format(format, number.abs());
        result = right ? result + sign : sign + result;
        try {
            bytes = result.getBytes("IBM1047");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.INFO, EMPTY, e);
        }
        return bytes;
    }

    public static BigDecimal formatDisplayNumber(byte[] source) throws Exception {
        int ix = source.length - 1;
        boolean negative = false;
        boolean found = false;
        byte sign = source[ix];
        if (sign == 78 || sign == 96) {
            found = true;
        } else {
            sign = source[0];
            if (sign == 78 || sign == 96) {
                found = true;
            } else {
                sign = (byte)(source[ix] & 0xF0);
                switch (sign) {
                    case -48: {
                        negative = true;
                    }
                    case -64: {
                        int n = ix;
                        source[n] = (byte)(source[n] | 0xFFFFFFF0);
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    sign = (byte)(source[0] & 0xF0);
                    switch (sign) {
                        case -48: {
                            negative = true;
                        }
                        case -64: {
                            source[0] = (byte)(source[0] | 0xFFFFFFF0);
                            break;
                        }
                    }
                }
            }
        }
        BigDecimal result = Numbers.formatNumber(new String(source, "IBM1047"));
        return negative ? result.negate() : result;
    }

    public static BigDecimal formatNumber(String value) throws Exception {
        value = value.trim();
        int end = value.length();
        if (end-- == 0) {
            return new BigDecimal(0);
        }
        DecimalFormat format = new DecimalFormat();
        format.setParseBigDecimal(true);
        if (end > 0) {
            if (value.charAt(end) == '-') {
                format.setNegativeSuffix(String.valueOf('-'));
                format.setNegativePrefix(EMPTY);
            } else if (value.charAt(0) == '-') {
                format.setNegativeSuffix(EMPTY);
                format.setNegativePrefix(String.valueOf('-'));
            } else if (value.charAt(end) == '+') {
                format.setPositiveSuffix(String.valueOf('+'));
                format.setPositivePrefix(EMPTY);
            } else if (value.charAt(0) == '+') {
                format.setPositiveSuffix(EMPTY);
                format.setPositivePrefix(String.valueOf('+'));
            }
        }
        return (BigDecimal)format.parse(value);
    }

    public static byte[] pack(String input, int len) throws Exception {
        byte[] bytes = Numbers.pack(input, false);
        if (bytes.length > len) {
            throw new TTException("Number too big for target");
        }
        if (bytes.length < len) {
            byte[] newbytes = new byte[len];
            int ix = bytes.length;
            System.arraycopy(bytes, 0, newbytes, len - ix, ix);
            bytes = newbytes;
        }
        return bytes;
    }

    public static byte[] pack(String input, int len, boolean signed) throws Exception {
        byte[] bytes = Numbers.pack(input, signed);
        if (bytes.length > len) {
            throw new TTException("Number too big for target");
        }
        if (bytes.length < len) {
            byte[] newbytes = new byte[len];
            int ix = bytes.length;
            System.arraycopy(bytes, 0, newbytes, len - ix, ix);
            bytes = newbytes;
        }
        return bytes;
    }

    public static byte[] pack(String input, boolean signed) throws Exception {
        if (input == null) {
            input = "0";
        }
        BigDecimal decimal = Numbers.formatNumber(input);
        BigInteger integer = decimal.unscaledValue();
        input = integer.abs().toString();
        StringBuilder str = new StringBuilder(input.length() + 2);
        if (input.length() % 2 == 0) {
            str.append('0');
        }
        str.append(input);
        if (integer.signum() < 0) {
            str.append('D');
        } else if (signed) {
            str.append('C');
        } else {
            str.append('F');
        }
        int size = str.length() / 2;
        byte[] b = new byte[size];
        int index = str.length();
        int counter = 0;
        for (int i = 0; i < index; i += 2) {
            String substr = str.substring(i, i + 2);
            b[counter++] = (byte)Integer.parseInt(substr, 16);
        }
        return b;
    }

    public static byte[] pack(int input, int len) throws Exception {
        String format = String.format("%%0%dd", len);
        String result = String.format(format, input);
        byte[] bytes = Numbers.pack(result, false);
        if (bytes.length > len) {
            throw new TTException("Number too big for target");
        }
        if (bytes.length < len) {
            byte[] newbytes = new byte[len];
            int ix = bytes.length;
            System.arraycopy(bytes, 0, newbytes, len - ix, ix);
            bytes = newbytes;
        }
        return bytes;
    }

    public static byte[] pack(BigInteger input, int len) throws Exception {
        String format = String.format("%%0%dd", len);
        String result = String.format(format, input);
        return Numbers.pack(result, len);
    }

    public static byte[] pack(BigInteger input, int len, boolean signed) throws Exception {
        String format = String.format("%%0%dd", len);
        String result = String.format(format, input);
        return Numbers.pack(result, len, signed);
    }

    public static BigInteger unpack(byte[] bytes) throws Exception {
        Formatter fmt = new Formatter();
        for (byte element : bytes) {
            fmt.format("%0$02X", element);
        }
        return Numbers.unpack(fmt.toString());
    }

    public static BigInteger unpack(String string) throws Exception {
        int ix = string.length() - 1;
        try {
            BigInteger bigint = new BigInteger(string.substring(0, ix));
            char sign = string.charAt(ix);
            switch (sign) {
                case 'D': 
                case 'd': {
                    bigint = bigint.negate();
                    break;
                }
                case 'C': 
                case 'F': 
                case 'c': 
                case 'f': {
                    break;
                }
                default: {
                    throw new NumberFormatException(String.format("%s is not a valid packed number", string));
                }
            }
            return bigint;
        }
        catch (Exception e) {
            throw new NumberFormatException(String.format("%s is not a valid packed number", string));
        }
    }

    public static int getUShort(short value) {
        return value < 0 ? 65536 + value : value;
    }

    public static short putUShort(int value) {
        return value > Short.MAX_VALUE ? (short)(value - 65536) : (short)value;
    }
}

