/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.ui.dialogs;

import com.ca.symdump.Activator;
import com.ca.symdump.views.cicstrace.CicsTraceView;
import com.ca.symdump.views.cicstrace.CicsTraceViewFilter;
import com.ca.testingtools.ui.VerifyAlphaNumeric;
import com.ca.testingtools.ui.dialogs.TestingToolsDialog;
import com.ca.testingtools.ui.verifytoUpperCase;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Bundle;

public class CICSTraceFilterDialog
extends TestingToolsDialog
implements Listener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String ENTER_FILTER_DATA = "Enter Filter Selections";
    private Text task;
    private Text tcb;
    private Text domain;
    private Text traceid;
    private Text mod;
    private Text finddata;
    private Bundle bundle;
    private CicsTraceViewFilter filter;
    private Button filtersw;

    public CICSTraceFilterDialog(Shell parentShell, IWorkbenchPart part) {
        super(parentShell);
        this.CONTEXT_HELP_ID = "com.ca.symdump.help.cicstracefilter";
        this.bundle = Activator.plugin.getBundle();
        CicsTraceView view = (CicsTraceView)part;
        this.filter = view.getFilter();
    }

    public CICSTraceFilterDialog(IShellProvider parentShell, IWorkbenchPart part) {
        super(parentShell);
        this.CONTEXT_HELP_ID = "com.ca.symdump.help.cicstracefilter";
    }

    protected Control createDialogArea(Composite parent) {
        Point extent;
        this.getShell().setText("CICS Trace Filter");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        Label label = new Label(composite, 1);
        label = new Label(composite, 0x1000000);
        label.setText(ENTER_FILTER_DATA);
        label = new Label(composite, 0);
        label.setText("Task");
        this.task = new Text(composite, 2048);
        this.task.setText(this.filter.getTask());
        this.task.setTextLimit(5);
        GridData data = new GridData(32);
        GC gc = new GC((Drawable)this.task);
        try {
            extent = gc.textExtent("W");
            data.widthHint = 5 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.task.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText("TCB");
        this.tcb = new Text(composite, 2048);
        this.tcb.setText(this.filter.getTcb());
        this.tcb.setTextLimit(2);
        data = new GridData();
        gc = new GC((Drawable)this.tcb);
        try {
            extent = gc.textExtent("W");
            data.widthHint = 2 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.tcb.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText("Domain");
        this.domain = new Text(composite, 2048);
        this.domain.setText(this.filter.getDomain());
        this.domain.setTextLimit(2);
        data = new GridData();
        gc = new GC((Drawable)this.domain);
        try {
            extent = gc.textExtent("W");
            data.widthHint = 2 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.domain.setLayoutData((Object)data);
        StringBuilder domainstring = new StringBuilder();
        domainstring.append(this.domain);
        label = new Label(composite, 0);
        label.setText("Trace ID");
        this.traceid = new Text(composite, 2048);
        this.traceid.setText(this.filter.getTraceid());
        this.traceid.setTextLimit(4);
        data = new GridData();
        gc = new GC((Drawable)this.traceid);
        try {
            extent = gc.textExtent("W");
            data.widthHint = 4 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.traceid.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText("Module");
        this.mod = new Text(composite, 2048);
        this.mod.setText(this.filter.getMod());
        this.mod.setTextLimit(5);
        data = new GridData();
        gc = new GC((Drawable)this.mod);
        try {
            extent = gc.textExtent("W");
            data.widthHint = 5 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.mod.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText("Data");
        this.finddata = new Text(composite, 2048);
        this.finddata.setText(this.filter.getFinddata());
        data = new GridData();
        gc = new GC((Drawable)this.finddata);
        try {
            extent = gc.textExtent("W");
            data.widthHint = 15 * extent.x;
        }
        finally {
            gc.dispose();
        }
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 1;
        this.finddata.setLayoutData((Object)data);
        this.filtersw = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        gc.dispose();
        this.filtersw.setSelection(this.filter.getFiltersw().booleanValue());
        this.filtersw.setText("Apply Filter Selections");
        this.filtersw.setLayoutData((Object)data);
        this.task.addVerifyListener((VerifyListener)new VerifyAlphaNumeric());
        this.tcb.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.domain.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.traceid.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.mod.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.task.addListener(24, (Listener)this);
        this.tcb.addListener(24, (Listener)this);
        this.domain.addListener(24, (Listener)this);
        this.traceid.addListener(24, (Listener)this);
        this.mod.addListener(24, (Listener)this);
        this.finddata.addListener(24, (Listener)this);
        this.filtersw.addListener(24, (Listener)this);
        if (this.task.getText().length() == 0) {
            this.task.setFocus();
        } else {
            this.tcb.setFocus();
        }
        return composite;
    }

    protected Bundle getBundle() {
        return this.bundle;
    }

    public void handleEvent(Event event) {
    }

    private void checkButtons() {
        boolean ok = true;
        this.getButton(0).setEnabled(ok);
    }

    protected void okPressed() {
        this.filter.setTask(this.task.getText());
        this.filter.setTcb(this.tcb.getText());
        this.filter.setDomain(this.domain.getText());
        this.filter.setTraceid(this.traceid.getText());
        this.filter.setMod(this.mod.getText());
        this.filter.setFinddata(this.finddata.getText());
        this.filter.setFiltersw(this.filtersw.getSelection());
        super.okPressed();
    }

    public void create() {
        super.create();
        this.checkButtons();
    }
}

