/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.handlers;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.views.tree.DumpTreeView;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.ui.dialogs.StandbyDialog;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

class RunGetDump
extends Job
implements IJobChangeListener {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private StandbyDialog dialog;
    private Abend abend;
    private IWorkbenchPartSite site;
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    RunGetDump(Abend abend, IWorkbenchPartSite site) {
        super("Getting dump for " + abend.toString());
        this.abend = abend;
        this.site = site;
        this.addJobChangeListener(this);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.abend.getDumpTree();
        }
        catch (TTException e) {
            String title = "Dump Open Failure";
            String reason = e.getReasonCode();
            String message = String.format("Open of dump failed: %s\n%s", e.getErrorMessage(), this.abend.toString());
            this.log.log(Level.WARNING, title, e);
            Throwable cause = e.getCause();
            if (cause == null) {
                TT_ErrorDialog.openError(null, (String)title, (String)message, (Throwable)new Exception(reason));
            }
            TT_ErrorDialog.openError(null, (String)title, (String)message, (Throwable)cause);
        }
        return Status.OK_STATUS;
    }

    public void aboutToRun(IJobChangeEvent event) {
        Display display = this.site.getShell().getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    RunGetDump.this.dialog = new StandbyDialog(RunGetDump.this.site.getShell(), "Loading Dump Tree.");
                    RunGetDump.this.dialog.open();
                }
            });
        }
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        Display display = this.site.getShell().getDisplay();
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (RunGetDump.this.dialog != null) {
                        RunGetDump.this.dialog.close();
                    }
                    try {
                        IWorkbenchPage page;
                        IViewPart viewPart;
                        DumpTreeNode node = RunGetDump.this.abend.getDumpTree(false);
                        if (node != null && (viewPart = (page = RunGetDump.this.site.getPage()).showView("com.ca.symdump.ui.views.treeview")) instanceof DumpTreeView) {
                            DumpTreeView viewer = (DumpTreeView)viewPart;
                            viewer.addContent(RunGetDump.this.abend);
                            TreeViewer view = viewer.getViewer();
                            view.setSelection((ISelection)new StructuredSelection((Object)RunGetDump.this.abend), true);
                            view.getTree().setFocus();
                        }
                    }
                    catch (TTException e) {
                        RunGetDump.this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                    }
                    catch (PartInitException e) {
                        RunGetDump.this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                    }
                }
            });
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

