/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.handlers;

import com.ca.symdump.CICSTraceLine;
import com.ca.symdump.ui.wizards.WatchWizard;
import com.ca.symdump.views.cicstrace.CicsTraceView;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.ui.views.datawatch.WatchData;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class DumpWatchItemHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!(sel instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        if (selection.size() != 1) {
            return null;
        }
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        Object object = selection.getFirstElement();
        if (object instanceof CICSTraceLine) {
            CICSTraceLine traceLine = (CICSTraceLine)object;
            CicsTraceView traceView = (CicsTraceView)part;
            IMemoryManager manager = traceView.getAbend().getMemoryManager();
            traceLine.setMemoryManager(manager);
        } else if (!(object instanceof IWatchData)) {
            return null;
        }
        WatchWizard wizard = new WatchWizard();
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IWorkbench workbench = window.getWorkbench();
        wizard.init(workbench, object);
        Shell shell = window.getShell();
        TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            Data data = wizard.newData();
            if (data == null || data.isEmpty()) {
                MessageDialog.openWarning((Shell)part.getSite().getShell(), (String)"Add data to Watch View", (String)String.format("Data for %s is not available", data.getHexText()));
            } else {
                data.setTitle(data.getAddress().toString());
                try {
                    IWorkbenchWindow watchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = watchWindow.getActivePage();
                    IViewPart viewPart = page.showView("com.ca.testingtools.ui.views.watchdataview");
                    if (viewPart instanceof WatchData) {
                        WatchData viewer = (WatchData)viewPart;
                        viewer.addContent((IWatchData[])new Data[]{data});
                    }
                    page.activate((IWorkbenchPart)viewPart);
                    page.bringToTop((IWorkbenchPart)viewPart);
                    page.activate((IWorkbenchPart)viewPart);
                }
                catch (PartInitException e) {
                    this.log.log(Level.WARNING, "Unexpected failure", e);
                }
            }
        }
        return null;
    }
}

