/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump;

import com.ca.testingtools.common.Cavhconf;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.TTHttpException;
import com.ca.testingtools.common.XMLCavhuapi;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.ServerStatusJob;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.ui.dialogs.StandbyDialog;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IViewPart;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class SymDumpProfileNode
extends ProfileNode {
    protected static final String ERROR_CAVHCONF_OBTAIN = "CAVHCONF could not be obtained from the server.";
    protected static final String ERROR_CAVHCONF_REASON = "The CAVHCONF configuration module, which is loaded into the CSA, indicates that the product is not intended to be used on this system.";
    protected static final String ERROR_CAVHCONF_MESSAGE = "CA SymDump not available on this system as set in CAVHCONF.";
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private IViewPart viewPart = null;

    public abstract XMLRequest getOptions(ProfileNode var1);

    public boolean hasOptions() {
        return this.viewPart != null;
    }

    public void setOptionsView(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    protected void setCavhconf(boolean checkCavhconf, Cavhconf cavhconf) {
    }

    protected void checkPint() {
        TTServer server;
        block13: {
            server = (TTServer)this.getServer();
            StandbyDialog dialogStatus = new StandbyDialog(null, "Fetching server status.");
            dialogStatus.open();
            ServerStatusJob jobStatus = new ServerStatusJob(server);
            jobStatus.schedule();
            try {
                try {
                    jobStatus.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    dialogStatus.close();
                    break block13;
                }
            }
            catch (Throwable throwable) {
                dialogStatus.close();
                throw throwable;
            }
            dialogStatus.close();
        }
        if (server.isActive()) {
            XMLDocument xmldoc = null;
            try {
                xmldoc = XMLCavhuapi.generatePintRequest();
            }
            catch (TTException e) {
                e.printStackTrace();
            }
            StandbyDialog dialog = new StandbyDialog(null, "Fetching server configuration.");
            dialog.open();
            CheckPintJob job = new CheckPintJob(this, xmldoc);
            job.schedule();
            try {
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    dialog.close();
                }
            }
            finally {
                dialog.close();
            }
        }
    }

    private class CheckPintJob
    extends Job {
        private TTServer server;
        private XMLDocument xmlDoc;
        private SymDumpProfileNode node;

        public CheckPintJob(SymDumpProfileNode node, XMLDocument xmlDoc) {
            super(node.getName());
            this.node = node;
            this.server = (TTServer)node.getServer();
            this.xmlDoc = xmlDoc;
        }

        protected IStatus run(IProgressMonitor monitor) {
            ServerConnect connection = new ServerConnect(this.server, "testingtools/utility");
            XMLRequest xmlResponse = null;
            HashMap map = new HashMap();
            try {
                xmlResponse = connection.connect("conf", map, true, this.xmlDoc);
            }
            catch (TTHttpException e) {
                if (e.getHttpStatusCode() == 404) {
                    this.node.setCavhconf(false, null);
                    return Status.OK_STATUS;
                }
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            catch (TTException e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = null;
            try {
                dBuilder = dbFactory.newDocumentBuilder();
                Document rdoc = dBuilder.parse(xmlResponse.toInputStream());
                this.node.setCavhconf(true, XMLCavhuapi.parseCavhuapiResponse((Document)rdoc));
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            catch (SAXException e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            catch (IOException e) {
                e.printStackTrace();
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

