/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump;

import com.ca.symdump.Abend;
import com.ca.symdump.DumpTreeNode;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class GetDisplay {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    static Logger log = Logger.getLogger(GetDisplay.class.getName());

    public static XMLRequest getDisplay(Abend abend, DumpTreeNode node) throws TTException {
        String errorMessage = "OK";
        int errorLevel = 0;
        ServerConnect connection = new ServerConnect(abend.getServer(), "symdump/server");
        XMLRequest xml = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (node.getTitle().matches("Trace")) {
                map.put("enqu", "enqueue");
            }
            map.put("uuid", abend.getUuid());
            map.put("disp", node.getObjectAddr());
            xml = connection.connect("disp", map, false);
            errorLevel = xml.getErrorLevel();
            if (errorLevel != 0) {
                errorMessage = String.format("ErrorLevel=%d Text=%s", errorLevel, xml.getErrorMessage());
                log.log(Level.WARNING, errorMessage);
                log.log(Level.FINE, "", xml);
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, e.getClass().getSimpleName(), e);
            throw new TTException((Throwable)e);
        }
        return xml;
    }

    public static XMLRequest getDisplay(ProfileNode node, String sys) throws TTException {
        String errorMessage = "OK";
        int errorLevel = 0;
        ServerConnect connection = new ServerConnect((TTServer)node.getServer(), "symdump/server");
        XMLRequest xml = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("symd", sys);
        try {
            xml = connection.connect("IN1T", map, true);
            errorLevel = xml.getErrorLevel();
            if (errorLevel != 0) {
                errorMessage = String.format("ErrorLevel=%d Text=%s", errorLevel, xml.getErrorMessage());
                log.log(Level.WARNING, errorMessage);
                log.log(Level.FINE, "", xml);
                return xml;
            }
            Element element = xml.getCommand();
            map.clear();
            map.put("enqu", "optsenq");
            map.put("uuid", XMLFile.getSessionID((Element)element));
            xml = connection.connect("opts", map, false);
            errorLevel = xml.getErrorLevel();
            if (errorLevel != 0) {
                errorMessage = String.format("ErrorLevel=%d Text=%s", errorLevel, xml.getErrorMessage());
                log.log(Level.WARNING, errorMessage);
                log.log(Level.FINE, "", xml);
            }
        }
        catch (Exception e) {
            throw new TTException((Throwable)e);
        }
        return xml;
    }

    public static XMLRequest getDisaDisplay(Abend abend, String addr) throws TTException {
        if (addr.isEmpty()) {
            return null;
        }
        String errorMessage = "OK";
        int errorLevel = 0;
        ServerConnect connection = new ServerConnect(abend.getServer(), "symdump/server");
        XMLRequest xml = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("uuid", abend.getUuid());
            map.put("disa", addr);
            xml = connection.connect("disa", map, false);
            errorLevel = xml.getErrorLevel();
            if (errorLevel != 0) {
                errorMessage = String.format("ErrorLevel=%d Text=%s", errorLevel, xml.getErrorMessage());
                log.log(Level.WARNING, errorMessage);
                log.log(Level.FINE, "", xml);
            }
            return xml;
        }
        catch (Exception e) {
            log.log(Level.INFO, e.getClass().getSimpleName(), e);
            throw new TTException((Throwable)e);
        }
    }
}

