/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump;

import com.ca.testingtools.logging.Logging;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    public static final String PLUGIN_ID = "com.ca.symdump";
    private static final String CHEATSHEET = "com.ca.testingtools.cheatsheet.overview";
    private static final boolean forceCheatsheet = Boolean.getBoolean("com.ca.symdump.forcecheatsheet");
    public static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Logging.setLogging((Bundle)context.getBundle(), (boolean)true);
        this.setCheatSheet();
    }

    private void setCheatSheet() {
        ScopedPreferenceStore instancePreferences = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.testingtools");
        String cheatsheet = instancePreferences.getString("initial_symdump_cheatsheet");
        if (!CHEATSHEET.equals(cheatsheet) || forceCheatsheet) {
            Display display = Display.getDefault();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OpenCheatSheetAction action = new OpenCheatSheetAction(Activator.CHEATSHEET);
                        action.run();
                    }
                });
            }
            instancePreferences.setValue("initial_symdump_cheatsheet", CHEATSHEET);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

