/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.cics;

import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.cics.Keywords;
import com.ca.symdump.cics.SymCicsAbend;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.ASMVariable;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.Variable;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SymCicsGetData {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String sourceClass = SymCicsGetData.class.getName();
    final Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private static final String SERVICE = "symdump/server";

    public Data getData(DumpTreeNode node) {
        byte[] ver;
        XMLRequest xml;
        MFAddress address;
        ByteArrayOutputStream writer;
        SymCicsAbend abend;
        block6: {
            abend = (SymCicsAbend)node.getAbend();
            TTServer server = abend.getServer();
            ServerConnect connect = new ServerConnect(server, SERVICE);
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("uuid", abend.getUuid());
            map.put("dump", node.getObjectAddr());
            map.put("cicstoken", abend.getCICSToken());
            writer = new ByteArrayOutputStream(1536);
            address = MFAddress.ZERO_ADDR;
            xml = connect.connect("dump", map, false);
            int errorLevel = xml.getErrorLevel();
            if (errorLevel == 0) break block6;
            return null;
        }
        try {
            Element element = xml.getCommand();
            NodeList nodes = element.getElementsByTagName("Data");
            int index = 0;
            while (index < nodes.getLength()) {
                Element dline = (Element)nodes.item(index);
                if (index == 0) {
                    address = new MFAddress(dline.getAttribute("MFAddress"));
                    this.log.log(Level.FINE, "Address {0}", address.toString());
                }
                String data = dline.getAttribute("Data");
                this.log.log(Level.FINE, "Data {0}", data);
                byte[] bytes = HexUtil.HextoBytes((String)data);
                this.log.log(Level.FINE, "Data Dump", (Object)bytes);
                writer.write(bytes);
                ++index;
            }
        }
        catch (Exception e) {
            this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            return null;
        }
        Data data = new Data(writer.toByteArray(), address, node.getTitle());
        data.setTooltipText(node.getFullTooltipText());
        data.setStride(32);
        data.setMemoryManager(node.getAbend().getMemoryManager());
        String name = node.getTitle();
        if ("CSA".equals(name) && abend.getCICSVersion().isEmpty() && (ver = data.getData(159, 1)).length > 0) {
            String str = Integer.toHexString(ver[0] > 0 ? ver[0] : 0 - ver[0]);
            abend.setCICSVersion(str);
        }
        return data;
    }

    public IWatchData getMapData(DumpTreeNode node) {
        Display display;
        Data data = this.getData(node);
        String name = node.getTitle();
        String version = this.getVersion((SymCicsAbend)node.getAbend());
        try {
            try {
                ASMVariable variable = Keywords.getTree(name, version);
                Variable clone = (Variable)variable.clone();
                clone.adjustOffset(clone.getOffset());
                clone.setMemoryManager(null);
                clone.setProgramName(null);
                clone.setBackingdata(data);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                this.log.log(Level.INFO, e.getClass().getSimpleName(), e);
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, HexUtil.getErrorText((Throwable)e), e);
        }
        if (data != null && (display = Display.getCurrent()) != null) {
            MessageDialog.openWarning((Shell)display.getActiveShell(), (String)"Add Mapped data to Watch View", (String)String.format("Mapping information is not available for %s\nUnmapped data will be shown.", node.getText()));
        }
        return data;
    }

    private String getVersion(SymCicsAbend abend) {
        String version = abend.getCICSVersion();
        if (version.isEmpty()) {
            try {
                for (DumpTreeNode node : DumpTreeNode.getChain((DumpTreeNode)abend.getDumpTree())) {
                    if (!"CSA".equals(node.getTitle())) continue;
                    this.getData(node);
                    version = abend.getCICSVersion();
                    break;
                }
            }
            catch (TTException e) {
                this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
        }
        return version;
    }
}

