/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.batch;

import com.ca.symdump.DumpTreeNode;
import java.util.logging.Level;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class SymBatDumpTreeNode
extends DumpTreeNode {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private boolean noListing = false;

    public SymBatDumpTreeNode(String objectAddr, String string, String miscdata) {
        super(miscdata, string, null);
    }

    public boolean isLeaf() {
        return !this.isSymbolicNode();
    }

    public int getStartLine() {
        return this.startLine < 2 ? 0 : this.startLine + 2;
    }

    public int getEndLine() {
        if (this.endLine == 0 && this.children.size() > 0) {
            this.endLine = ((DumpTreeNode)this.children.get(0)).getStartLine() - 1;
        }
        return this.endLine < 2 ? 0 : this.endLine + 2;
    }

    public void pushDown(int lines) {
    }

    public void insertReport(Document newDoc, boolean decorate) {
        Document document = this.getAbend().getDocument();
        try {
            document.replace(0, document.getLength(), newDoc.get());
        }
        catch (BadLocationException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
    }

    public boolean hasReport() {
        Document doc = this.getAbend().getDocument();
        return doc.getLength() != 0;
    }

    public boolean isSymbolicNode() {
        if (this.noListing) {
            return false;
        }
        String title = this.getTitle().toUpperCase();
        if (title.equalsIgnoreCase("abending statement")) {
            return true;
        }
        if (title.startsWith("LAST STATEMENT")) {
            return true;
        }
        this.noListing = true;
        return false;
    }

    public boolean isNoListing() {
        return this.noListing;
    }

    public void setNoListing(boolean noListing) {
        this.noListing = noListing;
    }
}

