/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.batch;

import com.ca.symdump.GetDisplay;
import com.ca.symdump.SymDumpProfileNode;
import com.ca.symdump.batch.SymBatDataset;
import com.ca.symdump.ui.dialogs.SD_ErrorDialog;
import com.ca.testingtools.common.Cavhconf;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.NodeChild;
import com.ca.testingtools.core.ProfileNode;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TTServerObserver;
import java.util.logging.Level;
import org.eclipse.swt.graphics.Image;

public class BatchProfileNode
extends SymDumpProfileNode
implements TTServerObserver {
    private static final String ERROR_DIALOG_TITLE = "CA SymDump Batch";
    private static final String SERVER_STATUS_OBSERVER_NAME = "SymDumpBatchProfileNode";
    private Cavhconf cavhconf = null;
    private boolean checkCavhconf = true;
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    XMLRequest xml = null;

    public NodeChild buildChild() {
        return new SymBatDataset(null);
    }

    public Image getImage() {
        return null;
    }

    public String getText() {
        return this.getName();
    }

    public boolean callHaveDefaultChild() {
        return true;
    }

    public XMLRequest getOptions(ProfileNode node) {
        try {
            if (this.isEnabled()) {
                try {
                    this.xml = GetDisplay.getDisplay((ProfileNode)this, (String)"BAT");
                }
                catch (TTException e) {
                    this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
                }
            } else {
                this.reportCavhconfError();
            }
        }
        catch (TTException e) {
            this.reportCavhconfError(e);
        }
        return this.xml;
    }

    public void reportCavhconfError() {
        this.reportCavhconfError(new TTException("The CAVHCONF configuration module, which is loaded into the CSA, indicates that the product is not intended to be used on this system."));
    }

    public void reportCavhconfError(TTException e) {
        SD_ErrorDialog.openError(null, (String)ERROR_DIALOG_TITLE, (String)"CA SymDump not available on this system as set in CAVHCONF.", (Throwable)e);
    }

    public void notifyObserver() {
        this.cavhconf = null;
        this.checkCavhconf = true;
    }

    public String getObserverName() {
        return SERVER_STATUS_OBSERVER_NAME;
    }

    public boolean isEnabled() throws TTException {
        if (this.checkCavhconf && this.cavhconf == null) {
            this.checkPint();
            TTServer server = (TTServer)this.getServer();
            server.registerStatusObserver((TTServerObserver)this);
        }
        if (!this.checkCavhconf) {
            return true;
        }
        if (this.cavhconf == null) {
            throw new TTException("CAVHCONF could not be obtained from the server.");
        }
        return this.cavhconf.isPintSymbt();
    }

    protected void setCavhconf(boolean checkCavhconf, Cavhconf cavhconf) {
        this.cavhconf = cavhconf;
        this.checkCavhconf = checkCavhconf;
    }
}

