/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.batch;

import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.batch.SymBatAbend;
import com.ca.symdump.batch.SymBatDumpTreeNode;
import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.core.ASMVariable;
import com.ca.testingtools.core.CobolVariable;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.Label;
import com.ca.testingtools.core.PLIVariable;
import com.ca.testingtools.core.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;

public class BatchMemory2
implements IMemoryManager {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String STATIC = "STATIC";
    private static final Pattern blockLocators = Pattern.compile("\\[BL[LWFKX]=[0-9A-F]{4}]");
    private static final Pattern registerLocators = Pattern.compile("^R[0-9][ 0-5] ");
    private static final Pattern wordLocators = Pattern.compile("\\[{1}[\\w@:\\-]+]");
    Logger log = Logger.getLogger(this.getClass().getName());
    private boolean memorySet;
    private HashMap<String, MFAddress> specialAddress;
    private ArrayList<Data> addressBlocks;
    private SymBatAbend abend;
    private SymBatDumpTreeNode root;

    public BatchMemory2(DumpTreeNode dumpTreeNode) {
        this.abend = (SymBatAbend)dumpTreeNode.getAbend();
        this.root = (SymBatDumpTreeNode)dumpTreeNode.getRoot();
    }

    public Data getMemory(IWatchData variable) {
        if (variable instanceof Variable) {
            this.setMemory();
            Variable symbolVariable = (Variable)variable;
            Variable root = symbolVariable.getBaseVariable();
            if (root instanceof CobolVariable) {
                return this.cobolData((CobolVariable)root);
            }
            if (root instanceof ASMVariable) {
                return this.asmData((ASMVariable)root);
            }
            if (root instanceof PLIVariable) {
                return this.PLIData((PLIVariable)root);
            }
        }
        return null;
    }

    private Data PLIData(PLIVariable variable) {
        MFAddress address = null;
        String findCell = null;
        if (variable.isBased()) {
            PLIVariable base = variable.getBase();
            Data data = this.PLIData(base);
            if (data == null) {
                return null;
            }
            int iPvltp = (Integer)Attribute.getValue((String)"gt_pvltp", (Properties)variable.getAttributes());
            address = data.getAddress();
            if ((iPvltp &= 4) == 0) {
                try {
                    address = new MFAddress(data.getData());
                }
                catch (Exception e) {
                    this.log.log(Level.FINE, e.getClass().getSimpleName(), e);
                    return null;
                }
            }
        } else {
            int pvdes = (Integer)Attribute.getValue((String)"gt_pvdes", (Properties)variable.getAttributes());
            if ((pvdes & 8) == 8) {
                String external = (String)Attribute.getValue((String)"gt_excst", (Properties)variable.getAttributes());
                if (external.isEmpty()) {
                    return null;
                }
                findCell = String.format("EXTERNAL:%s", external);
            } else {
                int gt_dstyp = (Integer)Attribute.getValue((String)"gt_dstyp", (Properties)variable.getAttributes());
                switch (gt_dstyp &= 5) {
                    case 4: {
                        findCell = STATIC;
                        break;
                    }
                    case 5: {
                        Label proc = variable.getParentProc();
                        String procname = null;
                        if (proc == null) break;
                        procname = proc.getName();
                        findCell = String.format("DYNAMIC SAVE AREA:DSA:%s", procname);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
        }
        if ((address = this.specialAddress.get(String.valueOf(findCell) + " PGM:" + variable.getProgramName())) == null) {
            return null;
        }
        if (!MFAddress.ZERO_ADDR.equals((Object)address)) {
            address = address.add((long)variable.getBaseoffset());
            return this.getMemory(address, variable.getLength());
        }
        return null;
    }

    private Data asmData(ASMVariable variable) {
        MFAddress address = variable.getAddress();
        if (MFAddress.ZERO_ADDR.equals((Object)address)) {
            String register = String.format("R%d  PGM:%s", variable.getBase_reg(), variable.getProgramName());
            address = this.specialAddress.get(register);
        }
        if (address != null && !MFAddress.ZERO_ADDR.equals((Object)address)) {
            int disp = (Integer)Attribute.getValue((String)"gt_disp", (Properties)variable.getAttributes());
            address = address.add((long)disp);
            return this.getMemory(address, variable.getLength());
        }
        return null;
    }

    private Data cobolData(CobolVariable variable) {
        MFAddress address;
        block13: {
            address = variable.getAddress();
            if (MFAddress.ZERO_ADDR.equals((Object)address)) {
                String blType;
                int bltype = (Integer)Attribute.getValue((String)"gt_base", (Properties)variable.getAttributes());
                switch (bltype) {
                    case 1: {
                        blType = "BLW";
                        break;
                    }
                    case 2: {
                        blType = "BLL";
                        break;
                    }
                    case 3: {
                        blType = "BLF";
                        break;
                    }
                    case 8: {
                        blType = "BLX";
                        break;
                    }
                    case 9: {
                        blType = "BLK";
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                String cellStr = variable.getAttribute("gt_cell");
                if (cellStr != null && !cellStr.isEmpty()) {
                    try {
                        int cell = Integer.parseInt(cellStr);
                        String findCell = String.format("%s=%04X PGM=%s", blType, cell, variable.getProgramName());
                        address = this.specialAddress.get(findCell);
                        if (address == null) {
                            return null;
                        }
                        break block13;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                return null;
            }
        }
        if (!MFAddress.ZERO_ADDR.equals((Object)address)) {
            int disp = (Integer)Attribute.getValue((String)"gt_disp", (Properties)variable.getAttributes());
            address = address.add((long)disp);
            return this.getMemory(address, variable.getLength());
        }
        return null;
    }

    public Data getMemory(MFAddress address, int length) {
        this.setMemory();
        int index = this.findParent(address, 0);
        if (index == -1) {
            return null;
        }
        Data data = this.addressBlocks.get(index);
        MFAddress dataAddress = data.getAddress();
        long offset = address.subtract(dataAddress);
        Data newdata = new Data(data.getData((int)offset, length), address, "Backing Data");
        newdata.setMemoryManager((IMemoryManager)this);
        return newdata;
    }

    private void setMemory() {
        if (this.memorySet) {
            return;
        }
        this.specialAddress = new HashMap();
        this.addressBlocks = new ArrayList();
        this.memorySet = true;
        ArrayList<Data> list = this.getMemory(this.root);
        for (Data data : list) {
            this.setMemory(data);
        }
        this.getRegisters(this.root);
        this.log.log(Level.FINE, "Special Address {0}", this.specialAddress);
    }

    private boolean getRegisters(SymBatDumpTreeNode node) {
        if (node.getTitle().equalsIgnoreCase("REGISTERS AT ABEND")) {
            this.setRegisters(node);
            return true;
        }
        DumpTreeNode[] dumpTreeNodeArray = node.getChildren();
        int n = dumpTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DumpTreeNode child = dumpTreeNodeArray[n2];
            if (this.getRegisters((SymBatDumpTreeNode)child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setRegisters(SymBatDumpTreeNode node) {
        Document document = this.abend.getDocument();
        if (document == null) {
            return;
        }
        int startline = node.getStartLine();
        int endline = 0;
        int regCount = 0;
        endline = node.getEndLine();
        try {
            String[] lines;
            int firstoffset = document.getLineOffset(startline);
            int lastoffset = endline == 0 ? document.getLength() : document.getLineOffset(endline) - 1;
            int span = lastoffset - firstoffset;
            String region = document.get(firstoffset, span);
            String[] stringArray = lines = region.split(HexUtil.LF);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (regCount > 15) break;
                Matcher register = registerLocators.matcher(line);
                if (register.find()) {
                    ++regCount;
                    String blcell = register.group().trim();
                    int index = line.indexOf(32);
                    while (line.charAt(index) == ' ') {
                        ++index;
                    }
                    int next = line.indexOf(32, index);
                    if (next == -1) {
                        next = line.length();
                    }
                    String addr = line.substring(index, next);
                    try {
                        MFAddress address = new MFAddress(addr);
                        this.specialAddress.put(blcell, address);
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void setMemory(Data data) {
        if (data.isEmpty() || data.getDataType() == Data.DataType.displayOnly) {
            return;
        }
        MFAddress startAddress = data.getAddress();
        if (!startAddress.equals((Object)MFAddress.ZERO_ADDR)) {
            String title = data.getTitle();
            Matcher blCells = blockLocators.matcher(title);
            String program = "";
            if (title.startsWith("PGM:")) {
                int ix = title.indexOf(32);
                program = title.substring(4, ix);
            }
            if (blCells.find()) {
                String blcell = blCells.group();
                title = title.replaceFirst("\\" + blcell, "").trim();
                blcell = blcell.substring(1, blcell.length() - 1);
                this.specialAddress.put(String.format("%s PGM=%s", blcell, program), startAddress);
            } else {
                Matcher words = wordLocators.matcher(title);
                if (words.find()) {
                    String word = words.group();
                    title = title.replaceFirst("\\" + word, "").trim();
                    word = word.substring(1, word.length() - 1);
                    this.specialAddress.put(String.format("%s:%s PGM=%s", title.toUpperCase(), word, program), startAddress);
                } else if (title.toUpperCase().equals(STATIC)) {
                    this.specialAddress.put(STATIC, startAddress);
                }
            }
            int length = data.getLength();
            int index = this.findParent(startAddress, length - 1);
            if (index == -1) {
                Data newdata = new Data(data.getData(), startAddress, title);
                newdata.setMemoryManager((IMemoryManager)this);
                this.addressBlocks.add(newdata);
            } else {
                Data parent = this.addressBlocks.get(index);
                MFAddress newAddress = parent.getAddress().add((long)parent.getLength());
                if (newAddress.equals((Object)startAddress)) {
                    byte[] olddata = parent.getData();
                    byte[] bytes = Arrays.copyOf(olddata, olddata.length + data.getLength());
                    byte[] newdata = data.getData();
                    System.arraycopy(newdata, 0, bytes, olddata.length, newdata.length);
                    parent.setData(bytes);
                }
            }
        }
        Data[] dataArray = data.getChildren();
        int n = dataArray.length;
        int n2 = 0;
        while (n2 < n) {
            Data child = dataArray[n2];
            this.setMemory(child);
            ++n2;
        }
    }

    private int findParent(MFAddress address, int length) {
        int index = 0;
        while (index < this.addressBlocks.size()) {
            Data parent = this.addressBlocks.get(index);
            MFAddress startAddress = parent.getAddress();
            MFAddress endAddress = startAddress.add((long)(parent.getLength() - 1));
            int result = address.compareTo(startAddress);
            if (result >= 0 && (result = address.compareTo(endAddress)) <= 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private ArrayList<Data> getMemory(DumpTreeNode node) {
        ArrayList<Data> list = new ArrayList<Data>();
        Data data = this.abend.getDataItem(node);
        if (data != null && !data.isEmpty()) {
            list.add(data);
        }
        DumpTreeNode[] dumpTreeNodeArray = node.getChildren();
        int n = dumpTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DumpTreeNode child = dumpTreeNodeArray[n2];
            list.addAll(this.getMemory(child));
            ++n2;
        }
        String[] title = node.getTitle().toUpperCase().split(" +");
        if (title.length == 2 && title[0].equals("PROGRAM") && title[1].length() < 9) {
            String prefix = "PGM:" + title[1];
            for (Data item : list) {
                item.setPrefix(prefix);
            }
        }
        return list;
    }

    public void init() {
        this.setMemory();
    }
}

