/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.batch;

import com.ca.symdump.Abend;
import com.ca.symdump.batch.SymBatAbend;
import com.ca.symdump.batch.SymBatDataset;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLFile;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.IProfileSetContent;
import com.ca.testingtools.core.NodeChild;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SymBatListJob
extends Job {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String INDEX_DSNAME = "I Repository Dsname:";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected final TTServer server;
    private final SymBatDataset dataset;
    private IProfileSetContent container;
    private static final String REFRESHING = "Getting index list for %1$s @ %2$s";

    public SymBatListJob(SymBatDataset dataset, TTServer server, IProfileSetContent container) {
        super(String.format(REFRESHING, new Object[]{dataset, server.getName()}));
        this.server = server;
        this.dataset = dataset;
        this.container = container;
    }

    protected IStatus run(IProgressMonitor monitor) {
        ServerConnect connection = new ServerConnect(this.server, "symdump/server");
        HashMap<String, String> map = new HashMap<String, String>();
        XMLRequest xml = null;
        map.put("indx", this.dataset.getName());
        map.put("symd", "bat");
        ArrayList<SymBatAbend> list = null;
        try {
            xml = connection.connect("init", map, true);
            if (xml.getErrorLevel() == 0) {
                Element command = xml.getCommand();
                NodeList lines = command.getElementsByTagName("Line");
                String holdDSN = "";
                list = new ArrayList<SymBatAbend>(lines.getLength());
                int index = 0;
                while (index < lines.getLength()) {
                    Element element = (Element)lines.item(index);
                    String recstring = XMLFile.getStr((Element)element);
                    if (recstring == null) {
                        recstring = "";
                    }
                    char rectype = recstring.charAt(0);
                    switch (rectype) {
                        case 'I': {
                            int ix = recstring.indexOf(INDEX_DSNAME);
                            if (ix == -1) break;
                            holdDSN = recstring.substring(ix + INDEX_DSNAME.length()).trim();
                            break;
                        }
                        case 'H': {
                            this.dataset.setHeaderMap(recstring, new String[]{"S I P"});
                            break;
                        }
                        case 'D': {
                            SymBatAbend abend = new SymBatAbend(element, this.dataset.getHeaderMap());
                            abend.setDataset(this.dataset);
                            abend.setServer(this.server);
                            abend.setDSN(holdDSN);
                            list.add(abend);
                            break;
                        }
                    }
                    ++index;
                }
                NodeList inits = xml.getRoot().getElementsByTagName("init");
                String uuid = ((Element)inits.item(0)).getAttribute("session");
                map.clear();
                map.put("uuid", uuid);
                xml = connection.connect("term", map, false);
            } else {
                this.log.log(Level.INFO, "ErrorLevel={0} Text={1}", new Object[]{xml.getErrorLevel(), xml.getErrorMessage()});
                this.log.log(Level.FINE, "", xml);
            }
        }
        catch (TTException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        if (list != null) {
            if (list.size() > 0) {
                final Abend[] abendlist = list.toArray(new Abend[list.size()]);
                UIJob job = new UIJob("job"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        SymBatListJob.this.container.addContent((Object[])abendlist, true);
                        return new Status(0, "com.ca.symdump.batch", 0, "done", null);
                    }
                };
                job.schedule();
            } else {
                UIJob job = new UIJob("job"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        SymBatListJob.this.container.removeContent(new NodeChild[]{SymBatListJob.this.dataset});
                        return new Status(0, "com.ca.symdump.batch", 0, "done", null);
                    }
                };
                job.schedule();
            }
        }
        return Status.OK_STATUS;
    }
}

