/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.views;

import com.ca.visualdebugger.plugin.views.GraphicalView;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

class BlueBarButton {
    public static final int TRANSACTION = 0;
    public static final int PROGRAM = 1;
    private Composite compButton;
    private CLabel buttonLabel;
    private int type;
    private boolean selected;
    private boolean wasMouseDown;
    private PropertyChangeSupport pcs = null;

    BlueBarButton(Composite parCompButton, CLabel parButtonLabel, int parType) {
        this.compButton = parCompButton;
        this.buttonLabel = parButtonLabel;
        this.type = parType;
        this.setDefaultState();
        this.pcs = new PropertyChangeSupport(this);
        this.buttonLabel.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (BlueBarButton.this.wasMouseDown) {
                    BlueBarButton.this.setSelectedState();
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BlueBarButton.this.pcs.firePropertyChange("selectButton", null, null);
                        }
                    });
                }
                BlueBarButton.this.wasMouseDown = false;
            }

            public void mouseDown(MouseEvent e) {
                BlueBarButton.this.wasMouseDown = true;
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.buttonLabel.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                super.mouseEnter(e);
                if (!BlueBarButton.this.selected) {
                    BlueBarButton.this.setHoverState();
                }
            }

            public void mouseExit(MouseEvent e) {
                super.mouseExit(e);
                if (!BlueBarButton.this.selected) {
                    BlueBarButton.this.setDefaultState();
                }
                BlueBarButton.this.wasMouseDown = false;
            }
        });
    }

    public void setDefaultState() {
        this.buttonLabel.setBackground(GraphicalView.BLUE_BAR_BACKGROUND);
        this.selected = false;
        this.wasMouseDown = false;
    }

    public void setHoverState() {
        this.buttonLabel.setBackground(GraphicalView.BLUE_BAR_BUTTON_HOVER);
        this.selected = false;
    }

    public void setSelectedState() {
        this.buttonLabel.setBackground(GraphicalView.BLUE_BAR_BUTTON_SELECTED);
        this.selected = true;
    }

    public boolean isTransactionButton() {
        return this.type == 0;
    }

    public boolean isProgramButton() {
        return this.type == 1;
    }

    public void addPropertyChangeListener(PropertyChangeListener provider) {
        this.pcs.addPropertyChangeListener(provider);
    }

    public void removePropertyChangeListener(PropertyChangeListener provider) {
        this.pcs.removePropertyChangeListener(provider);
    }

    public String getName() {
        return this.buttonLabel.getText();
    }

    public Composite getCompButton() {
        return this.compButton;
    }

    public void setCompButton(Composite compButton) {
        this.compButton = compButton;
    }

    public CLabel getButtonLabel() {
        return this.buttonLabel;
    }

    public void setButtonLabel(CLabel buttonLabel) {
        this.buttonLabel = buttonLabel;
    }

    public int getType() {
        return this.type;
    }
}

