/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.trace;

import com.ca.intertest.common.XMLTraceUtils;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.dialogs.LoadTraceDialog;
import com.ca.intertest.dialogs.SaveTraceDialog;
import com.ca.visualdebugger.plugin.controller.GraphController;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Shell;

public class TraceHandler {
    private static TraceHandler instance = null;
    private static GraphController graphController = GraphController.getInstance();
    private static Debug debug = Debug.getInstance();

    public static synchronized TraceHandler getInstance() {
        if (instance == null) {
            instance = new TraceHandler();
        }
        return instance;
    }

    public void loadTraceData() {
        Shell shell = graphController.getViewer().getSite().getShell();
        debugSession session = null;
        LoadTraceDialog dialog = new LoadTraceDialog(shell);
        int result = dialog.open();
        if (result == 1) {
            return;
        }
        Object[] selectedTrace = dialog.getResult();
        if (selectedTrace[0] instanceof IFile) {
            IFile fileResource = (IFile)selectedTrace[0];
            session = debug.getSession((IResource)fileResource);
            if (session == null) {
                return;
            }
            String programName = XMLTraceUtils.loadTraceData((String)fileResource.getLocation().toString(), (debugSession)session);
            debug.openListerEditor(programName, session);
            debug.notifyViewForRefresh(session);
        }
        graphController.getViewer().cleanListOfStoredProgramNames();
    }

    public void saveTraceData() {
        debugSession session = graphController.getDebugSession();
        if (session == null) {
            return;
        }
        Shell shell = graphController.getViewer().getSite().getShell();
        IProject project = this.getProject(session.getName());
        if (project == null) {
            return;
        }
        SaveTraceDialog dialog = new SaveTraceDialog(shell, project);
        int result = dialog.open();
        if (result == 1) {
            return;
        }
        String filename = dialog.getFileName();
        String filepath = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString().replace("/", "\\")) + "\\" + session.getName();
        graphController.setPathToListings(filepath);
        File file = new File(String.valueOf(filepath) + File.separator + filename + "." + "trace");
        XMLTraceUtils.saveTraceData((File)file, (debugSession)session);
        try {
            project.refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private IProject getProject(String sessionName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(sessionName);
    }
}

