/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.parser;

import com.ca.intertest.debug.debugFile;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.Statement;
import com.ca.intertest.tools.XMLFile;
import com.ca.visualdebugger.plugin.parser.CobolLabel;
import com.ca.visualdebugger.plugin.parser.CobolVerb;
import com.ca.visualdebugger.plugin.parser.SessionFileReader;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CobolMetadataReader
extends SessionFileReader {
    public static final String PROCEDURE_DIVISION = "PROCEDURE DIVISION";
    public static final String IDENTIFICATION_DIVISION = "IDENTIFICATION DIVISION";
    public static final String ID_DIVISION = "ID DIVISION";
    private static Map<debugFile, CobolMetadataReader> instances = new Hashtable<debugFile, CobolMetadataReader>();
    private XMLFile metadata;
    private Map<Integer, CobolLabel> paragraphs;
    private TreeMap<Integer, Statement> statements;
    private Map<Integer, CobolVerb> verbsByStatementNumber;
    private Map<Integer, CobolVerb> verbsByLineNumber;
    private Integer procDivStatement = -1;
    private Integer idDivStatement = -1;
    private String programName;
    private int numIdDivision = -1;

    public static CobolVerb getNextVerb(CobolVerb currentVerb, Map<Integer, CobolVerb> verbsByStatementNumber) {
        if (currentVerb == verbsByStatementNumber.get(currentVerb.getStatement().getStatement())) {
            SortedSet<Integer> followingVerbNumbers = new TreeSet<Integer>(verbsByStatementNumber.keySet()).tailSet(currentVerb.getStatement().getStatement());
            for (Integer nextVerbNumber : followingVerbNumbers) {
                if (verbsByStatementNumber.get(nextVerbNumber) == currentVerb) continue;
                return verbsByStatementNumber.get(nextVerbNumber);
            }
        }
        return null;
    }

    public static CobolMetadataReader getMetadataReaderFor(debugFile intertestProjectFile) {
        CobolMetadataReader instance = instances.get(intertestProjectFile);
        if (instance == null) {
            instance = new CobolMetadataReader(intertestProjectFile);
            instances.put(intertestProjectFile, instance);
        }
        return instance;
    }

    public static boolean removeMetadataReaderFor(debugFile intertestProjectFile) {
        CobolMetadataReader instance = instances.remove(intertestProjectFile);
        return instance != null;
    }

    private CobolMetadataReader(debugFile intertestProjectFile) {
        super(intertestProjectFile);
        this.initCobolMetadataReader();
    }

    private CobolMetadataReader(String listingsPath) {
        super(listingsPath);
        this.initCobolMetadataReader();
    }

    private CobolMetadataReader(String name, String listingsPath) {
        super(name, listingsPath);
        this.initCobolMetadataReader();
    }

    private void initCobolMetadataReader() {
        block5: {
            InputStream inputStream = this.getMetadataStream();
            if (inputStream != null) break block5;
            this.close();
            return;
        }
        try {
            try {
                this.metadata = new XMLFile(this.getMetadataStream());
            }
            catch (ITException e1) {
                e1.printStackTrace();
                this.close();
            }
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
        this.close();
        this.readVerbs();
    }

    public Map<Integer, CobolVerb> getVerbsByStatementNumber() {
        if (this.verbsByStatementNumber != null) {
            return this.verbsByStatementNumber;
        }
        if (this.metadata == null) {
            return new HashMap<Integer, CobolVerb>();
        }
        this.readVerbs();
        return this.verbsByStatementNumber;
    }

    public CobolVerb getVerbByLine(int lineNum) {
        return this.verbsByLineNumber.get(lineNum);
    }

    public Integer getIdDivisionLine() {
        return this.idDivStatement;
    }

    public boolean isNested() {
        if (this.numIdDivision <= 0) {
            this.numIdDivision = this.getNumOfIdDivisions();
        }
        return this.numIdDivision > 1;
    }

    public boolean isEmpty() {
        boolean isEmpty = false;
        if (this.getMetadataStream() != null) {
            isEmpty = this.metadata.getDsn(this.metadata.getFirstMember()).isEmpty();
        }
        return isEmpty;
    }

    private void readVerbs() {
        if (this.statements == null) {
            this.readStatements();
        }
        if (this.paragraphs == null) {
            this.readParagraphs();
        }
        this.verbsByStatementNumber = new HashMap<Integer, CobolVerb>();
        this.verbsByLineNumber = new HashMap<Integer, CobolVerb>();
        CobolLabel currentParagraph = this.paragraphs.get(this.procDivStatement);
        CobolVerb currentVerb = null;
        block6: for (Map.Entry<Integer, Statement> entry : this.statements.entrySet()) {
            Statement statement = entry.getValue();
            Integer statementFirstNumber = entry.getKey();
            switch (statement.getType()) {
                case LABEL: {
                    if (currentVerb == null && currentParagraph == this.paragraphs.get(this.procDivStatement)) {
                        this.paragraphs.remove(this.procDivStatement);
                    }
                    currentParagraph = this.paragraphs.get(statementFirstNumber);
                    break;
                }
                case VERB: {
                    currentParagraph.setLastStatement(statement);
                    currentVerb = new CobolVerb(statement, currentParagraph);
                    int statementNumber = statement.getStatement();
                    while (statementNumber <= statement.getLaststatement()) {
                        this.verbsByStatementNumber.put(statementNumber, currentVerb);
                        ++statementNumber;
                    }
                    int lineNumber = statement.getLine();
                    while (lineNumber <= statement.getLastline()) {
                        this.verbsByLineNumber.put(lineNumber, currentVerb);
                        ++lineNumber;
                    }
                    continue block6;
                }
                case NOOP: {
                    if (!this.paragraphs.containsKey(statementFirstNumber)) break;
                    currentParagraph = this.paragraphs.get(statementFirstNumber);
                    break;
                }
                case VARIABLE: {
                    break;
                }
            }
        }
    }

    private void readParagraphs() {
        if (this.statements == null) {
            this.readStatements();
        }
        this.paragraphs = new HashMap<Integer, CobolLabel>();
        this.programName = this.metadata.getName(this.metadata.getFirstMember());
        NodeList nodeList = this.getNodeListByTagName("pgmstructure");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element pgmstructure = (Element)nodeList.item(i);
            String name = pgmstructure.getAttribute("name");
            if (name.equals(PROCEDURE_DIVISION)) {
                int statementNumber = Integer.valueOf(pgmstructure.getAttribute("statementnumber"));
                this.paragraphs.put(statementNumber, this.buildCobolLabel(name, this.programName, this.statements.get(statementNumber)));
                this.procDivStatement = this.procDivStatement > 0 ? Integer.valueOf(Math.min(this.procDivStatement, statementNumber)) : Integer.valueOf(statementNumber);
            } else if (name.equals(IDENTIFICATION_DIVISION) || name.equals(ID_DIVISION)) {
                this.idDivStatement = this.idDivStatement > 0 ? Integer.valueOf(Math.min(this.idDivStatement, Integer.valueOf(pgmstructure.getAttribute("linenumber")))) : Integer.valueOf(pgmstructure.getAttribute("linenumber"));
            }
            ++i;
        }
        nodeList = this.getNodeListByTagName("pgmlabel");
        i = 0;
        while (i < nodeList.getLength()) {
            Element pgmlabel = (Element)nodeList.item(i);
            Integer n = Integer.valueOf(pgmlabel.getAttribute("statementnumber"));
            String name = pgmlabel.getAttribute("name");
            this.paragraphs.put(n, this.buildCobolLabel(name, this.programName, this.statements.get(n)));
            ++i;
        }
    }

    private void readStatements() {
        NodeList nodeList = this.getNodeListByTagName("statement");
        this.statements = new TreeMap();
        int i = 0;
        while (i < nodeList.getLength()) {
            Statement statement = new Statement((Element)nodeList.item(i));
            this.statements.put(statement.getStatement(), statement);
            ++i;
        }
    }

    private NodeList getNodeListByTagName(String tagName) {
        return this.metadata.getFirstMember().getElementsByTagName(tagName);
    }

    public CobolVerb getVerbByStatementNumber(int statementNumber) {
        this.readVerbs();
        return this.verbsByStatementNumber.get(statementNumber);
    }

    private int getNumOfIdDivisions() {
        int idDivNum = 0;
        NodeList nodeList = this.getNodeListByTagName("pgmstructure");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element pgmstructure = (Element)nodeList.item(i);
            String name = pgmstructure.getAttribute("name");
            if (name.equals(IDENTIFICATION_DIVISION) || name.equals(ID_DIVISION)) {
                ++idDivNum;
            }
            ++i;
        }
        return idDivNum;
    }

    private CobolLabel buildCobolLabel(String name, String parProgramName, Statement statement) {
        if (this.isNested()) {
            name = String.valueOf(name) + "(" + statement.getLine() + ")";
        }
        return new CobolLabel(name, parProgramName, statement);
    }
}

