/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.parser;

import com.ca.intertest.debug.debugFile;
import com.ca.intertest.tools.Statement;
import com.ca.visualdebugger.plugin.parser.SessionFileReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.stream.Collectors;

public class CobolListingReader
extends SessionFileReader {
    private ArrayList<String> listing;
    private int srcFirstCol = -1;
    private int srcLastCol = -1;
    private int srcCommentCol = -1;
    private int srcAreaACol = -1;
    private int srcAreaBCol = -1;
    private boolean hasColumns = false;
    private static Map<debugFile, CobolListingReader> instances = new Hashtable<debugFile, CobolListingReader>();

    public static CobolListingReader getListingReaderFor(debugFile intertestProjectFile) {
        CobolListingReader instance = instances.get(intertestProjectFile);
        if (instance == null) {
            instance = new CobolListingReader(intertestProjectFile);
            instances.put(intertestProjectFile, instance);
        }
        return instance;
    }

    public static boolean removeListingReaderFor(debugFile intertestProjectFile) {
        CobolListingReader instance = instances.remove(intertestProjectFile);
        return instance != null;
    }

    private CobolListingReader(debugFile debugFile2) {
        super(debugFile2);
        this.initListing();
    }

    private CobolListingReader(String intertestProjectPath) {
        super(intertestProjectPath);
        this.initListing();
    }

    public String getRawLine(int lineNumber) {
        return this.getLine(lineNumber);
    }

    public String getSourceLine(int lineNumber) {
        if (!this.hasColumns) {
            return this.getLine(lineNumber);
        }
        String line = this.getLine(lineNumber);
        int tempLastCol = line.length() < this.srcLastCol ? line.length() : this.srcLastCol;
        return line.substring(this.srcFirstCol, tempLastCol).trim();
    }

    public String getSourceAreaALine(int lineNumber) {
        if (!this.hasColumns) {
            return this.getLine(lineNumber);
        }
        String line = this.getLine(lineNumber);
        int tempLastCol = line.length() < this.srcLastCol ? line.length() : this.srcLastCol;
        return line.substring(this.srcAreaACol, tempLastCol).trim();
    }

    public String getSourceAreaBLine(int lineNumber) {
        if (!this.hasColumns) {
            return this.getLine(lineNumber);
        }
        String line = this.getLine(lineNumber);
        int tempLastCol = line.length() < this.srcLastCol ? line.length() : this.srcLastCol;
        return line.substring(this.srcAreaBCol, tempLastCol).trim();
    }

    public boolean isCommentLine(int lineNumber) {
        if (!this.hasColumns) {
            return false;
        }
        char commentChar = this.getLine(lineNumber).charAt(this.srcCommentCol);
        return commentChar == '*' || commentChar == '/';
    }

    public boolean isDebugLine(int lineNumber) {
        if (!this.hasColumns) {
            return false;
        }
        char commentChar = this.getLine(lineNumber).charAt(this.srcCommentCol);
        return commentChar == 'D' || commentChar == 'd';
    }

    public String getStatementSource(Statement statement) {
        if (statement != null) {
            return this.getStatementSourceInternal(statement.getLine(), statement.getLastline());
        }
        return null;
    }

    public String getStatementSource(int firstStatementLine, int lastStatementLine) {
        if (lastStatementLine >= firstStatementLine) {
            return this.getStatementSourceInternal(firstStatementLine, lastStatementLine);
        }
        return null;
    }

    private String getStatementSourceInternal(int firstStatementLine, int lastStatementLine) {
        String source = "";
        if (!this.hasColumns) {
            return source;
        }
        int l = firstStatementLine;
        while (l <= lastStatementLine) {
            if (this.isSourceLine(l) && !this.isDebugLine(l) && !this.isCommentLine(l)) {
                source = source.concat(" " + this.getSourceAreaALine(l));
            }
            ++l;
        }
        return source.trim();
    }

    private boolean isSourceLine(int lineNumber) {
        return this.getLine(lineNumber).substring(0, 2).trim().isEmpty();
    }

    private void initListing() {
        if (this.getListingStream() != null) {
            this.listing = new BufferedReader(new InputStreamReader(this.getListingStream())).lines().collect(Collectors.toCollection(ArrayList::new));
        }
        for (String line : this.listing) {
            if (line.indexOf("*A-1-B") == -1) continue;
            this.hasColumns = true;
            this.srcCommentCol = line.indexOf("*");
            this.srcFirstCol = this.srcCommentCol - 6;
            this.srcAreaACol = this.srcCommentCol + 1;
            this.srcAreaBCol = this.srcCommentCol + 5;
            this.srcLastCol = this.srcFirstCol + 72;
            break;
        }
    }

    private String getLine(int lineNumber) {
        return this.listing.get(lineNumber - 1);
    }
}

