/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.model;

import com.ca.visualdebugger.plugin.controller.GraphController;
import com.ca.visualdebugger.plugin.model.Edge;
import com.ca.visualdebugger.plugin.model.IGraphEntity;
import java.util.ArrayList;
import java.util.List;

public class Node
implements IGraphEntity {
    private String label;
    private List<Edge> sourceEdges = new ArrayList<Edge>();
    private List<Edge> targetEdges = new ArrayList<Edge>();
    private int traceLogIndex;
    private boolean firstNode;

    public Node(int traceLogIndex) {
        this.traceLogIndex = traceLogIndex;
        this.firstNode = false;
    }

    public Edge findSourceEdge(String toNodeLabel) {
        for (Edge edge : this.sourceEdges) {
            if (!toNodeLabel.equals(edge.getToNode().getLabel())) continue;
            return edge;
        }
        return null;
    }

    public Edge findTargetEdge(String fromNodeLabel) {
        for (Edge edge : this.targetEdges) {
            if (!fromNodeLabel.equals(edge.getFromNode().getLabel())) continue;
            return edge;
        }
        return null;
    }

    public void setFirstNode(boolean state) {
        this.firstNode = state;
    }

    public boolean isFirstNode() {
        return this.firstNode;
    }

    public String getHistoryLabel() {
        int currentHistoryIndex = GraphController.getInstance().getHistoryTraceLogIndex();
        if (currentHistoryIndex < this.traceLogIndex) {
            return "";
        }
        return this.label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void addSourceEdge(Edge sourceEdge) {
        this.sourceEdges.add(sourceEdge);
    }

    public void addTargetEdge(Edge targetEdge) {
        this.targetEdges.add(targetEdge);
    }

    public List<Edge> getSourceEdges() {
        return this.sourceEdges;
    }

    public List<Edge> getTargetEdges() {
        return this.targetEdges;
    }

    public void removeSourceEdge(Edge sourceEdge) {
        this.sourceEdges.remove(sourceEdge);
    }

    public void removeTargetEdge(Edge targetEdge) {
        this.targetEdges.remove(targetEdge);
    }

    public int getTraceLogIndex() {
        return this.traceLogIndex;
    }
}

