/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.model;

import com.ca.intertest.tools.BacktraceLogMessage;
import com.ca.visualdebugger.plugin.controller.GraphController;
import com.ca.visualdebugger.plugin.model.GraphSession;
import com.ca.visualdebugger.plugin.model.ParagraphNode;
import com.ca.visualdebugger.plugin.model.ProgramNode;
import com.ca.visualdebugger.plugin.parser.CobolVerb;
import java.util.List;
import java.util.Map;

public class ModelBuilder {
    private Map<Integer, CobolVerb> statementList;
    private boolean deltaBuild = false;

    public boolean isDeltaBuild() {
        return this.deltaBuild;
    }

    private BacktraceLogMessage.TraceLogRecord createTraceLogRecord(String line) {
        String[] entryTokens = line.trim().split("[ ]+", 3);
        if (entryTokens.length > 0 && entryTokens[0].isEmpty()) {
            return null;
        }
        BacktraceLogMessage dummyLog = new BacktraceLogMessage();
        BacktraceLogMessage.TraceLogRecord traceLogRecord = new BacktraceLogMessage.TraceLogRecord(dummyLog);
        traceLogRecord.program = entryTokens[0];
        try {
            if (entryTokens.length > 1) {
                traceLogRecord.firstStatement = Integer.parseInt(entryTokens[1]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            traceLogRecord.firstStatement = -1;
        }
        if (entryTokens.length == 3) {
            traceLogRecord.text = entryTokens[2];
        }
        return traceLogRecord;
    }

    public GraphSession build(GraphSession model, List<?> trace, boolean isDeltaBuild) {
        GraphSession workModel = new GraphSession();
        List<BacktraceLogMessage.TraceLogRecord> compareTrace = GraphController.getInstance().getTraceLog();
        int stmtNumber = 0;
        int currentStmtNumber = 0;
        int historyIndex = -1;
        int compareIndex = 0;
        String fromProgram = null;
        String fromParagraph = null;
        ProgramNode programNode = null;
        if (model == null || model.getNodes().isEmpty()) {
            isDeltaBuild = false;
        }
        for (Object objectLog : trace) {
            BacktraceLogMessage.TraceLogRecord entry = null;
            entry = objectLog instanceof String ? this.createTraceLogRecord((String)objectLog) : (BacktraceLogMessage.TraceLogRecord)objectLog;
            if (isDeltaBuild && compareIndex <= compareTrace.size()) {
                if (compareIndex == compareTrace.size()) {
                    workModel = model;
                } else {
                    BacktraceLogMessage.TraceLogRecord compareEntry = compareTrace.get(compareIndex);
                    if (!entry.program.equals(compareEntry.program) || entry.firstStatement != compareEntry.firstStatement) {
                        isDeltaBuild = false;
                    }
                }
            }
            ++compareIndex;
            ++historyIndex;
            String pgmName = entry.program;
            if (pgmName == null || pgmName.isEmpty()) continue;
            programNode = workModel.addProgramNode(pgmName, historyIndex);
            this.statementList = programNode.getStatementList();
            stmtNumber = entry.firstStatement;
            if (!this.statementList.containsKey(stmtNumber)) continue;
            CobolVerb stmt = this.statementList.get(stmtNumber);
            String paragraph = stmt.getParagraph().getName();
            currentStmtNumber = stmtNumber;
            workModel.addParagraph(paragraph, pgmName, stmt.getParagraph(), historyIndex);
            if (fromProgram == null) {
                fromProgram = pgmName;
            } else if (!fromProgram.equals(pgmName)) {
                workModel.addEdge(fromProgram, pgmName, historyIndex);
                this.updateProgramLevel(workModel, fromProgram, pgmName, fromParagraph, paragraph, historyIndex);
                fromProgram = pgmName;
                fromParagraph = paragraph;
            }
            if (fromParagraph == null) {
                fromParagraph = paragraph;
                continue;
            }
            if (fromParagraph.equals(paragraph)) continue;
            programNode.addEdge(fromParagraph, paragraph, historyIndex);
            fromParagraph = paragraph;
        }
        if (!isDeltaBuild || compareIndex < compareTrace.size()) {
            model = workModel;
            this.deltaBuild = false;
        } else {
            this.deltaBuild = true;
        }
        ParagraphNode paragraphNode = programNode.findParagraphNodeByStmnt(currentStmtNumber);
        model.setCurrentParagraph(paragraphNode);
        GraphController.getInstance().setHistoryTraceLogIndex(historyIndex);
        GraphController.getInstance().updateNewIndex(historyIndex);
        GraphController.getInstance().getViewer().handleNoteDebug();
        return model;
    }

    private void updateProgramLevel(GraphSession model, String fromProgram, String toProgram, String fromParagraph, String toParagraph, int index) {
        ProgramNode fromProgramNode = model.getProgramNode(fromProgram);
        ProgramNode toProgramNode = model.getProgramNode(toProgram);
        fromProgramNode.addExternalProgramNode(toProgramNode, index);
        toProgramNode.addExternalProgramNode(fromProgramNode, index);
        fromProgramNode.addEdge(fromParagraph, toProgram, index);
        toProgramNode.addEdge(fromProgram, toParagraph, index);
    }
}

