/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.model;

import com.ca.visualdebugger.plugin.model.Edge;
import com.ca.visualdebugger.plugin.model.Node;
import com.ca.visualdebugger.plugin.model.ParagraphNode;
import com.ca.visualdebugger.plugin.model.ProgramNode;
import com.ca.visualdebugger.plugin.parser.CobolLabel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphSession {
    private Map<String, ProgramNode> programMap = new HashMap<String, ProgramNode>();
    private ParagraphNode currentParagraph;

    public ProgramNode addProgramNode(String programName, int traceLogIndex) {
        ProgramNode programNode = this.programMap.get(programName);
        if (programNode != null) {
            return programNode;
        }
        programNode = new ProgramNode(programName, traceLogIndex);
        if (this.programMap.isEmpty()) {
            programNode.setFirstNode(true);
        }
        this.programMap.put(programName, programNode);
        return programNode;
    }

    public Edge addEdge(String fromProgramName, String toProgramName, int index) {
        ProgramNode programFrom = this.programMap.get(fromProgramName);
        ProgramNode programTo = this.programMap.get(toProgramName);
        Edge edge = programFrom.findSourceEdge(toProgramName);
        if (edge == null) {
            edge = new Edge(programFrom, programTo, index);
        } else {
            edge.addTraceLogIndex(index);
        }
        return edge;
    }

    public ProgramNode addParagraph(String paragraphName, String programName, CobolLabel paragraphLabel, int index) {
        ProgramNode program = this.programMap.get(programName);
        if (program == null) {
            return null;
        }
        program.addParagraphNode(paragraphName, paragraphLabel, index);
        return program;
    }

    public List<Node> getNodes() {
        return new ArrayList<Node>(this.programMap.values());
    }

    public ParagraphNode getCurrentParagraph() {
        return this.currentParagraph;
    }

    public ProgramNode getCurrentProgram() {
        if (this.currentParagraph == null) {
            return null;
        }
        if (this.currentParagraph.getParagraphLabel() == null) {
            return null;
        }
        return this.programMap.get(this.currentParagraph.getParagraphLabel().getProgramName());
    }

    public void setCurrentParagraph(ParagraphNode currentParagraph) {
        this.currentParagraph = currentParagraph;
    }

    public ProgramNode getProgramNode(String programName) {
        return this.programMap.get(programName);
    }
}

