/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.model;

import com.ca.intertest.tools.Statement;
import com.ca.visualdebugger.plugin.controller.GraphController;
import com.ca.visualdebugger.plugin.model.IGraphEntity;
import com.ca.visualdebugger.plugin.model.Node;
import com.ca.visualdebugger.plugin.model.ParagraphNode;
import com.ca.visualdebugger.plugin.model.ProgramNode;
import com.ca.visualdebugger.plugin.parser.CobolListingReader;
import com.ca.visualdebugger.plugin.parser.CobolMetadataReader;
import com.ca.visualdebugger.plugin.parser.CobolVerb;
import java.util.ArrayList;
import java.util.List;

public class Edge
implements IGraphEntity {
    private Integer callCount;
    private Node fromNode;
    private Node toNode;
    private List<Integer> traceLogIndexes;

    public Edge(Node fromNode, Node toNode, int index) {
        this.setSource(fromNode);
        this.setTarget(toNode);
        this.callCount = 1;
        this.traceLogIndexes = new ArrayList<Integer>();
        this.traceLogIndexes.add(index);
    }

    public void increaseCount() {
        this.callCount = this.callCount + 1;
    }

    public void addTraceLogIndex(int index) {
        this.traceLogIndexes.add(index);
    }

    public int getNumberOfTransfers(int traceLogIndex) {
        int numberOfTransfers = 0;
        for (Integer index : this.traceLogIndexes) {
            if (index > traceLogIndex) continue;
            ++numberOfTransfers;
        }
        return numberOfTransfers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Edge) {
            Edge edge = (Edge)obj;
            return this.fromNode.equals(edge.getFromNode()) && this.toNode.equals(edge.getToNode());
        }
        return false;
    }

    public Node getFromNode() {
        return this.fromNode;
    }

    public Node getToNode() {
        return this.toNode;
    }

    public int hashCode() {
        return 37 * this.fromNode.hashCode() + this.toNode.hashCode();
    }

    public String toString() {
        return this.getFromNode() + "->" + this.getToNode();
    }

    public void setSource(Node newSource) {
        if (this.fromNode != null) {
            this.fromNode.removeSourceEdge(this);
        }
        this.fromNode = newSource;
        if (this.fromNode != null) {
            this.fromNode.addSourceEdge(this);
        }
    }

    public void setTarget(Node newTarget) {
        if (this.toNode != null) {
            this.toNode.removeTargetEdge(this);
        }
        this.toNode = newTarget;
        if (this.toNode != null) {
            this.toNode.addTargetEdge(this);
        }
    }

    public String getHistoryLabel() {
        if (this.traceLogIndexes.isEmpty()) {
            return "";
        }
        int currentHistoryIndex = GraphController.getInstance().getHistoryTraceLogIndex();
        if (currentHistoryIndex >= this.traceLogIndexes.get(this.traceLogIndexes.size() - 1)) {
            return Integer.toString(this.traceLogIndexes.size());
        }
        Integer numberOfTransfers = 0;
        for (Integer index : this.traceLogIndexes) {
            if (index > currentHistoryIndex) continue;
            numberOfTransfers = numberOfTransfers + 1;
        }
        if (numberOfTransfers == 0) {
            return "";
        }
        return numberOfTransfers.toString();
    }

    @Override
    public String getLabel() {
        if (this.traceLogIndexes.isEmpty()) {
            return "";
        }
        return Integer.toString(this.traceLogIndexes.size());
    }

    public Integer getTracelogIndex(int fromLast) {
        return this.traceLogIndexes.get(this.traceLogIndexes.size() + fromLast - 1);
    }

    public List<Integer> getTraceLogIndexes() {
        return this.traceLogIndexes;
    }

    public String getProgramNameSourceNode() {
        String programName = null;
        if (this.fromNode instanceof ProgramNode) {
            programName = this.fromNode.getLabel();
        }
        if (this.fromNode instanceof ParagraphNode) {
            programName = ((ParagraphNode)this.fromNode).getParagraphLabel().getProgramName();
        }
        return programName;
    }

    public String getLineByStatementNumber(int statementNumber, String name) {
        CobolMetadataReader cobolReader = CobolMetadataReader.getMetadataReaderFor(GraphController.getInstance().getdebugFile(name));
        CobolListingReader cobolListingReader = CobolListingReader.getListingReaderFor(GraphController.getInstance().getdebugFile(name));
        try {
            CobolVerb cobolVerb = cobolReader.getVerbByStatementNumber(statementNumber);
            Statement statement = cobolVerb.getStatement();
            int lineNumber = statement.getLine();
            return cobolListingReader.getSourceLine(lineNumber);
        }
        catch (Exception exception) {
            System.out.println("ERROR: VisualDebugger: Trace data is out of sync with the listings");
            return "";
        }
    }
}

