/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.graph.provider;

import com.ca.visualdebugger.plugin.Colors;
import com.ca.visualdebugger.plugin.Constants;
import com.ca.visualdebugger.plugin.Utils;
import com.ca.visualdebugger.plugin.controller.GraphController;
import com.ca.visualdebugger.plugin.graph.provider.GraphLabelProvider;
import com.ca.visualdebugger.plugin.graph.visual.GraphConnectionLabel;
import com.ca.visualdebugger.plugin.model.Edge;
import com.ca.visualdebugger.plugin.model.GraphSession;
import com.ca.visualdebugger.plugin.model.Node;
import com.ca.visualdebugger.plugin.model.ParagraphNode;
import com.ca.visualdebugger.plugin.model.ProgramNode;
import com.ca.visualdebugger.plugin.views.GraphicalView;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.IEntityConnectionStyleProvider;
import org.eclipse.zest.core.viewers.ISelfStyleProvider;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphNode;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class StyledLabelProvider
extends GraphLabelProvider
implements IEntityConnectionStyleProvider,
ISelfStyleProvider {
    public static final Integer NODE_BORDER_WIDTH = 1;
    public static final Integer NODE_BORDER_WIDTH_ENHANCED = 2;
    public static final Integer NODE_BORDER_WIDTH_HIGHLIGHTED = 3;
    public static final Integer PROGRAM_NODE_WIDTH = 104;
    public static final Integer PROGRAM_NODE_HEIGHT = 34;
    private GraphicalView graphicalView = GraphController.getInstance().getViewer();
    private boolean connectionLabelClicked;
    private List<GraphConnectionLabel> connectionLabelList = new ArrayList<GraphConnectionLabel>();
    private List<GraphConnection> connectionList = new ArrayList<GraphConnection>();
    private Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
    private URL imageUrl = FileLocator.find((Bundle)this.bundle, (IPath)new Path("icons/start_flag.png"), null);
    private Image firstNodeBackground = ImageDescriptor.createFromURL((URL)this.imageUrl).createImage();

    @Override
    public String getText(Object element) {
        String label = super.getText(element);
        if (element instanceof Node && label != null) {
            return label;
        }
        if (element instanceof EntityConnectionData) {
            return "";
        }
        throw new RuntimeException("Type not supported " + element.getClass().toString());
    }

    public int getConnectionStyle(Object arg0, Object arg1) {
        return 2;
    }

    public Color getColor(Object src, Object dest) {
        return Display.getCurrent().getSystemColor(16);
    }

    public Color getHighlightColor(Object src, Object dest) {
        return Display.getCurrent().getSystemColor(16);
    }

    public int getLineWidth(Object src, Object dest) {
        return -1;
    }

    public IFigure getTooltip(Object entity) {
        return null;
    }

    public void selfStyleConnection(Object element, GraphConnection connection) {
        Label tooltip = new Label("Right click for last transfers");
        connection.setTooltip((IFigure)tooltip);
        if (element instanceof EntityConnectionData) {
            EntityConnectionData ecd = (EntityConnectionData)element;
            Node src = (Node)ecd.source;
            Node dst = (Node)ecd.dest;
            for (Edge edge : src.getSourceEdges()) {
                if (!edge.getToNode().equals(dst)) continue;
                String historyLabel = edge.getHistoryLabel();
                if (historyLabel == null || historyLabel.isEmpty()) {
                    connection.setVisible(false);
                    return;
                }
                GraphConnectionLabel label = new GraphConnectionLabel(historyLabel);
                connection.getConnectionFigure().add((IFigure)label, (Object)new ConnectionLocator(connection.getConnectionFigure()));
                connection.getConnectionFigure().addMouseListener(this.createConnLabelMouseListener(label, connection, ecd));
                connection.getConnectionFigure().addMouseMotionListener(this.createConnLabelMouseMotionListener(label));
                label.addMouseMotionListener(this.createConnLabelMouseMotionListener(label));
                label.addMouseListener(this.createConnLabelMouseListener(label, connection, ecd));
                connection.setHighlightColor(Colors.NODE_BORDER_HIGHLIGHTED);
                this.connectionLabelList.add(label);
                this.connectionList.add(connection);
            }
        }
    }

    public void selfStyleNode(Object element, GraphNode node) {
        Label tooltip;
        if (((Node)element).getHistoryLabel().isEmpty()) {
            node.setVisible(false);
            return;
        }
        if (((Node)element).isFirstNode()) {
            node.setImage(this.firstNodeBackground);
        }
        node.setBackgroundColor(Colors.NODE_BACKGROUND);
        node.setBorderColor(Colors.NODE_BORDER);
        node.setBorderWidth(NODE_BORDER_WIDTH.intValue());
        node.setForegroundColor(Colors.NODE_LABEL);
        node.setBorderHighlightColor(Colors.NODE_BORDER_HIGHLIGHTED);
        node.setHighlightColor(Colors.NODE_BACKGROUND_SELECTED);
        node.setFont(Constants.NODE_FONT);
        node.setNodeStyle(0);
        GraphSession model = GraphController.getInstance().getCurrentSession();
        if (element instanceof ParagraphNode) {
            tooltip = ((Node)element).isFirstNode() ? new Label("Entry point\n" + node.getText()) : new Label(node.getText());
            node.setTooltip((IFigure)tooltip);
            if (node.getText().length() > 25) {
                node.setText(String.valueOf(node.getText().substring(0, 24)) + "...");
            }
        }
        if (element instanceof ParagraphNode && model.getCurrentParagraph() != null) {
            ParagraphNode paragraphNode = (ParagraphNode)element;
            if (model.getCurrentParagraph().equals(paragraphNode)) {
                node.setBorderColor(Colors.NODE_BORDER_HIGHLIGHTED);
                node.setBorderWidth(NODE_BORDER_WIDTH_HIGHLIGHTED.intValue());
            }
            return;
        }
        if (element instanceof ProgramNode) {
            tooltip = ((Node)element).isFirstNode() ? new Label("Entry point\n" + node.getText() + "\n" + "Double click to see the paragraphs") : new Label(String.valueOf(node.getText()) + "\n" + "Double click to see the paragraphs");
            if (node.getText().length() > 8) {
                node.setText(String.valueOf(node.getText().substring(0, 7)) + "...");
            }
            node.setTooltip((IFigure)tooltip);
            node.setSize((double)PROGRAM_NODE_WIDTH.intValue(), (double)PROGRAM_NODE_HEIGHT.intValue());
            if (this.graphicalView.isProgramLevel()) {
                node.setBackgroundColor(Colors.NODE_BACKGROUND_EXTERNAL_PROGRAM);
                node.setSize((double)PROGRAM_NODE_WIDTH.intValue(), (double)PROGRAM_NODE_HEIGHT.intValue());
                node.setBorderWidth(NODE_BORDER_WIDTH_HIGHLIGHTED.intValue());
                node.setBorderHighlightColor(Colors.NODE_BORDER);
            }
            if (model.getCurrentProgram() != null) {
                ProgramNode programNode = (ProgramNode)element;
                if (model.getCurrentProgram().equals(programNode)) {
                    node.setBorderColor(Colors.NODE_BORDER_HIGHLIGHTED);
                    node.setBorderWidth(NODE_BORDER_WIDTH_HIGHLIGHTED.intValue());
                }
            }
            return;
        }
    }

    private MouseMotionListener createConnLabelMouseMotionListener(final GraphConnectionLabel label) {
        return new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                StyledLabelProvider.this.graphicalView.getGraphViewer().getGraphControl().removeMouseMoveListener(StyledLabelProvider.this.graphicalView.getMouseMoveListener());
                Utils.changeCursor((EventObject)me, 21);
                label.setBackgroundColor(Colors.CONNECTION_HOVER_COLOR);
            }

            public void mouseExited(MouseEvent me) {
                Utils.changeCursor((EventObject)me, 0);
                if (label.isSelected()) {
                    label.setBackgroundColor(Colors.CONNECTION_SELECTED_COLOR);
                } else {
                    label.setBackgroundColor(Colors.CONNECTION_DEFAULT_COLOR);
                }
                StyledLabelProvider.this.graphicalView.checkAndAddMouseMoveListener();
                StyledLabelProvider.this.setConnectionLabelClicked(false);
            }

            public void mouseHover(MouseEvent me) {
            }

            public void mouseMoved(MouseEvent me) {
            }
        };
    }

    private MouseListener createConnLabelMouseListener(final GraphConnectionLabel label, final GraphConnection connection, final EntityConnectionData ecd) {
        return new MouseListener(){

            public void mousePressed(MouseEvent me) {
                StyledLabelProvider.this.setConnectionLabelClicked(true);
                StyledLabelProvider.this.deselectAllConnections();
                StyledLabelProvider.this.graphicalView.setSelection(ecd);
                StyledLabelProvider.this.graphicalView.getGraphViewer().getGraphControl().notifyListeners(13, new Event());
                label.setLineWidth(NODE_BORDER_WIDTH_ENHANCED);
                label.setBackgroundColor(Colors.CONNECTION_SELECTED_COLOR);
                label.setSelected(true);
                connection.setLineWidth(NODE_BORDER_WIDTH_HIGHLIGHTED.intValue());
                connection.setLineColor(Colors.NODE_BORDER_HIGHLIGHTED);
                connection.unhighlight();
            }

            public void mouseReleased(MouseEvent me) {
            }

            public void mouseDoubleClicked(MouseEvent me) {
            }
        };
    }

    public boolean isConnectionLabelClicked() {
        return this.connectionLabelClicked;
    }

    public void setConnectionLabelClicked(boolean connectionLabelClicked) {
        this.connectionLabelClicked = connectionLabelClicked;
    }

    public void deselectAllConnections() {
        for (GraphConnection conn : this.connectionList) {
            conn.setLineWidth(NODE_BORDER_WIDTH.intValue());
            conn.setLineColor(Colors.NODE_BORDER);
        }
        for (GraphConnectionLabel lbl : this.connectionLabelList) {
            if (!lbl.isSelected()) continue;
            lbl.setSelected(false);
            lbl.setBackgroundColor(Colors.CONNECTION_DEFAULT_COLOR);
            lbl.setLineWidth(NODE_BORDER_WIDTH);
            break;
        }
    }
}

