/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.dev;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;

public class TraceDataProvider {
    private static TraceDataProvider instance;
    private static File sessionDir;

    public static TraceDataProvider getInstance() {
        if (instance == null) {
            instance = new TraceDataProvider();
        }
        sessionDir = null;
        return instance;
    }

    public File getTraceFile() {
        return this.getMatchingFiles("", "trace", null)[0];
    }

    public File getMetadata(String name, String pathToListing) {
        File[] matchingFiles = this.getMatchingFiles(name, "intertest", pathToListing);
        if (matchingFiles.length == 0) {
            return null;
        }
        return matchingFiles[0];
    }

    private File getSessionDir(String path) {
        if (sessionDir == null) {
            sessionDir = this.openSessionDir(path);
        }
        return sessionDir;
    }

    private File openSessionDir(String path) {
        if (path == null || path.isEmpty()) {
            DirectoryDialog dlg = new DirectoryDialog(Display.getCurrent().getActiveShell(), 4096);
            String pathToFolder = dlg.open();
            return new File(pathToFolder);
        }
        return new File(path);
    }

    private File[] getMatchingFiles(final String fName, final String ext, String path) {
        File[] list = this.getSessionDir(path).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!fName.isEmpty() && !ext.isEmpty()) {
                    return name.startsWith(fName) && name.endsWith(ext);
                }
                if (!fName.isEmpty()) {
                    return name.startsWith(fName);
                }
                if (!ext.isEmpty()) {
                    return name.endsWith(ext);
                }
                return false;
            }
        });
        return list;
    }
}

