/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.controller;

import com.ca.intertest.debug.IDebugListener;
import com.ca.intertest.debug.debugEvent;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.CVMI;
import com.ca.intertest.tools.CVMO;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.visualdebugger.plugin.controller.ContextSession;
import com.ca.visualdebugger.plugin.controller.GraphController;
import java.util.HashSet;
import java.util.Set;

public class DebugSessionEventListener
implements IDebugListener {
    private debugSession session;
    private GraphController controller;
    private static Set<debugSession> listeningSessions = new HashSet<debugSession>();

    public static void register(debugSession session, GraphController controller) {
        if (listeningSessions.add(session)) {
            session.addDebugListener((IDebugListener)new DebugSessionEventListener(session, controller));
            controller.addSessionToMap(session, new ContextSession(session, null, 0));
        }
    }

    private DebugSessionEventListener(debugSession session, GraphController controller) {
        this.session = session;
        this.controller = controller;
    }

    public void debugEventOccured(debugEvent event) {
        DebugMessage message;
        int n;
        int n2;
        DebugMessage[] debugMessageArray;
        Object object = event.getSource();
        if (object instanceof CVMO) {
            CVMO cvmo = (CVMO)object;
            debugMessageArray = cvmo.getMessages();
            n2 = debugMessageArray.length;
            n = 0;
            while (n < n2) {
                message = debugMessageArray[n];
                switch (message.getMessageID()) {
                    case 4: {
                        return;
                    }
                    case 1: {
                        int type = this.session.getTalker().getBreakType();
                        switch (type) {
                            case 10: {
                                this.controller.resetCurrentSession();
                                break;
                            }
                            case 11: {
                                break;
                            }
                            default: {
                                if (this.session.isFinished()) {
                                    this.controller.resetCurrentSession();
                                    if (this.controller.getViewer() != null) {
                                        this.controller.clearGraphView();
                                    }
                                    this.session.setFinished(false);
                                }
                                this.controller.debugEventOccured(this.session);
                            }
                        }
                        return;
                    }
                }
                ++n;
            }
        }
        if (object instanceof CVMI) {
            CVMI cvmi = (CVMI)object;
            debugMessageArray = cvmi.getMessages();
            n2 = debugMessageArray.length;
            n = 0;
            while (n < n2) {
                message = debugMessageArray[n];
                switch (message.getMessageID()) {
                    case 26: {
                        if (this.controller.getDebugSession() != null && this.controller.getViewer() != null) {
                            this.controller.getViewer().switchToTransactionLevel(false);
                            this.controller.clearGraphView();
                        }
                        this.controller.removeFromMap(this.session);
                        break;
                    }
                    case 17: {
                        this.session.setFinished(true);
                        break;
                    }
                    case 10: {
                        if (this.session.isFinished()) {
                            this.controller.resetCurrentSession();
                            this.controller.clearGraphView();
                            this.session.setFinished(false);
                        }
                        this.controller.debugEventOccured(this.session);
                        break;
                    }
                    case 22: {
                        this.session.getTracelog().clear();
                        this.session.setFinished(false);
                        return;
                    }
                }
                ++n;
            }
        }
        if (object instanceof ListerEditor && this.controller.getViewer() != null) {
            ListerEditor editor = (ListerEditor)object;
            if (editor.getLang() != 32) {
                return;
            }
            int lineNum = editor.getCurrentLineNum();
            if (this.controller.isSyncToggleOn()) {
                this.controller.selectNodeBasedOnListing(editor.getFileName(), lineNum);
                this.controller.getViewer().updateEventstate(false);
            }
            this.controller.showCurrentSession(editor.getResource().getProject().getName());
        }
    }
}

