/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.controller;

import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.visualdebugger.plugin.controller.GraphController;
import com.ca.visualdebugger.plugin.model.Edge;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class AnnotationController {
    public static final String EDGE_ANNOTATION_TYPE = "com.ca.visualdebugger.lister.edge";
    private static final String EDGE_ANNOTATION_MESSAGE = "Transfer of control: from {0} to {1}";
    private static HashMap<String, AnnotationController> instances = new HashMap();
    private String programName;
    private String debugSessionName;
    private List<Annotation> annotations = new LinkedList<Annotation>();
    private ListerEditor editor;

    public static AnnotationController getInstance(String programName) {
        AnnotationController instance = instances.get(programName);
        if (instance == null) {
            instance = new AnnotationController(programName);
            instances.put(programName, instance);
        }
        return instance;
    }

    public static void removeAllAnnotations() {
        for (AnnotationController annotationController : instances.values()) {
            annotationController.removeAnnotations();
        }
    }

    public void addEdgeAnnotation(Edge edge, Position position) {
        String annotationText = MessageFormat.format(EDGE_ANNOTATION_MESSAGE, edge.getFromNode().getLabel(), edge.getToNode().getLabel());
        this.addAnnotation(EDGE_ANNOTATION_TYPE, annotationText, position);
    }

    private void addAnnotation(String annotationType, String annotationText, Position position) {
        Annotation annotation = new Annotation(annotationType, false, annotationText);
        this.annotations.add(annotation);
        IAnnotationModel aModel = this.getAnnotationModel();
        if (aModel != null) {
            aModel.addAnnotation(annotation, position);
        }
    }

    public void removeAnnotations() {
        for (Annotation annotation : this.annotations) {
            IAnnotationModel aModel = this.getAnnotationModel();
            if (aModel == null) continue;
            aModel.removeAnnotation(annotation);
        }
        this.annotations.clear();
    }

    private AnnotationController(String programName) {
        this.programName = programName;
        this.debugSessionName = GraphController.getInstance().getDebugSession().getName();
    }

    private ListerEditor getEditor() {
        this.editor = null;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                debugFile file;
                debugSession session = GraphController.getInstance().getDebugSession(AnnotationController.this.debugSessionName);
                if (session != null && (file = session.getFile(AnnotationController.this.programName)) != null) {
                    AnnotationController.this.editor = (ListerEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart().getSite().getPage().findEditor((IEditorInput)new FileEditorInput((IFile)file.getResource()));
                }
            }
        });
        return this.editor;
    }

    private IAnnotationModel getAnnotationModel() {
        ListerEditor localEditor = this.getEditor();
        if (localEditor != null) {
            return localEditor.getDocumentProvider().getAnnotationModel((Object)this.getEditor().getEditorInput());
        }
        return null;
    }
}

