/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.views;

import com.ca.visualdebugger.plugin.Colors;
import com.ca.visualdebugger.plugin.Utils;
import com.ca.visualdebugger.plugin.controller.AnnotationController;
import com.ca.visualdebugger.plugin.controller.GraphController;
import com.ca.visualdebugger.plugin.graph.provider.GraphNodeContentProvider;
import com.ca.visualdebugger.plugin.graph.provider.StyledLabelProvider;
import com.ca.visualdebugger.plugin.model.Edge;
import com.ca.visualdebugger.plugin.model.Node;
import com.ca.visualdebugger.plugin.model.ParagraphNode;
import com.ca.visualdebugger.plugin.model.ProgramNode;
import com.ca.visualdebugger.plugin.views.BlueBarButton;
import com.ca.visualdebugger.plugin.views.WindowsFontSizeRelatives;
import java.awt.AWTException;
import java.awt.Robot;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.zest.core.viewers.AbstractZoomableViewer;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.GraphViewer;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.viewers.internal.ZoomManager;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.progress.ProgressEvent;
import org.eclipse.zest.layouts.progress.ProgressListener;

public class GraphicalView
extends ViewPart
implements PropertyChangeListener,
IZoomableWorkbenchPart {
    private static GraphController graphController;
    public static final String ID = "com.ca.visualdebugger.plugin.views.TraceGraphicalView";
    public static final Color BLUE_BAR_BACKGROUND;
    public static final Color BLUE_BAR_BUTTON_HOVER;
    public static final Color BLUE_BAR_BUTTON_SELECTED;
    private static final String BLUE_BAR_SLASH = "/";
    public static final Color STATUS_BAR_BACKGROUND;
    public static final Color COLOR_WHITE;
    private static final int REV_KEY_CODE = 0x100000B;
    private static final int F2_KEY_CODE = 113;
    private Composite compBlueBar;
    private Composite compProgramLevelPart;
    private BlueBarButton buttonTransaction;
    private BlueBarButton buttonProgram;
    private GraphViewer graphViewer;
    private Composite compTransaction;
    private CLabel lblTransaction;
    private ISelection previousGraphSelection;
    private GraphItem previousGraphItem;
    private String previousGraphItemName;
    private ArrayList<String> previousGraphItemsNames = new ArrayList();
    private Button zoomOutButton;
    private ZoomManager zoomManager;
    private Scale zoomScale;
    private CLabel zoomLabel;
    private boolean zoomIn = false;
    private boolean alt = false;
    private Composite compStatusBar;
    private double[] zoomLevels = new double[]{0.2, 0.5, 0.75, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0};
    private boolean eventFiredFromSelectionChanged = false;
    private Slider historySlider;
    private Label lblCurrentHistory;
    private boolean isFocusFromOtherProgram;
    private SpringLayoutAlgorithm defaultLayoutAlgorithm;
    private MouseMoveListener mouseMoveListener;
    private StyledLabelProvider styledLabelProvider;
    private FormData fd_lblCurrentHistory;
    private String programNameForSelectedEdge;
    private boolean cursorChanged;
    private Edge selectedEdge;
    private Text noteStartDebug;
    private Menu menu;
    private List<String> programNameSelectedList = new ArrayList<String>();
    private int previousProgramIndex = -1;
    private static final int MAX_LENGTH_OF_STORED_PRG_NAMES = 32;
    private boolean bottomListItem = true;
    private boolean lastListItem = true;
    private int maxHistorySliderIndex;
    private WindowsFontSizeRelatives windowsFontSizeRelatives = new WindowsFontSizeRelatives();

    static {
        BLUE_BAR_BACKGROUND = ColorDescriptor.createFrom((RGB)new RGB(214, 231, 247)).createColor((Device)PlatformUI.getWorkbench().getDisplay());
        BLUE_BAR_BUTTON_HOVER = ColorDescriptor.createFrom((RGB)new RGB(155, 214, 250)).createColor((Device)PlatformUI.getWorkbench().getDisplay());
        BLUE_BAR_BUTTON_SELECTED = ColorDescriptor.createFrom((RGB)new RGB(165, 208, 236)).createColor((Device)PlatformUI.getWorkbench().getDisplay());
        STATUS_BAR_BACKGROUND = ColorDescriptor.createFrom((RGB)new RGB(239, 239, 239)).createColor((Device)PlatformUI.getWorkbench().getDisplay());
        COLOR_WHITE = ColorDescriptor.createFrom((RGB)new RGB(255, 255, 255)).createColor((Device)PlatformUI.getWorkbench().getDisplay());
    }

    public GraphicalView() {
        if (graphController == null) {
            graphController = GraphController.getInstance();
        }
        graphController.setView(this);
        graphController.addPropertyChangeListener(this);
    }

    public final void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FormLayout());
        container.setBackground(STATUS_BAR_BACKGROUND);
        this.displayStartDebug(container);
        this.compProgramLevelPart = null;
        this.compBlueBar = new Composite(container, 0);
        this.compBlueBar.setBackground(BLUE_BAR_BACKGROUND);
        FormData fd_compBlueBar = new FormData();
        fd_compBlueBar.top = new FormAttachment(0);
        fd_compBlueBar.right = new FormAttachment(100);
        fd_compBlueBar.bottom = new FormAttachment(0, this.windowsFontSizeRelatives.getRelativecompBlueBarBottom());
        fd_compBlueBar.left = new FormAttachment(0);
        this.compBlueBar.setLayoutData((Object)fd_compBlueBar);
        this.compBlueBar.setLayout((Layout)new FormLayout());
        this.compTransaction = new Composite(this.compBlueBar, 2048);
        this.compTransaction.setBackground(BLUE_BAR_BACKGROUND);
        Font font = new Font(null, new FontData("Arial", 10, 0));
        FormData fd_Transaction = new FormData();
        fd_Transaction.top = new FormAttachment(10, 0);
        fd_Transaction.left = new FormAttachment(1, 0);
        fd_Transaction.bottom = new FormAttachment(90, 0);
        this.compTransaction.setLayoutData((Object)fd_Transaction);
        this.compTransaction.setLayout((Layout)new FormLayout());
        this.lblTransaction = new CLabel(this.compTransaction, 32);
        this.lblTransaction.setFont(font);
        this.lblTransaction.setBackground(BLUE_BAR_BACKGROUND);
        if (!graphController.isDebugStarted().booleanValue()) {
            this.lblTransaction.setText("Transaction");
            this.compTransaction.setVisible(false);
        } else {
            this.lblTransaction.setText(graphController.getSessionTransactionName());
        }
        FormData fd_lblTransaction = new FormData();
        fd_lblTransaction.left = new FormAttachment(0);
        fd_lblTransaction.bottom = new FormAttachment(100, 1);
        this.lblTransaction.setLeftMargin(10);
        this.lblTransaction.setRightMargin(10);
        this.lblTransaction.setLayoutData((Object)fd_lblTransaction);
        this.buttonTransaction = new BlueBarButton(this.compTransaction, this.lblTransaction, 0);
        this.buttonTransaction.addPropertyChangeListener(this);
        this.buttonTransaction.setSelectedState();
        this.graphViewer = new GraphViewer(container, 2048);
        Control graphControl = this.graphViewer.getControl();
        FormData fd_graphControl = new FormData();
        fd_graphControl.top = new FormAttachment((Control)this.compBlueBar);
        fd_graphControl.bottom = new FormAttachment(100, -37);
        fd_graphControl.left = new FormAttachment((Control)this.compBlueBar, 0, 16384);
        fd_graphControl.right = new FormAttachment((Control)this.compBlueBar, 0, 131072);
        graphControl.setLayoutData((Object)fd_graphControl);
        this.styledLabelProvider = new StyledLabelProvider();
        this.graphViewer.setLabelProvider((IBaseLabelProvider)this.styledLabelProvider);
        this.graphViewer.setContentProvider((IContentProvider)new GraphNodeContentProvider());
        this.defaultLayoutAlgorithm = new SpringLayoutAlgorithm(1);
        this.defaultLayoutAlgorithm.addProgressListener(this.createLayoutProgressListener());
        this.defaultLayoutAlgorithm.setRandom(false);
        this.graphViewer.setLayoutAlgorithm((LayoutAlgorithm)this.defaultLayoutAlgorithm, true);
        this.graphViewer.applyLayout();
        this.graphViewer.getGraphControl().addKeyListener(this.addKeyListener());
        this.graphViewer.getGraphControl().addMouseListener((MouseListener)this.getMouseAdapter());
        this.graphViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.graphViewer.getGraphControl().addDragDetectListener(this.getDragDetectListener());
        this.mouseMoveListener = this.createMouseMoveListener();
        this.graphViewer.getGraphControl().addMouseMoveListener(this.mouseMoveListener);
        this.graphViewer.getGraphControl().addFocusListener(this.addFocusListener());
        this.compStatusBar = new Composite(container, 0);
        FormData fd_compStatusBar = new FormData();
        fd_compStatusBar.height = 200;
        fd_compStatusBar.top = new FormAttachment(this.graphViewer.getControl(), 0, 1024);
        fd_compStatusBar.left = new FormAttachment(0);
        fd_compStatusBar.right = new FormAttachment(100);
        fd_compStatusBar.bottom = new FormAttachment(100);
        this.compStatusBar.setLayoutData((Object)fd_compStatusBar);
        this.addContextMenu();
        this.addZoomSlider();
        this.addHistorySlider();
        graphController.buildModelOnInitialization();
        this.noteStartDebug.setMenu(this.menu);
        this.activateContext();
    }

    private FocusListener addFocusListener() {
        FocusListener listener = new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                GraphicalView.this.alt = false;
                GraphicalView.this.zoomIn = false;
            }

            public void focusGained(FocusEvent arg0) {
            }
        };
        return listener;
    }

    private KeyListener addKeyListener() {
        KeyListener listener = new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 65536) {
                    GraphicalView.this.alt = true;
                    GraphicalView.this.zoomIn = true;
                }
                if (e.keyCode == 131072 && GraphicalView.this.alt) {
                    GraphicalView.this.zoomIn = false;
                }
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x100000B) {
                    GraphicalView.this.unhighlightSelection();
                }
                if (e.keyCode == 65536) {
                    GraphicalView.this.alt = false;
                    GraphicalView.this.zoomIn = false;
                }
                if (e.keyCode == 131072 && GraphicalView.this.alt) {
                    GraphicalView.this.zoomIn = true;
                }
            }
        };
        return listener;
    }

    private MouseAdapter getMouseAdapter() {
        MouseAdapter adapter = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (GraphicalView.this.previousGraphSelection != null && GraphicalView.this.previousGraphSelection != GraphicalView.this.graphViewer.getSelection() && GraphicalView.this.graphViewer.getGraphControl().getSelection().size() > 1) {
                    GraphicalView.this.graphViewer.setSelection(GraphicalView.this.previousGraphSelection);
                } else if (GraphicalView.this.graphViewer.getGraphControl().getSelection().isEmpty()) {
                    AnnotationController.removeAllAnnotations();
                    GraphicalView.this.previousGraphSelection = GraphicalView.this.graphViewer.getSelection();
                    GraphicalView.this.previousGraphItemName = " ";
                }
                if (GraphicalView.this.cursorChanged) {
                    Utils.changeCursor((EventObject)e, 0);
                    GraphicalView.this.cursorChanged = false;
                }
                if (!GraphicalView.this.styledLabelProvider.isConnectionLabelClicked()) {
                    GraphicalView.this.checkAndAddMouseMoveListener();
                }
            }

            public void mouseDown(MouseEvent e) {
                if (!GraphicalView.this.graphViewer.getSelection().isEmpty()) {
                    GraphicalView.this.previousGraphSelection = GraphicalView.this.graphViewer.getSelection();
                    int i = 0;
                    while (i < GraphicalView.this.graphViewer.getGraphControl().getSelection().size()) {
                        GraphicalView.this.previousGraphItem = (GraphItem)GraphicalView.this.graphViewer.getGraphControl().getSelection().get(i);
                        GraphicalView.this.previousGraphItemName = GraphicalView.this.previousGraphItem.getText();
                        GraphicalView.this.previousGraphItemsNames.add(GraphicalView.this.previousGraphItemName);
                        ++i;
                    }
                    GraphicalView.this.previousGraphItem = (GraphItem)GraphicalView.this.graphViewer.getGraphControl().getSelection().get(0);
                    GraphicalView.this.previousGraphItemName = GraphicalView.this.previousGraphItem.getText();
                }
                if (GraphicalView.this.alt) {
                    if (GraphicalView.this.zoomIn) {
                        GraphicalView.this.zoomManager.setZoomAsText(String.valueOf(GraphicalView.this.zoomManager.getZoom() * 100.0 + 1.0));
                        GraphicalView.this.zoomLabel.setText(GraphicalView.this.zoomManager.getZoomAsText());
                        GraphicalView.this.zoomScale.setSelection(Integer.valueOf(GraphicalView.this.zoomManager.getZoomAsText().split("%")[0]).intValue());
                    } else {
                        GraphicalView.this.zoomManager.setZoomAsText(String.valueOf(GraphicalView.this.zoomManager.getZoom() * 100.0 - 1.0));
                        GraphicalView.this.zoomLabel.setText(GraphicalView.this.zoomManager.getZoomAsText());
                        GraphicalView.this.zoomScale.setSelection(Integer.valueOf(GraphicalView.this.zoomManager.getZoomAsText().split("%")[0]).intValue());
                    }
                }
                GraphicalView.this.graphViewer.getGraphControl().removeMouseMoveListener(GraphicalView.this.mouseMoveListener);
            }

            public void mouseDoubleClick(MouseEvent e) {
                ISelection selection = GraphicalView.this.graphViewer.getSelection();
                if (selection != null && selection instanceof IStructuredSelection) {
                    IStructuredSelection strucSelection = (IStructuredSelection)selection;
                    if (strucSelection.size() > 1) {
                        return;
                    }
                    Object selectedElement = strucSelection.getFirstElement();
                    if (selectedElement instanceof ProgramNode) {
                        ProgramNode selectedNode = (ProgramNode)selectedElement;
                        GraphicalView.this.storeSelectedProgramName(selectedNode.getLabel());
                        GraphicalView.this.switchToProgramLevel(selectedNode.getLabel());
                    }
                }
            }
        };
        return adapter;
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GraphicalView.this.deselectAllConnections();
                ISelection selection = event.getSelection();
                if (selection != null && selection instanceof IStructuredSelection) {
                    IStructuredSelection strucSelection = (IStructuredSelection)selection;
                    if (strucSelection.size() > 1) {
                        return;
                    }
                    Object selectedElement = strucSelection.getFirstElement();
                    if (selectedElement == null) {
                        GraphicalView.this.removeAnnotationsAndActivateGraphView();
                        return;
                    }
                    if (selectedElement instanceof ProgramNode && graphController.isSyncToggleOn()) {
                        ProgramNode programNode = (ProgramNode)selectedElement;
                        graphController.setAnnotationInEditor(programNode.getLabel(), null);
                        graphController.positionEditorOnLine(programNode.getLabel(), programNode.getProgramLineInListing());
                    }
                    if (selectedElement instanceof ParagraphNode && graphController.isSyncToggleOn()) {
                        ParagraphNode paragraphNode = (ParagraphNode)selectedElement;
                        String programName = null;
                        if (GraphicalView.this.buttonProgram != null) {
                            programName = GraphicalView.this.buttonProgram.getName();
                        }
                        int stmntNum = 0;
                        if (paragraphNode.getParagraphLabel() == null) {
                            return;
                        }
                        stmntNum = paragraphNode.getParagraphLabel().getStatementNumber();
                        graphController.setAnnotationInEditor(programName, null);
                        graphController.positionEditorOnStmt(programName, stmntNum);
                    }
                    if (selectedElement instanceof EntityConnectionData) {
                        Node src = (Node)((EntityConnectionData)selectedElement).source;
                        Node dst = (Node)((EntityConnectionData)selectedElement).dest;
                        GraphicalView.this.selectedEdge = src.findSourceEdge(dst.getLabel());
                        GraphicalView.this.programNameForSelectedEdge = GraphicalView.this.selectedEdge.getProgramNameSourceNode();
                        graphController.setLastTransitionStatements(GraphicalView.this.programNameForSelectedEdge, GraphicalView.this.selectedEdge);
                        graphController.setAnnotationInEditor(GraphicalView.this.programNameForSelectedEdge, GraphicalView.this.selectedEdge);
                    }
                }
            }
        };
        return listener;
    }

    private void removeAnnotationsAndActivateGraphView() {
        AnnotationController.removeAllAnnotations();
        graphController.activateGraphicalView();
    }

    private DragDetectListener getDragDetectListener() {
        DragDetectListener listener = new DragDetectListener(){

            public void dragDetected(DragDetectEvent e) {
                GraphicalView.this.graphViewer.getGraphControl().removeMouseMoveListener(GraphicalView.this.mouseMoveListener);
                Utils.changeCursor((EventObject)e, 5);
                GraphicalView.this.cursorChanged = true;
                if (!GraphicalView.this.graphViewer.getSelection().isEmpty()) {
                    GraphicalView.this.previousGraphSelection = GraphicalView.this.graphViewer.getSelection();
                    GraphicalView.this.previousGraphItem = (GraphItem)GraphicalView.this.graphViewer.getGraphControl().getSelection().get(0);
                    GraphicalView.this.previousGraphItemName = GraphicalView.this.previousGraphItem.getText();
                }
                if (GraphicalView.this.graphViewer.getSelection().isEmpty()) {
                    GraphicalView.this.graphViewer.getGraphControl().getGraph().selectAll();
                    GraphicalView.this.generatePseudoKeyPressed();
                    GraphicalView.this.graphViewer.refresh();
                }
            }
        };
        return listener;
    }

    public void dispose() {
        graphController.setView(null);
        graphController.removePropertyChangeListener(this);
        AnnotationController.removeAllAnnotations();
        super.dispose();
    }

    public void setSelection(Node node) {
        StructuredSelection selection = null;
        if (node != null) {
            selection = new StructuredSelection((Object)node);
        }
        this.graphViewer.setSelection(selection);
    }

    public void setHistorySliderMaximum(final int index) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GraphicalView.this.historySlider.setEnabled(true);
                GraphicalView.this.historySlider.setMaximum(index + 1);
                GraphicalView.this.historySlider.setSelection(index);
                GraphicalView.this.maxHistorySliderIndex = index;
                GraphicalView.this.lblCurrentHistory.setToolTipText(String.valueOf(graphController.getHistoryTraceLogIndex()) + " out of " + GraphicalView.this.maxHistorySliderIndex + " statements visualized");
            }
        });
    }

    private void unhighlightSelection() {
        int i = 0;
        while (i < this.graphViewer.getGraphControl().getSelection().size()) {
            GraphItem item = (GraphItem)this.graphViewer.getGraphControl().getSelection().get(i);
            if (!item.getText().equals(this.previousGraphItemName)) {
                item.unhighlight();
            }
            ++i;
        }
    }

    private void generatePseudoKeyPressed() {
        Robot r = null;
        try {
            r = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
        int keyCode = 113;
        r.keyPress(keyCode);
        r.keyRelease(keyCode);
    }

    private void addZoomSlider() {
        this.zoomManager = new ZoomManager(this.graphViewer.getGraphControl().getRootLayer(), this.graphViewer.getGraphControl().getViewport());
        this.zoomManager.setZoomLevels(this.zoomLevels);
        this.compStatusBar.setLayout((Layout)new FormLayout());
        this.zoomScale = new Scale(this.compStatusBar, 0);
        this.zoomScale.setMaximum(180);
        this.zoomScale.setMinimum(20);
        this.zoomScale.setSelection(100);
        this.zoomScale.setPageIncrement(160);
        FormData fd_scale = new FormData();
        fd_scale.bottom = new FormAttachment(100, this.windowsFontSizeRelatives.getRelativeScaleBottom());
        fd_scale.top = new FormAttachment(0, this.windowsFontSizeRelatives.getRelativeScaleTop());
        this.zoomScale.setLayoutData((Object)fd_scale);
        this.zoomLabel = new CLabel(this.compStatusBar, 0);
        FormData fd_zoomLabel = new FormData();
        fd_zoomLabel.right = new FormAttachment(100, -10);
        fd_zoomLabel.top = new FormAttachment(0, 5);
        fd_zoomLabel.bottom = new FormAttachment(100, -6);
        this.zoomLabel.setLayoutData((Object)fd_zoomLabel);
        this.zoomLabel.setText(this.zoomManager.getZoomAsText());
        this.zoomOutButton = new Button(this.compStatusBar, 0x1800000);
        fd_scale.left = new FormAttachment((Control)this.zoomOutButton);
        FormData fd_zoomOutButton = new FormData();
        fd_zoomOutButton.bottom = new FormAttachment(100, -10);
        fd_zoomOutButton.width = 16;
        fd_zoomOutButton.height = 16;
        fd_zoomOutButton.top = new FormAttachment(0, 10);
        fd_zoomOutButton.right = new FormAttachment(100, -268);
        this.zoomOutButton.setLayoutData((Object)fd_zoomOutButton);
        this.zoomOutButton.setImage(Utils.createImage("com.ca.visualdebugger.plugin", "icons/minus.png"));
        final Button zoomInButton = new Button(this.compStatusBar, 0x1000000);
        fd_scale.right = new FormAttachment((Control)zoomInButton);
        FormData fd_zoomInButton = new FormData();
        fd_zoomInButton.right = new FormAttachment((Control)this.zoomLabel, -5);
        fd_zoomInButton.bottom = new FormAttachment(100, -10);
        fd_zoomInButton.top = new FormAttachment(0, 10);
        fd_zoomInButton.height = 16;
        fd_zoomInButton.width = 16;
        zoomInButton.setLayoutData((Object)fd_zoomInButton);
        zoomInButton.setImage(Utils.createImage("com.ca.visualdebugger.plugin", "icons/plus.png"));
        final Runnable timer = new Runnable(){

            @Override
            public void run() {
                Display.getDefault().timerExec(100, (Runnable)this);
                if (GraphicalView.this.zoomIn) {
                    GraphicalView.this.zoomManager.setZoomAsText(String.valueOf(GraphicalView.this.zoomManager.getZoom() * 100.0 + 1.0));
                } else {
                    GraphicalView.this.zoomManager.setZoomAsText(String.valueOf(GraphicalView.this.zoomManager.getZoom() * 100.0 - 1.0));
                }
                GraphicalView.this.zoomLabel.setText(GraphicalView.this.zoomManager.getZoomAsText());
                GraphicalView.this.zoomScale.setSelection(Integer.valueOf(GraphicalView.this.zoomManager.getZoomAsText().split("%")[0]).intValue());
            }
        };
        Listener zoomListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.type == 3) {
                    if (e.widget.equals(GraphicalView.this.zoomOutButton)) {
                        GraphicalView.this.zoomIn = false;
                        GraphicalView.this.zoomManager.setZoomAsText(String.valueOf(GraphicalView.this.zoomManager.getZoom() * 100.0 - 1.0));
                        GraphicalView.this.zoomLabel.setText(GraphicalView.this.zoomManager.getZoomAsText());
                        GraphicalView.this.zoomScale.setSelection(Integer.valueOf(GraphicalView.this.zoomManager.getZoomAsText().split("%")[0]).intValue());
                        Display.getDefault().timerExec(200, timer);
                        GraphicalView.this.graphViewer.getGraphControl().setFocus();
                    }
                    if (e.widget.equals(zoomInButton)) {
                        GraphicalView.this.zoomIn = true;
                        GraphicalView.this.zoomManager.setZoomAsText(String.valueOf(GraphicalView.this.zoomManager.getZoom() * 100.0 + 1.0));
                        GraphicalView.this.zoomLabel.setText(GraphicalView.this.zoomManager.getZoomAsText());
                        GraphicalView.this.zoomScale.setSelection(Integer.valueOf(GraphicalView.this.zoomManager.getZoomAsText().split("%")[0]).intValue());
                        Display.getDefault().timerExec(200, timer);
                        GraphicalView.this.graphViewer.getGraphControl().setFocus();
                    }
                }
                if (e.type == 4) {
                    Display.getDefault().timerExec(-1, timer);
                }
            }
        };
        this.zoomOutButton.addListener(3, zoomListener);
        this.zoomOutButton.addListener(4, zoomListener);
        zoomInButton.addListener(3, zoomListener);
        zoomInButton.addListener(4, zoomListener);
        this.zoomScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphicalView.this.zoomLabel.setText(String.valueOf(String.valueOf(GraphicalView.this.zoomScale.getSelection())) + "%");
                GraphicalView.this.zoomManager.setZoomAsText(String.valueOf(GraphicalView.this.zoomScale.getSelection()));
                GraphicalView.this.graphViewer.getGraphControl().setFocus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addContextMenu() {
        MenuManager menuManager = new MenuManager();
        this.menu = menuManager.createContextMenu((Control)this.graphViewer.getGraphControl());
        this.graphViewer.getGraphControl().setMenu(this.menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.graphViewer);
    }

    private void addHistorySlider() {
        this.lblCurrentHistory = new Label(this.compStatusBar, 0);
        this.lblCurrentHistory.setText("0");
        this.fd_lblCurrentHistory = new FormData();
        this.fd_lblCurrentHistory.right = new FormAttachment((Control)this.zoomScale, -20);
        this.fd_lblCurrentHistory.bottom = new FormAttachment(100, -8);
        this.fd_lblCurrentHistory.top = new FormAttachment(0, this.windowsFontSizeRelatives.getRelativelblCurrentHistoryTop());
        this.fd_lblCurrentHistory.width = 90;
        this.lblCurrentHistory.setLayoutData((Object)this.fd_lblCurrentHistory);
        this.historySlider = new Slider(this.compStatusBar, 2048);
        FormData fd_historySlider = new FormData();
        fd_historySlider.right = new FormAttachment((Control)this.lblCurrentHistory, -5);
        fd_historySlider.bottom = new FormAttachment(100, -8);
        fd_historySlider.top = new FormAttachment(0, 8);
        fd_historySlider.left = new FormAttachment(0, 5);
        this.historySlider.setLayoutData((Object)fd_historySlider);
        this.historySlider.setThumb(1);
        this.historySlider.setEnabled(false);
        this.historySlider.setBackgroundImage(Utils.createImage("com.ca.visualdebugger.plugin", "icons/sliderBGdarkgrey.png"));
        this.historySlider.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GraphicalView.this.updateIndexAndAnnotation(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                GraphicalView.this.updateIndexAndAnnotation(e);
            }
        });
    }

    public Label getLblCurrentHistory() {
        return this.lblCurrentHistory;
    }

    public void setLblCurrentHistory(Label lblCurrentHistory) {
        this.lblCurrentHistory = lblCurrentHistory;
    }

    private void updateIndexAndAnnotation(SelectionEvent e) {
        graphController.setHistoryTraceLogIndex(this.historySlider.getSelection());
        if (e.detail == 0 || e.detail == 0x1000001 || e.detail == 0x1000002) {
            graphController.setAnnotationInEditor(this.programNameForSelectedEdge, this.selectedEdge);
        }
    }

    public void setFocus() {
        this.graphViewer.getControl().setFocus();
    }

    public GraphViewer getGraphViewer() {
        return this.graphViewer;
    }

    public void setSelectedState() {
        this.buttonTransaction.setSelectedState();
    }

    public void switchToTransactionLevel(boolean doRefresh) {
        if (!this.isBlueBarAtTransactionLevel()) {
            if (this.compProgramLevelPart != null) {
                this.compProgramLevelPart.dispose();
                this.compProgramLevelPart = null;
            }
            this.buttonProgram = null;
        }
        if (graphController.getCurrentSession() != null) {
            this.updateTransactionButton();
            if (doRefresh) {
                this.setInputAndRefresh(graphController.getCurrentSession().getNodes());
            }
        } else {
            this.setInputAndRefresh(null);
        }
    }

    public void switchToProgramLevel(String programNameSelected) {
        this.updateBlueBarToProgramLevel(programNameSelected);
        this.updateButtonStates(this.buttonProgram);
        this.setInputAndRefresh(graphController.getNodes(programNameSelected));
    }

    private boolean isBlueBarAtTransactionLevel() {
        return this.compProgramLevelPart == null;
    }

    private void createProgramLevelComposite() {
        if (this.compProgramLevelPart != null) {
            this.compProgramLevelPart.dispose();
        }
        this.compProgramLevelPart = new Composite(this.compBlueBar, 0);
        this.compProgramLevelPart.setBackground(BLUE_BAR_BACKGROUND);
        FormData fd_compProgramLevel = new FormData();
        fd_compProgramLevel.left = new FormAttachment((Control)this.buttonTransaction.getCompButton(), 6);
        fd_compProgramLevel.right = new FormAttachment(100);
        fd_compProgramLevel.bottom = new FormAttachment((Control)this.buttonTransaction.getCompButton(), 0, 1024);
        fd_compProgramLevel.top = new FormAttachment((Control)this.buttonTransaction.getCompButton(), 0, 128);
        this.compProgramLevelPart.setLayoutData((Object)fd_compProgramLevel);
        this.compProgramLevelPart.setLayout((Layout)new FormLayout());
        this.compBlueBar.layout();
    }

    private void updateBlueBarToProgramLevel(String programNameSelected) {
        this.createProgramLevelComposite();
        String textName = programNameSelected;
        if (programNameSelected == null || programNameSelected.isEmpty()) {
            textName = this.buttonProgram.getButtonLabel().getText();
        }
        Label lblSlash = new Label(this.compProgramLevelPart, 0);
        lblSlash.setText(BLUE_BAR_SLASH);
        lblSlash.setBackground(BLUE_BAR_BACKGROUND);
        FormData fd_lblSlash = new FormData();
        fd_lblSlash.top = new FormAttachment(0, 2);
        fd_lblSlash.left = new FormAttachment(0, 5);
        lblSlash.setLayoutData((Object)fd_lblSlash);
        lblSlash.moveAbove(null);
        Composite compProgram = new Composite(this.compProgramLevelPart, 2048);
        compProgram.setBackground(BLUE_BAR_BACKGROUND);
        FormData fd_compProgramCaller = new FormData();
        fd_compProgramCaller.left = new FormAttachment((Control)lblSlash, 10);
        fd_compProgramCaller.top = new FormAttachment(0, 0);
        fd_compProgramCaller.bottom = new FormAttachment(100, 0);
        compProgram.setLayoutData((Object)fd_compProgramCaller);
        compProgram.setLayout((Layout)new FormLayout());
        Font font = new Font(null, new FontData("Arial", 10, 0));
        CLabel lblProgram1 = new CLabel(compProgram, 0);
        lblProgram1.setBackground(BLUE_BAR_BACKGROUND);
        lblProgram1.setText(textName);
        lblProgram1.setFont(font);
        FormData fd_lblProgram1 = new FormData();
        fd_lblProgram1.left = new FormAttachment(0);
        fd_lblProgram1.bottom = new FormAttachment(100, 1);
        lblProgram1.setTopMargin(10);
        lblProgram1.setLeftMargin(10);
        lblProgram1.setRightMargin(10);
        lblProgram1.setLayoutData((Object)fd_lblProgram1);
        this.buttonProgram = new BlueBarButton(compProgram, lblProgram1, 1);
        this.buttonProgram.addPropertyChangeListener(this);
        this.compProgramLevelPart.layout();
    }

    private void updateButtonStates(BlueBarButton selectedButton) {
        if (this.buttonTransaction != null) {
            if (this.buttonTransaction == selectedButton) {
                this.buttonTransaction.setSelectedState();
            } else {
                this.buttonTransaction.setDefaultState();
            }
        }
        if (this.buttonProgram != null) {
            if (this.buttonProgram == selectedButton) {
                this.buttonProgram.setSelectedState();
            } else {
                this.buttonProgram.setDefaultState();
            }
        }
    }

    private void updateTransactionButton() {
        if (graphController.getCurrentSession() != null) {
            this.lblTransaction.setText(graphController.getSessionTransactionName());
            this.compBlueBar.layout();
            this.compTransaction.setVisible(true);
        } else {
            this.compTransaction.setVisible(false);
        }
    }

    public void setBlueBarButtonVisible(boolean visible) {
        this.compBlueBar.setVisible(visible);
    }

    public void storeSelectedProgramName(String programName) {
        if (programName != null) {
            if (this.programNameSelectedList.size() == 0) {
                this.programNameSelectedList.add(graphController.getSessionTransactionName());
            }
            if (this.previousProgramIndex != -1 && this.previousProgramIndex <= this.programNameSelectedList.size() - 2 && !this.programNameSelectedList.get(this.previousProgramIndex).equals(programName)) {
                ++this.previousProgramIndex;
                this.programNameSelectedList.add(this.previousProgramIndex, programName);
                this.cleanListOfStoredProgramNames(this.previousProgramIndex);
                this.previousProgramIndex = -1;
                this.bottomListItem = false;
            } else if (this.programNameSelectedList.size() >= 32 && !this.programNameSelectedList.get(this.programNameSelectedList.size() - 1).equals(programName)) {
                this.programNameSelectedList.remove(0);
                this.programNameSelectedList.add(programName);
            } else if (!this.programNameSelectedList.get(this.programNameSelectedList.size() - 1).equals(programName)) {
                if (this.previousProgramIndex != -1) {
                    ++this.previousProgramIndex;
                }
                this.bottomListItem = false;
                this.programNameSelectedList.add(programName);
            }
            this.lastListItem = true;
            this.requestPropertyEvaluation();
        }
    }

    public void backToPreviousProgram() {
        if (!this.programNameSelectedList.isEmpty() && this.previousProgramIndex != 0) {
            int n = this.previousProgramIndex = this.previousProgramIndex == -1 ? this.programNameSelectedList.size() - 2 : this.previousProgramIndex - 1;
            if (this.previousProgramIndex == 0 && this.programNameSelectedList.get(this.previousProgramIndex).equals(graphController.getSessionTransactionName())) {
                this.bottomListItem = true;
                this.lastListItem = false;
                this.switchToTransactionLevel(true);
            } else {
                if (this.previousProgramIndex == 0) {
                    this.bottomListItem = true;
                }
                this.switchBetweenTransactionAndProgramLevels();
                this.lastListItem = false;
            }
        }
        this.requestPropertyEvaluation();
    }

    public void forwardToNextVisitedProgram() {
        if (!this.programNameSelectedList.isEmpty() && this.previousProgramIndex != -1) {
            ++this.previousProgramIndex;
            if (this.previousProgramIndex < this.programNameSelectedList.size()) {
                if (this.previousProgramIndex == this.programNameSelectedList.size() - 1) {
                    this.lastListItem = true;
                }
                this.bottomListItem = false;
                this.switchBetweenTransactionAndProgramLevels();
            }
        }
        this.requestPropertyEvaluation();
    }

    private void switchBetweenTransactionAndProgramLevels() {
        if (this.programNameSelectedList.get(this.previousProgramIndex).equals(graphController.getSessionTransactionName())) {
            this.switchToTransactionLevel(true);
        } else {
            this.switchToProgramLevel(this.programNameSelectedList.get(this.previousProgramIndex));
        }
    }

    private void requestPropertyEvaluation() {
        IEvaluationService service = (IEvaluationService)this.getSite().getService(IEvaluationService.class);
        service.requestEvaluation("com.ca.visualdebugger.plugin.ui.commands.graphCommandsPropertyTester.isBottomlistItem");
        service.requestEvaluation("com.ca.visualdebugger.plugin.ui.commands.graphCommandsPropertyTester.isLastListItem");
    }

    private void cleanListOfStoredProgramNames(int index) {
        while (this.programNameSelectedList.size() - 1 > index) {
            this.programNameSelectedList.remove(this.programNameSelectedList.size() - 1);
        }
    }

    public void cleanListOfStoredProgramNames() {
        if (!this.programNameSelectedList.isEmpty()) {
            this.programNameSelectedList.clear();
            this.bottomListItem = true;
            this.lastListItem = true;
            this.previousProgramIndex = -1;
        }
    }

    public boolean isProgramLevel() {
        return this.compProgramLevelPart != null;
    }

    public String getSelectedProgramName() {
        return this.buttonProgram.getName();
    }

    public void setInputAndRefresh(final List<Node> nodes) {
        AnnotationController.removeAllAnnotations();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GraphicalView.this.graphViewer.setInput((Object)nodes);
                GraphicalView.this.graphViewer.refresh();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("selectButton")) {
            BlueBarButton selectedButton = (BlueBarButton)evt.getSource();
            this.updateButtonStates(selectedButton);
            if (selectedButton.isProgramButton()) {
                this.switchToProgramLevel(selectedButton.getName());
                this.storeSelectedProgramName(selectedButton.getName());
            }
            if (selectedButton.isTransactionButton()) {
                this.switchToTransactionLevel(true);
                this.storeSelectedProgramName(graphController.getSessionTransactionName());
            }
            return;
        }
        if (evt.getPropertyName().equals("TransactionChange")) {
            String newSessionName = graphController.getSessionTransactionName();
            if (this.lblTransaction != null && this.lblTransaction.getText().equals(newSessionName)) {
                this.updateTransactionButton();
            } else {
                this.switchToTransactionLevel(false);
            }
            return;
        }
    }

    public AbstractZoomableViewer getZoomableViewer() {
        return this.graphViewer;
    }

    public void focusOnCurrentlyExecutingNode() {
        if (GraphController.getInstance().getCurrentSession() == null) {
            return;
        }
        ProgramNode currentProgram = GraphController.getInstance().getCurrentSession().getCurrentProgram();
        if (this.isProgramLevel()) {
            if (!this.getSelectedProgramName().equals(currentProgram.getLabel())) {
                this.isFocusFromOtherProgram = true;
                this.switchToProgramLevel(currentProgram.getLabel());
            } else {
                this.centerOnNode(GraphController.getInstance().getCurrentSession().getCurrentParagraph());
                if (graphController.isSyncToggleOn()) {
                    this.setSelection(GraphController.getInstance().getCurrentSession().getCurrentParagraph());
                    this.graphViewer.getGraphControl().notifyListeners(13, new Event());
                }
            }
        } else {
            this.centerOnNode(currentProgram);
            if (graphController.isSyncToggleOn()) {
                this.setSelection(currentProgram);
                this.graphViewer.getGraphControl().notifyListeners(13, new Event());
            }
        }
    }

    public void displayStartDebug(Composite container) {
        this.noteStartDebug = new Text(container, 16777290);
        this.noteStartDebug.setBackground(COLOR_WHITE);
        this.noteStartDebug.setText("Start debugging COBOL CICS or Batch programs with the statement trace turned on, or load a statement trace from a file to view.");
        FormData fd_noteStartDebug = new FormData();
        fd_noteStartDebug.bottom = new FormAttachment(60, 60, -60);
        fd_noteStartDebug.left = new FormAttachment(0, 5);
        fd_noteStartDebug.right = new FormAttachment(99);
        fd_noteStartDebug.top = new FormAttachment(0, 50);
        this.noteStartDebug.setLayoutData((Object)fd_noteStartDebug);
        this.noteStartDebug.setVisible(true);
    }

    public void centerOnNode(Node node) {
        GraphItem foundNode = this.graphViewer.findGraphItem((Object)node);
        if (foundNode == null) {
            return;
        }
        this.centerOnNode((GraphNode)this.graphViewer.findGraphItem((Object)node));
    }

    private void centerOnNode(GraphNode centeringNode) {
        if (centeringNode == null) {
            return;
        }
        Integer zoomValue = Integer.valueOf(this.zoomManager.getZoomAsText().split("%")[0]);
        Dimension currentNodeSize = centeringNode.getSize();
        Point currentNodeLocation = centeringNode.getLocation();
        org.eclipse.swt.graphics.Point graphViewerSize = this.graphViewer.getGraphControl().getSize();
        double zoomCoefficient = (double)zoomValue.intValue() / 100.0;
        double middleX = (double)(graphViewerSize.x / 2) / zoomCoefficient;
        double middleY = (double)(graphViewerSize.y / 2) / zoomCoefficient;
        Point delta = new Point(currentNodeLocation.x + currentNodeSize.width / 2 - (int)middleX, currentNodeLocation.y + currentNodeSize.height / 2 - (int)middleY);
        List nodesList = this.graphViewer.getGraphControl().getNodes();
        for (Object nodeObject : nodesList) {
            if (!(nodeObject instanceof GraphNode)) continue;
            GraphNode node = (GraphNode)nodeObject;
            node.setLocation((double)(node.getLocation().x - delta.x), (double)(node.getLocation().y - delta.y));
        }
        this.graphViewer.getGraphControl().scrollTo(0, 0);
    }

    private ProgressListener createLayoutProgressListener() {
        return new ProgressListener(){

            public void progressStarted(ProgressEvent e) {
            }

            public void progressUpdated(ProgressEvent e) {
            }

            public void progressEnded(ProgressEvent e) {
                if (GraphicalView.this.isFocusFromOtherProgram) {
                    GraphicalView.this.isFocusFromOtherProgram = false;
                    GraphicalView.this.centerOnNode(GraphController.getInstance().getCurrentSession().getCurrentParagraph());
                }
            }
        };
    }

    private MouseMoveListener createMouseMoveListener() {
        return new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                double zoom = GraphicalView.this.zoomManager.getZoom();
                FigureCanvas figureCanvas = (FigureCanvas)GraphicalView.this.graphViewer.getControl();
                Point viewLocation = figureCanvas.getViewport().getViewLocation();
                List nodesList = GraphicalView.this.graphViewer.getGraphControl().getNodes();
                for (GraphNode node : nodesList) {
                    double h;
                    double w;
                    double y;
                    if (!node.isVisible()) continue;
                    double x = node.getLocation().preciseX() * zoom - (double)viewLocation.x;
                    Rectangle rect = new Rectangle((int)x, (int)(y = node.getLocation().preciseY() * zoom - (double)viewLocation.y), (int)(w = node.getSize().preciseWidth() * zoom), (int)(h = node.getSize().preciseHeight() * zoom));
                    if (rect.contains(e.x, e.y)) {
                        Utils.changeCursor((EventObject)e, 21);
                        node.setBackgroundColor(Colors.NODE_BACKGROUND_HOVER);
                        return;
                    }
                    if (node.getData() instanceof ProgramNode && GraphicalView.this.isProgramLevel()) {
                        node.setBackgroundColor(Colors.NODE_BACKGROUND_EXTERNAL_PROGRAM);
                        continue;
                    }
                    node.setBackgroundColor(Colors.NODE_BACKGROUND);
                }
                Utils.changeCursor((EventObject)e, 0);
            }
        };
    }

    public MouseMoveListener getMouseMoveListener() {
        return this.mouseMoveListener;
    }

    public void checkAndAddMouseMoveListener() {
        Listener[] listeners = this.graphViewer.getGraphControl().getListeners(5);
        boolean listenerAdded = false;
        int i = 0;
        while (i < listeners.length) {
            TypedListener typedListener;
            if (listeners[i] instanceof TypedListener && (typedListener = (TypedListener)listeners[i]).getEventListener() == this.getMouseMoveListener()) {
                listenerAdded = true;
                break;
            }
            ++i;
        }
        if (!listenerAdded) {
            this.graphViewer.getGraphControl().addMouseMoveListener(this.getMouseMoveListener());
        }
    }

    public SpringLayoutAlgorithm getDefaultLayoutAlgorithm() {
        return this.defaultLayoutAlgorithm;
    }

    public boolean isEventFiredFromSelectionChanged() {
        return this.eventFiredFromSelectionChanged;
    }

    public void updateEventstate(boolean value) {
        this.eventFiredFromSelectionChanged = value;
    }

    public void updateGraphView() {
        this.switchToTransactionLevel(true);
        this.updateTransactionButton();
        this.lblCurrentHistory.setText(Integer.toString(graphController.getHistoryTraceLogIndex()));
        this.cleanListOfStoredProgramNames();
        this.requestPropertyEvaluation();
    }

    public void resetInitialState() {
        this.setInputAndRefresh(null);
        this.cleanListOfStoredProgramNames();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GraphicalView.this.compTransaction.setVisible(false);
                if (GraphicalView.this.compProgramLevelPart != null) {
                    GraphicalView.this.compProgramLevelPart.setVisible(false);
                }
                GraphicalView.this.historySlider.setEnabled(false);
                GraphicalView.this.lblCurrentHistory.setText(Integer.toString(graphController.getHistoryTraceLogIndex()));
            }
        });
    }

    public void deselectAllConnections() {
        this.styledLabelProvider.deselectAllConnections();
    }

    public void setSelection(EntityConnectionData ecd) {
        StructuredSelection selection = null;
        if (ecd != null) {
            selection = new StructuredSelection((Object)ecd);
        }
        this.getGraphViewer().setSelection(selection);
    }

    public String getLastSourceProgramName() {
        Object source = this.getLastSource();
        if (source != null) {
            return source.toString();
        }
        return null;
    }

    public void handleNoteDebug() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GraphicalView.this.noteStartDebug.setVisible(false);
            }
        });
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("com.ca.visualdebugger.plugin.context");
    }

    public int getMaxHistorySliderIndex() {
        return this.maxHistorySliderIndex;
    }

    public Object getLastSource() {
        IStructuredSelection strucSelection;
        Object selectedElement;
        ISelection selection = this.getGraphViewer().getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (selectedElement = (strucSelection = (IStructuredSelection)selection).getFirstElement()) instanceof EntityConnectionData) {
            EntityConnectionData selectedConnection = (EntityConnectionData)selectedElement;
            return selectedConnection.source;
        }
        return null;
    }

    public String getProgramNameSelectedForTheEdge() {
        return this.programNameForSelectedEdge;
    }

    public boolean isBottomListItem() {
        return this.bottomListItem;
    }

    public boolean isLastListItem() {
        return this.lastListItem;
    }
}

