/*
 * Decompiled with CFR 0.152.
 */
package com.ca.visualdebugger.plugin.controller;

import com.ca.intertest.common.IActionListener;
import com.ca.intertest.common.IViewConnector;
import com.ca.intertest.common.XMLTraceUtils;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.BacktraceLogMessage;
import com.ca.intertest.ui.lister.ListerEditor;
import com.ca.visualdebugger.plugin.controller.AnnotationController;
import com.ca.visualdebugger.plugin.controller.ContextSession;
import com.ca.visualdebugger.plugin.controller.DebugSessionEventListener;
import com.ca.visualdebugger.plugin.model.Edge;
import com.ca.visualdebugger.plugin.model.GraphSession;
import com.ca.visualdebugger.plugin.model.ModelBuilder;
import com.ca.visualdebugger.plugin.model.Node;
import com.ca.visualdebugger.plugin.model.ParagraphNode;
import com.ca.visualdebugger.plugin.model.ProgramNode;
import com.ca.visualdebugger.plugin.parser.CobolListingReader;
import com.ca.visualdebugger.plugin.parser.CobolMetadataReader;
import com.ca.visualdebugger.plugin.trace.TraceHandler;
import com.ca.visualdebugger.plugin.views.GraphicalView;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class GraphController
implements IPropertyChangeListener,
IActionListener,
IViewConnector {
    public static final String EDGE_ANNOTATION_TYPE = "com.ca.visualdebugger.lister.edge";
    private static GraphController instance = null;
    private static TraceHandler traceHandler = TraceHandler.getInstance();
    private GraphicalView view;
    private Map<String, ContextSession> contextSessionMap = new HashMap<String, ContextSession>();
    private ContextSession currentContext;
    private ModelBuilder modelBuilder;
    private static Debug debug;
    private Boolean debugStarted = false;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean syncToggleOn;
    private List<String> lastCallMenuStatements = new ArrayList<String>();
    private List<Integer> lastCallMenuStatementPositions = new ArrayList<Integer>();

    public GraphController() {
        debug = Debug.getInstance();
        this.currentContext = new ContextSession(debug.getLoadedSession(), null, 0);
        this.syncToggleOn = (Boolean)((ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class)).getCommand("com.ca.visualdebugger.plugin.ui.ToggleSynchronizeCommand").getState("org.eclipse.ui.commands.toggleState").getValue();
        this.modelBuilder = new ModelBuilder();
        debug.addItemToViewsList((IViewConnector)this);
        debug.addItemToActionListenerList((IActionListener)this);
    }

    public static synchronized GraphController getInstance() {
        if (instance == null) {
            instance = new GraphController();
        }
        GraphController.initDebugSessionListeners();
        return instance;
    }

    public List<Node> getNodes(String programName) {
        if (this.currentContext.getGraphSession() == null) {
            return new ArrayList<Node>();
        }
        return this.currentContext.getGraphSession().getProgramNode(programName).getNodes();
    }

    public void saveGraphData() {
        traceHandler.saveTraceData();
    }

    public void loadGraphData() {
        traceHandler.loadTraceData();
    }

    public void updateNewIndex(int newIndex) {
        if (this.view != null) {
            this.view.setHistorySliderMaximum(newIndex);
        }
    }

    private static void initDebugSessionListeners() {
        for (debugSession dbgSession : Debug.getInstance().getSessions()) {
            DebugSessionEventListener.register(dbgSession, instance);
        }
        Debug.getInstance().addPropertyChangeListener((IPropertyChangeListener)instance);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equalsIgnoreCase("com.ca.intertest.ui.views.debug") && event.getNewValue() instanceof debugSession) {
            debugSession dbgSession = (debugSession)event.getNewValue();
            DebugSessionEventListener.register(dbgSession, instance);
        }
        if (event.getProperty().equalsIgnoreCase("DEBUG_FILE_CHANGED") && event.getSource() instanceof debugFile) {
            debugFile source = (debugFile)event.getSource();
            if (event.getNewValue() instanceof Integer) {
                switch ((Integer)event.getNewValue()) {
                    case 2: 
                    case 4: {
                        CobolMetadataReader.removeMetadataReaderFor(source);
                        CobolListingReader.removeListingReaderFor(source);
                        break;
                    }
                }
            }
        }
    }

    public void selectNodeBasedOnListing(String programName, int lineNum) {
        if (this.currentContext.getGraphSession() == null || this.view == null) {
            return;
        }
        ProgramNode programNode = this.currentContext.getGraphSession().getProgramNode(programName);
        if (programNode == null) {
            return;
        }
        if (this.view.getLastSourceProgramName() != null && this.view.getLastSourceProgramName().equals(programNode.toString())) {
            return;
        }
        if (!this.view.isProgramLevel() && !this.view.isEventFiredFromSelectionChanged()) {
            AnnotationController.removeAllAnnotations();
            this.view.deselectAllConnections();
            this.view.setSelection(programNode);
            this.view.centerOnNode(programNode);
        } else {
            ParagraphNode paragraphNode = programNode.findParagraphNodeByLine(lineNum);
            if (paragraphNode == null) {
                return;
            }
            if (!this.view.isEventFiredFromSelectionChanged() && programName.equals(this.view.getSelectedProgramName())) {
                if (this.view.getLastSourceProgramName() != null && this.view.getLastSource() instanceof ParagraphNode && paragraphNode.equals(this.view.getLastSource())) {
                    return;
                }
                AnnotationController.removeAllAnnotations();
                this.view.deselectAllConnections();
                this.view.setSelection(paragraphNode);
                this.view.centerOnNode(paragraphNode);
            }
        }
    }

    public void positionEditorOnLine(String programName, int lineNum) {
        ListerEditor editor = (ListerEditor)debug.openListerEditor(programName, this.currentContext.getDebugSession());
        if (editor == null) {
            return;
        }
        Position position = editor.getLinePosition(Integer.valueOf(lineNum));
        this.view.updateEventstate(true);
        editor.selectAndReveal(position.getOffset(), position.getLength());
        this.activateGraphicalView();
    }

    public void positionEditorOnStmt(String programName, int stmtNum) {
        ListerEditor editor = (ListerEditor)debug.openListerEditor(programName, this.currentContext.getDebugSession());
        if (editor == null) {
            return;
        }
        Position position = editor.getStmntPosition(stmtNum);
        this.view.updateEventstate(true);
        editor.selectAndReveal(position.getOffset(), position.getLength());
        this.activateGraphicalView();
    }

    public void setAnnotationInEditor(String programName, final Edge edge) {
        AnnotationController.removeAllAnnotations();
        if (edge != null && this.isSyncToggleOn()) {
            final AnnotationController annotationController = AnnotationController.getInstance(programName);
            ListerEditor editor = (ListerEditor)debug.openListerEditor(programName, this.currentContext.getDebugSession());
            List<Integer> indexes = this.adjustEdgeTraceLogIndexes(edge.getTraceLogIndexes());
            final ArrayList<Position> sources = new ArrayList<Position>();
            for (Integer i : indexes) {
                BacktraceLogMessage.TraceLogRecord t = this.findTraceLogRecord(i, edge);
                Position source = editor.getStmntPosition(t.firstStatement);
                if (sources.contains(source)) continue;
                sources.add(source);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        annotationController.addEdgeAnnotation(edge, (Position)sources.get(sources.size() - 1));
                    }
                });
            }
            this.view.updateEventstate(true);
            if (sources.size() > 0) {
                editor.selectAndReveal(((Position)sources.get(sources.size() - 1)).getOffset(), ((Position)sources.get(sources.size() - 1)).getLength());
            }
            this.activateGraphicalView();
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener current) {
        this.pcs.addPropertyChangeListener(current);
    }

    public final void removePropertyChangeListener(PropertyChangeListener current) {
        this.pcs.removePropertyChangeListener(current);
    }

    public void debugEventOccured(debugSession session) {
        boolean switchProjects = false;
        if (this.contextSessionMap.containsKey(session.getName())) {
            if (this.currentContext != this.contextSessionMap.get(session.getName())) {
                switchProjects = true;
            }
            this.currentContext = this.contextSessionMap.get(session.getName());
        } else {
            this.currentContext = new ContextSession(session, null, 0);
            this.contextSessionMap.put(session.getName(), this.currentContext);
        }
        this.currentContext.setDebugSession(session);
        this.currentContext.setPathToListings(session.getResource().getLocationURI().getPath());
        this.debugStarted = true;
        if (session.getTracelog() != null) {
            if (!session.getTracelog().isEmpty()) {
                int preNodeSize = 0;
                ProgramNode selectedProgramNode = null;
                if (this.view != null && this.currentContext.getGraphSession() != null && this.view.isProgramLevel()) {
                    selectedProgramNode = this.currentContext.getGraphSession().getProgramNode(this.view.getSelectedProgramName());
                }
                if (this.currentContext.getGraphSession() != null) {
                    if (selectedProgramNode != null) {
                        if (selectedProgramNode.getNodes() != null) {
                            preNodeSize = selectedProgramNode.getNodes().size();
                        }
                    } else if (this.currentContext.getGraphSession().getNodes() != null) {
                        preNodeSize = this.currentContext.getGraphSession().getNodes().size();
                    }
                }
                ArrayList<?> adjustedTraceList = this.adjustTraceList(session.getTracelog());
                if (this.view != null && adjustedTraceList != null && adjustedTraceList.size() > 0) {
                    this.currentContext.setGraphSession(this.modelBuilder.build(this.currentContext.getGraphSession(), adjustedTraceList, true));
                }
                this.currentContext.setTraceLog(session.getTracelog());
                int nodeDelta = 0;
                if (this.currentContext.getGraphSession() != null && this.modelBuilder.isDeltaBuild()) {
                    if (selectedProgramNode != null) {
                        if (selectedProgramNode.getNodes() != null) {
                            nodeDelta = selectedProgramNode.getNodes().size() - preNodeSize;
                        }
                    } else if (this.currentContext.getGraphSession().getNodes() != null) {
                        nodeDelta = this.currentContext.getGraphSession().getNodes().size() - preNodeSize;
                    }
                    if (nodeDelta <= 1) {
                        this.view.getDefaultLayoutAlgorithm().setRandom(false);
                    } else {
                        this.view.getDefaultLayoutAlgorithm().setRandom(true);
                    }
                } else if (this.view != null) {
                    this.view.getDefaultLayoutAlgorithm().setRandom(true);
                }
                if (selectedProgramNode != null) {
                    if (!this.modelBuilder.isDeltaBuild() || selectedProgramNode.getNodes().size() != preNodeSize) {
                        this.view.setInputAndRefresh(selectedProgramNode.getNodes());
                    }
                } else if ((!this.modelBuilder.isDeltaBuild() || this.currentContext.getGraphSession().getNodes().size() != preNodeSize || switchProjects) && this.view != null) {
                    this.view.setInputAndRefresh(this.currentContext.getGraphSession().getNodes());
                }
            } else {
                this.currentContext.setTraceLog(null);
            }
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GraphController.this.pcs.firePropertyChange("TransactionChange", null, null);
            }
        });
    }

    public void addSessionToMap(debugSession debugSession2, ContextSession currentSession) {
        this.contextSessionMap.put(debugSession2.getName(), currentSession);
    }

    public String getSessionName() {
        if (this.currentContext.getDebugSession() != null) {
            return this.currentContext.getDebugSession().getName();
        }
        return null;
    }

    public String getSessionTransactionName() {
        if (this.currentContext.getDebugSession() != null) {
            return this.currentContext.getDebugSession().getTitle();
        }
        return null;
    }

    public void resetCurrentSession() {
        this.currentContext = new ContextSession(null, null, 0);
    }

    public void setView(GraphicalView view) {
        this.view = view;
    }

    public GraphicalView getViewer() {
        return this.view;
    }

    public GraphSession getCurrentSession() {
        return this.currentContext.getGraphSession();
    }

    public debugFile getdebugFile(String name) {
        if (this.currentContext.getDebugSession() != null) {
            return this.currentContext.getDebugSession().getFile(name);
        }
        return null;
    }

    public String getPathToListings() {
        return this.currentContext.getPathToListings();
    }

    public void setPathToListings(String path) {
        this.currentContext.setPathToListings(path);
    }

    public void refresh(debugSession session) {
        this.setDebugSession(session);
        boolean isListingEmpty = false;
        String programName = (String)XMLTraceUtils.getProgramName().iterator().next();
        for (String name : XMLTraceUtils.getProgramName()) {
            if (!this.isCobol(name)) continue;
            CobolMetadataReader cobolMetadataReader = null;
            if (session.getFile(name) != null) {
                cobolMetadataReader = CobolMetadataReader.getMetadataReaderFor(session.getFile(name));
            }
            if (cobolMetadataReader == null || cobolMetadataReader.isEmpty() || cobolMetadataReader.getMetadataStream() == null) {
                this.view.resetInitialState();
                MessageDialog.openError((Shell)this.getViewer().getSite().getShell(), (String)"Graphical View", (String)"The graph cannot be loaded. Program symbolic is missing.");
                isListingEmpty = true;
                break;
            }
            isListingEmpty = false;
        }
        if (!isListingEmpty) {
            IResource listingResource;
            debug.openListerEditor(programName, session);
            this.view.setBlueBarButtonVisible(true);
            if (session != null) {
                this.currentContext.setDebugSession(session);
                if (this.currentContext.getDebugSession() != null && (listingResource = this.currentContext.getDebugSession().getResource()) != null) {
                    this.currentContext.setPathToListings(listingResource.getLocationURI().getPath());
                }
            } else {
                return;
            }
            listingResource = this.currentContext.getDebugSession().getResource();
            if (listingResource != null) {
                this.currentContext.setPathToListings(listingResource.getLocationURI().getPath());
                ArrayList lineList = this.currentContext.getDebugSession().getLinelist();
                if (lineList != null && !lineList.isEmpty()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            GraphController.this.pcs.firePropertyChange("TransactionChange", null, null);
                        }
                    });
                    ArrayList<?> adjustedLineList = this.adjustTraceList(lineList);
                    if (adjustedLineList != null && adjustedLineList.size() > 0) {
                        this.currentContext.setGraphSession(this.modelBuilder.build(null, adjustedLineList, false));
                    } else {
                        this.clearGraphView();
                    }
                    this.contextSessionMap.put(session.getName(), this.currentContext);
                    this.view.switchToTransactionLevel(true);
                }
            }
        }
    }

    private boolean isCobol(String pgmName) {
        return pgmName != null && this.currentContext.getDebugSession().getFile(pgmName).getLanguage() == 32;
    }

    private String getProgramNameFromEntry(Object entry) {
        if (entry instanceof String) {
            String[] entryTokens = ((String)entry).trim().split("[ ]+", 3);
            if (entryTokens.length > 0 && entryTokens[0].isEmpty()) {
                return null;
            }
            return entryTokens[0];
        }
        if (entry instanceof BacktraceLogMessage.TraceLogRecord) {
            return ((BacktraceLogMessage.TraceLogRecord)entry).program;
        }
        return null;
    }

    private ArrayList<?> adjustTraceList(ArrayList<?> traceList) {
        ArrayList<String> adjustedTraceList = new ArrayList<String>();
        if (traceList != null && traceList.size() > 0) {
            for (Object entry : traceList) {
                if (!this.isCobol(this.getProgramNameFromEntry(entry))) continue;
                if (entry instanceof String) {
                    adjustedTraceList.add((String)entry);
                    continue;
                }
                adjustedTraceList.add((String)((BacktraceLogMessage.TraceLogRecord)entry));
            }
        }
        return adjustedTraceList;
    }

    public void buildModelOnInitialization() {
        if (this.currentContext.getDebugSession() == null) {
            return;
        }
        if (this.currentContext.getDebugSession() != null) {
            ArrayList trace = this.currentContext.getDebugSession().getTracelog();
            if (trace == null || trace.size() == 0) {
                trace = this.currentContext.getDebugSession().getLinelist();
            }
            IResource listingResource = this.currentContext.getDebugSession().getResource();
            if (trace != null && trace.size() > 0 && listingResource != null) {
                this.currentContext.setGraphSession(this.modelBuilder.build(null, trace, false));
                if (this.view != null) {
                    this.view.switchToTransactionLevel(true);
                }
            }
        }
    }

    public debugSession getDebugSession() {
        return this.currentContext.getDebugSession();
    }

    public debugSession getDebugSession(String sessionName) {
        ContextSession ctx = this.contextSessionMap.get(sessionName);
        if (ctx != null) {
            return ctx.getDebugSession();
        }
        return null;
    }

    private void setDebugSession(debugSession currentDebugSession) {
        this.currentContext = this.contextSessionMap.containsKey(currentDebugSession.getName()) ? this.contextSessionMap.get(currentDebugSession.getName()) : new ContextSession(currentDebugSession, null, 0);
        this.currentContext.setDebugSession(currentDebugSession);
        this.currentContext.setTraceLog(currentDebugSession.getTracelog());
        this.currentContext.setPathToListings(currentDebugSession.getResource().getLocationURI().getPath());
    }

    public int getHistoryTraceLogIndex() {
        return this.currentContext.getHistoryIndex();
    }

    public void setHistoryTraceLogIndex(final int historyTraceLogIndex) {
        if (this.view == null) {
            return;
        }
        if (this.currentContext.getHistoryIndex() != historyTraceLogIndex) {
            this.currentContext.setHistoryIndex(historyTraceLogIndex);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    GraphController.this.view.getLblCurrentHistory().setText(Integer.toString(historyTraceLogIndex));
                    GraphController.this.view.getLblCurrentHistory().setToolTipText(String.valueOf(historyTraceLogIndex) + " out of " + GraphController.this.view.getMaxHistorySliderIndex() + " statements visualized");
                    GraphController.this.view.getGraphViewer().refresh();
                }
            });
        }
    }

    public Boolean isDebugStarted() {
        return this.debugStarted;
    }

    public void setDebugStarted(Boolean debugStarted) {
        this.debugStarted = debugStarted;
    }

    public void setSyncToggle(boolean value) {
        this.syncToggleOn = value;
    }

    public boolean isSyncToggleOn() {
        return this.syncToggleOn;
    }

    public List<BacktraceLogMessage.TraceLogRecord> getTraceLog() {
        return this.currentContext.getTraceLog();
    }

    public void actionPerformed() {
        if (this.currentContext.getDebugSession() != null && this.view != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (GraphController.this.isSyncToggleOn()) {
                        GraphController.this.view.focusOnCurrentlyExecutingNode();
                    }
                }
            });
        }
    }

    public void showCurrentSession(String project) {
        if (this.contextSessionMap.containsKey(project) && this.currentContext != this.contextSessionMap.get(project)) {
            this.currentContext = this.contextSessionMap.get(project);
            if (this.currentContext.getGraphSession() != null) {
                this.view.setInputAndRefresh(this.currentContext.getGraphSession().getNodes());
            }
            if (this.contextSessionMap.get(project).getTraceLog() != null) {
                this.setHistoryTraceLogIndex(this.contextSessionMap.get(project).getTraceLog().size() - 1);
                this.view.setHistorySliderMaximum(this.contextSessionMap.get(project).getTraceLog().size() - 1);
            } else {
                this.setHistoryTraceLogIndex(0);
                this.view.setHistorySliderMaximum(0);
            }
            this.view.updateGraphView();
        }
    }

    public void clearGraphView() {
        this.setHistoryTraceLogIndex(0);
        this.view.setHistorySliderMaximum(0);
        this.view.resetInitialState();
    }

    public void removeFromMap(debugSession session) {
        if (this.contextSessionMap.containsKey(session.getName())) {
            this.currentContext = this.contextSessionMap.get(session.getName());
            this.currentContext.setDebugSession(session);
            this.currentContext.setGraphSession(null);
            this.currentContext.setHistoryIndex(0);
        }
    }

    public void setLastTransitionStatements(String programNameForSelectedEdge, Edge edge) {
        this.lastCallMenuStatementPositions.clear();
        this.lastCallMenuStatements.clear();
        List<Integer> edgeTraceLogIndexes = this.adjustEdgeTraceLogIndexes(edge.getTraceLogIndexes());
        List<Integer> last3tracelogIndexes = edgeTraceLogIndexes.subList(Math.max(edgeTraceLogIndexes.size() - 3, 0), edgeTraceLogIndexes.size());
        for (Integer i : last3tracelogIndexes) {
            BacktraceLogMessage.TraceLogRecord t = this.findTraceLogRecord(i, edge);
            this.lastCallMenuStatementPositions.add(t.firstStatement);
            String sourceLine = edge.getLineByStatementNumber(t.firstStatement, programNameForSelectedEdge);
            try {
                if (t.firstStatement == Integer.valueOf(sourceLine.trim().split(" ")[0])) {
                    sourceLine = sourceLine.substring(sourceLine.trim().indexOf(" ")).trim();
                }
            }
            catch (NumberFormatException numberFormatException) {}
            if (last3tracelogIndexes.size() > 1 && i.equals(last3tracelogIndexes.get(last3tracelogIndexes.size() - 1))) {
                this.lastCallMenuStatements.add("(LAST)" + String.format("%06d", t.firstStatement) + " " + sourceLine);
                return;
            }
            this.lastCallMenuStatements.add("           " + String.format("%06d", t.firstStatement) + " " + sourceLine);
        }
    }

    private List<Integer> adjustEdgeTraceLogIndexes(List<Integer> originalTraceLogIndexes) {
        ArrayList<Integer> adjustedTraceLogIndexes = new ArrayList<Integer>();
        for (Integer item : originalTraceLogIndexes) {
            if (item > this.currentContext.getHistoryIndex()) break;
            adjustedTraceLogIndexes.add(item);
        }
        return adjustedTraceLogIndexes;
    }

    private BacktraceLogMessage.TraceLogRecord findTraceLogRecord(int i, Edge edge) {
        debugSession currentDebugSession = this.currentContext.getDebugSession();
        if (currentDebugSession == null || currentDebugSession.getTracelog() == null || currentDebugSession.getTracelog().isEmpty()) {
            return null;
        }
        BacktraceLogMessage.TraceLogRecord t = (BacktraceLogMessage.TraceLogRecord)currentDebugSession.getTracelog().get(i - 1);
        if (currentDebugSession.isBatch()) {
            t = (BacktraceLogMessage.TraceLogRecord)currentDebugSession.getTracelog().get(i - 2);
            if (edge.getToNode() instanceof ParagraphNode) {
                if (((ParagraphNode)edge.getToNode()).getParagraphLabel().getStatementNumber() != ((BacktraceLogMessage.TraceLogRecord)currentDebugSession.getTracelog().get((int)(i - 1))).firstStatement) {
                    t = (BacktraceLogMessage.TraceLogRecord)currentDebugSession.getTracelog().get(i - 1);
                }
            } else {
                ProgramNode pgmNode = (ProgramNode)edge.getToNode();
                if (!((BacktraceLogMessage.TraceLogRecord)currentDebugSession.getTracelog().get((int)(i - 1))).program.equals(pgmNode.getLabel())) {
                    t = (BacktraceLogMessage.TraceLogRecord)currentDebugSession.getTracelog().get(i - 1);
                }
            }
        }
        return t;
    }

    public void positionEditorForMenuStatement(int menuIndex) {
        this.positionEditorOnStmt(this.view.getProgramNameSelectedForTheEdge(), this.lastCallMenuStatementPositions.get(menuIndex));
    }

    public List<String> getLastTransitionStaments() {
        return this.lastCallMenuStatements;
    }

    public void activateGraphicalView() {
        if (this.view != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)GraphController.this.view);
                }
            });
        }
    }
}

