/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.views.datawatch;

import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.Variable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.ui.part.ResourceTransfer;

public class DragOutlineItem
extends DragSourceAdapter {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private static final String COULD_NOT_DRAG_AND_DROP = "Could not drag and drop";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private StructuredViewer viewer;

    public DragOutlineItem(StructuredViewer viewer) {
        this();
        this.viewer = viewer;
    }

    private DragOutlineItem() {
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            event.doit = false;
        } else {
            for (Object obj : selection.toList()) {
                if (obj instanceof IWatchData) continue;
                event.doit = false;
                break;
            }
        }
        this.log.log(Level.FINE, "Drag result:{0}", event.doit);
    }

    public void dragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (ResourceTransfer.getInstance().isSupportedType(event.dataType)) {
            ArrayList<Variable> list = new ArrayList<Variable>(selection.size());
            for (Object obj : selection) {
                if (!(obj instanceof Variable)) continue;
                Variable variable = (Variable)obj;
                try {
                    Variable clone = (Variable)variable.clone();
                    list.add(clone);
                }
                catch (CloneNotSupportedException e) {
                    MessageDialog.openInformation(null, (String)"Error", (String)COULD_NOT_DRAG_AND_DROP);
                    this.log.log(Level.WARNING, COULD_NOT_DRAG_AND_DROP, e);
                }
            }
            event.data = list.toArray(new IWatchData[list.size()]);
        }
    }

    public void dragFinished(DragSourceEvent event) {
        super.dragFinished(event);
    }

    protected StructuredViewer getViewer() {
        return this.viewer;
    }
}

