/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ServerStatusJob
extends Job {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    protected final TTServer server;
    protected TT_TreeItem serverItem;
    private static final String REFRESHING = "Refreshing Status %1$s:";

    public ServerStatusJob(TT_TreeItem item) {
        super(String.format(REFRESHING, item.getText()));
        this.serverItem = item.getParent(TTServer.class);
        this.server = (TTServer)this.serverItem.getValue();
    }

    public ServerStatusJob(TTServer server) {
        super(String.format(REFRESHING, server.getText()));
        this.server = server;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.server.getPort() < 1) {
            this.server.setStatusText(12, "Invalid port");
        } else {
            try {
                InetSocketAddress socketaddress = new InetSocketAddress(this.server.getHostname(), this.server.getPort());
                Socket socket = new Socket();
                socket.connect(socketaddress);
                socket.close();
                if (this.validateUrl(this.server) && !this.server.isActive()) {
                    this.server.setStatusText(3, "Active");
                } else {
                    this.server.notifyStatusObservers();
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.server.setStatusText(12, "Unknown host");
            }
            catch (IOException e) {
                String text = HexUtil.getErrorText((Throwable)e);
                int ix = text.lastIndexOf(58);
                this.server.setStatusText(12, text.substring(0, ix > 0 ? ix : text.length()));
            }
        }
        return Status.OK_STATUS;
    }

    private boolean validateUrl(TTServer server) throws IOException {
        try {
            URL myURL = new URL(String.valueOf(server.getProtocol()) + "://" + server.getHostname() + ":" + server.getPort());
            if (myURL.getProtocol().equals("http")) {
                HttpURLConnection urlConnection = (HttpURLConnection)myURL.openConnection();
                urlConnection.getResponseCode();
            } else {
                HttpsURLConnection con = (HttpsURLConnection)myURL.openConnection();
                con.getResponseCode();
            }
        }
        catch (SocketException socketException) {
            server.setStatusText(12, "Port not available for HTTP.");
            return false;
        }
        catch (SSLException sSLException) {
            server.setStatusText(12, "Port not available for HTTPS.");
            return false;
        }
        return true;
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.toString().equals("com.ca.testingtools")) {
            return true;
        }
        return super.belongsTo(family);
    }
}

