/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.FMDB2ServerException;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.ServerConnect;
import com.ca.testingtools.core.TTServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.ContentEncodingHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class FMDB2ServerConnect
extends ServerConnect {
    public FMDB2ServerConnect(TTServer server, String service) {
        super(server, service);
    }

    public Object connect(String command, Map<String, Object> map, Map<String, Object> inputs) throws FMDB2ServerException {
        String query = null;
        try {
            Object xml;
            block24: {
                String message;
                if (this.service == null || this.service.length() == 0) {
                    throw new TTException("Missing service");
                }
                long start = System.currentTimeMillis();
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>(map.size() + 3);
                if (command != null && !command.isEmpty()) {
                    list.add(new BasicNameValuePair("cmnd", command));
                }
                xml = null;
                Set<Map.Entry<String, Object>> set = map.entrySet();
                for (Map.Entry<String, Object> entry : set) {
                    String parm = entry.getKey();
                    Object object = entry.getValue();
                    Object[] objects = object instanceof Collection ? ((Collection)object).toArray() : (object instanceof Object[] ? (Object[])object : new Object[]{object});
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object value = objectArray[n2];
                        if (value != null) {
                            list.add(new BasicNameValuePair(parm, String.valueOf(value)));
                        }
                        ++n2;
                    }
                }
                if (list.size() > 0) {
                    query = URLEncodedUtils.format(list, (String)"UTF-8");
                }
                URI uri = URIUtils.createURI((String)this.server.getProtocol().toLowerCase(), (String)this.server.getHostname(), (int)this.server.getPort(), (String)this.service, (String)query, null);
                if (query == null) {
                    query = "No Query";
                }
                byte[] objecttosend = inputs == null ? null : FMDB2ServerConnect.serialize(inputs);
                HttpGet httpRequest = objecttosend == null ? new HttpGet(uri) : this.setPost(uri, objecttosend);
                start = System.currentTimeMillis();
                try {
                    if (this.httpclient == null) {
                        this.httpclient = new ContentEncodingHttpClient();
                        this.mgr = this.httpclient.getConnectionManager();
                    }
                    CredentialsProvider provider = this.httpclient.getCredentialsProvider();
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.server.getUser(), this.server.getEPassword());
                    provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                    HttpResponse response = this.httpclient.execute((HttpUriRequest)httpRequest);
                    System.currentTimeMillis();
                    int result = response.getStatusLine().getStatusCode();
                    if (result == 200) {
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            InputStream is = response.getEntity().getContent();
                            ObjectInputStream ois = new ObjectInputStream(is);
                            Object o = ois.readObject();
                            if (o instanceof FMDB2ServerException) {
                                FMDB2ServerException e = (FMDB2ServerException)((Object)o);
                                throw e;
                            }
                            return o;
                        }
                        break block24;
                    }
                    String text = response.getStatusLine().getReasonPhrase();
                    httpRequest.abort();
                    String errorMsg = MessageFormat.format("URL Failure:{0} {1}", response, text);
                    this.log.log(Level.INFO, "URL request:{0}", uri);
                    if (result == 401) {
                        this.server.logOff();
                    }
                    throw new FMDB2ServerException(errorMsg);
                }
                catch (ClientProtocolException e) {
                    throw new TTException((Throwable)e);
                }
                catch (UnknownHostException unknownHostException) {
                    message = String.format("Unknown host %s", this.server.getHostname());
                    throw new TTException(message);
                }
                catch (HttpHostConnectException e) {
                    throw new TTException(HexUtil.getErrorText((Throwable)e));
                }
                catch (ConnectException connectException) {
                    message = String.format("Connection refused %s:%d", this.server.getHostname(), this.server.getPort());
                    throw new TTException(message);
                }
                catch (SocketException e) {
                    throw new TTException(HexUtil.getErrorText((Throwable)e));
                }
                catch (FMDB2ServerException e) {
                    throw e;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message2 = HexUtil.getErrorText((Throwable)e);
                    if (this.server.getHostname().equals(message2)) {
                        message2 = HexUtil.getErrorText((Throwable)e, (boolean)true);
                    }
                    throw new TTException(message2, (Throwable)e);
                }
            }
            this.log.log(Level.FINE, query, (Object)xml);
            return xml;
        }
        catch (FMDB2ServerException e) {
            throw e;
        }
        catch (Exception e) {
            LogRecord logrecord = new LogRecord(Level.WARNING, "Exception {0} detected while execution {1}");
            logrecord.setParameters(new Object[]{HexUtil.getErrorText((Throwable)e), query});
            logrecord.setThrown(e.getCause());
            this.log.log(logrecord);
            throw new FMDB2ServerException(e.getMessage());
        }
    }

    public static byte[] serialize(Object o) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(o);
            return out.toByteArray();
        }
        catch (NotSerializableException ne) {
            throw ne;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

