/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.Messages;
import com.ca.testingtools.common.Numbers;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileName {
    static final String cacopyright = "Copyright (c) 2017 CA";
    public static final byte IBMPDS = 1;
    public static final byte PANVALET = 2;
    public static final byte LIBRARIAN = 3;
    public static final byte HFS = 4;
    public static final byte DDNAME = 5;
    public static final byte ENDEVOR = 6;
    public static final byte IBMSEQ = 7;
    Logger log = Logger.getLogger(this.getClass().getName());
    private String DSN = "";
    private byte filetype = 0;
    public static final String[] FILE_TYPE_NAMES = new String[]{Messages.getString("FileTypePDS"), Messages.getString("FileTypePanvalet"), Messages.getString("FileTypeLibrarian"), Messages.getString("FileTypeHFS"), Messages.getString("FileTypeDDName"), Messages.getString("FileTypeEndevor"), Messages.getString("FileTypeSEQ")};
    public static final byte[] FILE_TYPES = new byte[]{1, 2, 3, 4, 5, 6, 7};
    public static final HashMap<String, Byte> FileTypes = new HashMap(7);
    private Object object;

    public FileName(byte filetype, String DSN, String member) {
        String mbr;
        this.setDSN(DSN);
        if (member != null && (mbr = member.trim()).length() > 0) {
            this.DSN = String.format("%s(%s)", this.DSN, mbr);
        }
        this.setFiletype(filetype);
    }

    public FileName(byte filetype, String DSN) {
        this(filetype, DSN, null);
    }

    public FileName(ByteBuffer buffer) {
        this.filetype = buffer.get();
        int length = Numbers.getUShort(buffer.getShort());
        if (length > 0) {
            byte[] name = new byte[length];
            buffer.get(name);
            try {
                this.DSN = new String(name, "IBM1047").trim();
            }
            catch (UnsupportedEncodingException e) {
                this.log.log(Level.INFO, "", e);
            }
        } else {
            this.DSN = "";
        }
    }

    public FileName(FileType fileType, String dsn) {
        this((byte)(fileType.ordinal() + 1), dsn, null);
    }

    public int getSize() {
        return this._getSize();
    }

    private int _getSize() {
        return 3 + this.DSN.length();
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buff = ByteBuffer.allocate(this._getSize());
        buff.put(this.filetype);
        buff.putShort((short)this.DSN.length());
        try {
            if (this.DSN.length() > 0) {
                buff.put(this.DSN.getBytes("IBM1047"));
            }
            return (ByteBuffer)buff.position(0);
        }
        catch (UnsupportedEncodingException e) {
            this.log.log(Level.INFO, "", e);
            return null;
        }
    }

    public String getDSN() {
        return this.DSN;
    }

    public void setDSN(String dsn) {
        this.DSN = dsn.trim();
    }

    public String getRootName() {
        String[] parts = this.DSN.split("[()]");
        if (parts.length > 0) {
            return parts[0];
        }
        return null;
    }

    public String getMemberName() {
        String[] parts = this.DSN.split("[()]");
        if (parts.length > 1) {
            return parts[1];
        }
        return null;
    }

    public byte getFiletype() {
        return this.filetype;
    }

    public void setFiletype(byte filetype) {
        this.filetype = filetype;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String toString() {
        return String.format("%s:%s", FileName.fileTypeString(this.filetype), this.DSN);
    }

    public static String fileTypeString(byte type) {
        for (int i = 0; i < FILE_TYPES.length; ++i) {
            if (FILE_TYPES[i] != type) continue;
            return FILE_TYPE_NAMES[i];
        }
        return String.format("Type:%d", type);
    }

    static {
        for (int i = 0; i < FILE_TYPE_NAMES.length; ++i) {
            FileTypes.put(FILE_TYPE_NAMES[i], new Byte(FILE_TYPES[i]));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        IBMPDS,
        PANVALET,
        LIBRARIAN,
        HFS,
        DDNAME,
        ENDEVOR,
        IBMSEQ;

    }
}

