/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.wizards;

import com.ca.intertest.common.LoadListing;
import com.ca.intertest.common.Member;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.server.FileConnection;
import com.ca.intertest.server.ServerElement;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;

public class loadListings
implements IRunnableWithProgress {
    static final String cacopyright = "Copyright \ufffd 2017 CA";
    private Object[] files;
    private debugSession session;
    private boolean overwrite;
    private boolean monitorpgm;
    private CheckboxTableViewer listViewer;
    private ServerElement server;

    public loadListings(Object[] files, debugSession session, boolean overwrite, boolean monitorpgm, CheckboxTableViewer listViewer, ServerElement server) {
        this.files = files;
        this.session = session;
        this.overwrite = overwrite;
        this.server = server;
        this.monitorpgm = monitorpgm;
        this.listViewer = listViewer;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Import Files", this.files.length);
        Display display = this.listViewer.getControl().getDisplay();
        FileConnection connection = new FileConnection(this.server);
        int filenumber = 0;
        while (filenumber < this.files.length) {
            if (monitor.isCanceled()) break;
            final Member member = (Member)this.files[filenumber];
            this.session.getFile(member.getName());
            member.setMonitor(this.monitorpgm);
            member.setOverwrite(this.overwrite);
            monitor.subTask(String.valueOf(Messages.loadListings_2) + member.getName() + " (" + Integer.toString(filenumber + 1) + " of " + this.files.length + ")");
            LoadListing loader = new LoadListing(connection, member, this.session, "IMPORT");
            try {
                loader.run();
            }
            catch (Exception e) {
                monitor.setCanceled(true);
                if (loader.getInterrupt() != null) break;
                loader.showError(e);
                break;
            }
            monitor.worked(1);
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    StructuredSelection sel = new StructuredSelection((Object)member);
                    loadListings.this.listViewer.setSelection((ISelection)sel, true);
                    loadListings.this.listViewer.getControl().setFocus();
                    loadListings.this.listViewer.setChecked((Object)member, false);
                }
            });
            ++filenumber;
        }
        monitor.done();
    }
}

